<?php
if (!function_exists('wceventer_enqueue_scripts')) 
{
   function wceventer_enqueue_scripts() 
	 {
		 $theme_info = wp_get_theme();
		 	wp_enqueue_script('eventer-woocommerce-scripts', EVENTER__PLUGIN_URL . 'WC/wc_scripts.js', array(), $theme_info->get( 'Version' ), false);
    }
    add_action('wp_enqueue_scripts', 'wceventer_enqueue_scripts');
}
function eventer_add_product_to_cart() 
{
	global $woocommerce;
	$product_id = (isset($_REQUEST['product']))?$_REQUEST['product']:'';
	if(!has_term('eventer', 'product_cat', $product_id)) return;
	if(get_post_type($product_id)!='product') wp_die();
	$tickets = (isset($_REQUEST['tickets']))?$_REQUEST['tickets']:'';
	$eventer_id = (isset($_REQUEST['ticket_id']))?$_REQUEST['ticket_id']:'';
	$event_date = (isset($_REQUEST['event_date']))?$_REQUEST['event_date']:'';
	$event_time = (isset($_REQUEST['event_time']))?$_REQUEST['event_time']:'';
	$event_url = (isset($_REQUEST['event_url']))?$_REQUEST['event_url']:'';
  $ticket_price = (isset($_REQUEST['ticket_price']))?$_REQUEST['ticket_price']:'';
	$cart_item_data = array('wceventer_name'=>apply_filters('eventer_raw_event_title', '', $eventer_id), 'wceventer_id'=>$eventer_id, 'wceventer_date'=>$event_date, 'wceventer_time'=>$event_time, 'wceventer_url'=>$event_url, 'eventer_custom_price'=>intval($ticket_price), 'wceventer_product'=>'ticket');
	foreach($woocommerce->cart->get_cart() as $key => $item) 
	{
    $item_id = $item['wceventer_id'];
		$cart_product_id = $item['product_id']; // the product ID
    if($eventer_id == $item_id && $product_id==$cart_product_id)
    {
        $woocommerce->cart->remove_cart_item($key);
    }
	}
  //$cart_item_data = array('price' => $_REQUEST['product_with_services_cost']);
	WC()->cart->add_to_cart( $product_id, $tickets, '', array(), $cart_item_data );
	wp_die();
}
add_action( 'wp_ajax_eventer_add_product_to_cart', 'eventer_add_product_to_cart' );
add_action( 'wp_ajax_nopriv_eventer_add_product_to_cart', 'eventer_add_product_to_cart' );

add_action( 'woocommerce_before_calculate_totals', 'add_custom_price' );

function add_custom_price( $cart ) {
    foreach ( $cart->cart_contents as $key => $value ) {
      if(isset($value['_eventer_custom_title']) && $value['_eventer_custom_title']!='')
      {
        $value['data']->set_name( $value['_eventer_custom_title'] );
      }
      if(!isset($value['eventer_custom_price'])) continue;
        $value['data']->set_price((!isset($value['eventer_custom_price']))?$value['price']:$value['eventer_custom_price']);
    }
}

function eventer_custom_pre_get_posts_query( $q ) 
{
	$tax_query = (array) $q->get( 'tax_query' );
	$tax_query[] = array(
           				'taxonomy' => 'product_cat',
           				'field' => 'slug',
           				'terms' => array( 'eventer', 'eventer_services' ), // Don't display products in the eventer category on the shop page.
           				'operator' => 'NOT IN'
    						);
	$q->set( 'tax_query', $tax_query );
}
add_action( 'woocommerce_product_query', 'eventer_custom_pre_get_posts_query' );
add_action( 'pre_get_posts' ,'eventer_custom_pre_get_posts_query' );


function eventer_add_custom_ticket_variation( $item_data, $cart_item )
{
  if (!isset($cart_item['wceventer_name'] ) )
  {
    return $item_data;
  }
  $show_order_meta_date = (isset($cart_item['wceventer_date']))?date_i18n(get_option('date_format'), $cart_item['wceventer_date']):'';
  $item_data[] = array(
        'key'     => esc_html__('Event', 'eventer'),
        'value'   => wc_clean( $cart_item['wceventer_name'] ),
        'display' => '',
  );
  $item_data[] = array(
        'key'     => esc_html__('Event Date', 'eventer'),
        'value'   => wc_clean( $show_order_meta_date.' '.$cart_item['wceventer_time'] ),
        'display' => '',
  );
  if (isset($cart_item['wceventer_services'] ) )
  {
      $item_data[] = array(
        'key'     => esc_html__('Services', 'eventer'),
        'value'   => wc_clean( $cart_item['wceventer_services'] ),
        'display' => '',
    );
  }
  return $item_data;
}
add_filter( 'woocommerce_get_item_data', 'eventer_add_custom_ticket_variation', 10, 2 );
  
  
//add_filter('woocommerce_checkout_cart_item_quantity','eventer_add_ticket_custom_option_from_session_into_cart',1,3);  
add_filter('woocommerce_cart_item_name','eventer_add_ticket_custom_option_from_session_into_cart',1,3);
add_filter('woocommerce_order_item_name','eventer_add_ticket_custom_option_from_session_into_cart', 999, 3);
if(!function_exists('eventer_add_ticket_custom_option_from_session_into_cart'))
{
	function eventer_add_ticket_custom_option_from_session_into_cart($product_name, $values, $cart_item_key )
  {
		if((!has_term('eventer', 'product_cat', $values['product_id']) && !has_term('eventer_services', 'product_cat', $values['product_id'])) || is_page(array('checkout'))) return $product_name;
    if(isset($values['_eventer_custom_title']) && $values['_eventer_custom_title']!='')
    {
      return $values['_eventer_custom_title'];
    }
    else
    {
      return get_the_title($values['product_id']);
    }
	}
}
add_action('woocommerce_new_order_item','eventer_add_values_to_order_item_meta',1,3);
if(!function_exists('eventer_add_values_to_order_item_meta'))
{
  function eventer_add_values_to_order_item_meta($item_id, $item, $order_id)
  {
    $order_item = new WC_Order_Item_Product($item_id);
    $product_id = $order_item->get_product_id(); 
		if(!has_term('eventer', 'product_cat', $product_id) && !has_term('eventer_services', 'product_cat', $product_id)) return;
  	global $woocommerce,$wpdb;
    $eventer_name = (isset($item->legacy_values['wceventer_name']))?$item->legacy_values['wceventer_name']:'';
		$wceventer_id = (isset($item->legacy_values['wceventer_id']))?$item->legacy_values['wceventer_id']:'';
		$wceventer_date = (isset($item->legacy_values['wceventer_date']))?$item->legacy_values['wceventer_date']:'';
		$wceventer_time = (isset($item->legacy_values['wceventer_time']))?$item->legacy_values['wceventer_time']:'';
		$wceventer_url = (isset($item->legacy_values['wceventer_url']))?$item->legacy_values['wceventer_url']:'';
    $wceventer_registrants = (isset($item->legacy_values['eventer_registrants']))?$item->legacy_values['eventer_registrants']:'';
    $wceventer_services = (isset($item->legacy_values['wceventer_services']))?$item->legacy_values['wceventer_services']:'';
    $wceventer_product = (isset($item->legacy_values['wceventer_product']))?$item->legacy_values['wceventer_product']:'';
    $wceventer_product_title = (isset($item->legacy_values['_eventer_custom_title']))?$item->legacy_values['_eventer_custom_title']:'';
    if(!empty($eventer_name))
    {
    	wc_add_order_item_meta($item_id, 'Event name', $eventer_name);
    }
		if(!empty($wceventer_id))
    {
    	wc_add_order_item_meta($item_id, '_wceventer_id', $wceventer_id);  
    }
		if(!empty($wceventer_date))
    {
			$show_order_meta_date = date_i18n(get_option('date_format'), $wceventer_date);
			$save_order_meta_date = date_i18n('Y-m-d', $wceventer_date);
    	wc_add_order_item_meta($item_id, 'Event Date', $show_order_meta_date.' '.$wceventer_time);  
			wc_add_order_item_meta($item_id, '_wceventer_date', $save_order_meta_date);  
    }
		if(!empty($wceventer_url))
    {
    	wc_add_order_item_meta($item_id, 'Event URL', $wceventer_url);  
    }
    if(!empty($wceventer_registrants))
    {
      wc_add_order_item_meta($item_id, '_eventer_registrants', $wceventer_registrants);
    }
    if(!empty($wceventer_services))
    {
      wc_add_order_item_meta($item_id, 'Services', $wceventer_services);
    }
    if(!empty($wceventer_product))
    {
      wc_add_order_item_meta($item_id, '_eventer_product', $wceventer_product);
    }
    if(!empty($wceventer_product_title))
    {
      wc_add_order_item_meta($item_id, '_eventer_custom_title', $wceventer_product_title);
    }
  }
}
add_action('woocommerce_before_cart_item_quantity_zero','eventer_remove_user_ticket_data_options_from_cart',1,1);
if(!function_exists('eventer_remove_user_ticket_data_options_from_cart'))
{
	function eventer_remove_user_ticket_data_options_from_cart($cart_item_key)
  {
  	global $woocommerce;
    // Get cart
    $cart = $woocommerce->cart->get_cart();
    // For each item in cart, if item is upsell of deleted product, delete it
    foreach( $cart as $key => $values)
    {
    	//if ( $values['_wceventer_id'] == $cart_item_key || $values['_wceventer_date'] == $cart_item_key)
      //unset( $woocommerce->cart->cart_contents[ $key ] );
    }
	}
}
add_filter( 'woocommerce_email_order_meta_fields', 'eventer_email_order_meta_remove_custom_field', 10, 3 );
function eventer_email_order_meta_remove_custom_field( $fields, $sent_to_admin, $order ) 
{
	// Replace HERE 'meta_key' by your custom field meta key or slug.
  unset($fields['_wceventer_id']);
  return $fields;
}
add_action('woocommerce_thankyou', 'eventer_update_tickets', 10, 1);
function eventer_update_tickets( $order_id ) 
{
	if ( ! $order_id )
        return;
	$ticket_orders = (is_array(get_option('eventer_ticket_orders')))?get_option('eventer_ticket_orders'):array();
	if(in_array($order_id, $ticket_orders))
	{
		return;
	}
	$order = wc_get_order( $order_id );
	
	$update_new_val = $new_already_booked = $cart_items = array();
	foreach ($order->get_items() as $item_key => $item_values):
    $new_already_booked = $update_new_val = array();
		$item_data = $item_values->get_data();
		$item_id = $item_values->get_id();
    $product_name = $item_data['name'];
    $product_id = $item_data['product_id'];
		if(!has_term('eventer', 'product_cat', $product_id) && !has_term('eventer_services', 'product_cat', $product_id)) continue;
    $quantity = $item_data['quantity'];
    $order_event_url = wc_get_order_item_meta($item_id, 'Event URL', true);
		$eventer_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
		$eventer_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
		$original_event = eventer_wpml_original_post_id($eventer_id);
		$booked_eventer_tickets = (!empty(get_post_meta($original_event, 'specific_eventer_tickets', true)))?get_post_meta($original_event, 'specific_eventer_tickets', true):array();
		if(array_key_exists($eventer_date, $booked_eventer_tickets))
		{
			$update_booked_tickets = $booked_eventer_tickets[$eventer_date];
		}
		else
		{
			$update_booked_tickets = get_post_meta($original_event, 'eventer_tickets', true);
		}
		$actual_booking_tickets = get_post_meta($original_event, 'eventer_tickets', true);
		$booked_tickets = get_post_meta($original_event, 'eventer_booked_tickets', true);
    
		$find_matched_details = array_column($update_booked_tickets, 'number', 'name');
		$find_matched_details_more = array_column($update_booked_tickets, 'price', 'name');
		foreach($update_booked_tickets as $ticket_ab)
		{
			$ticket_name = $ticket_ab['name'];
      $eventer_actual_ticket_key = eventer_search_ticket($ticket_name, $actual_booking_tickets);
      $eventer_booked_ticket_key = eventer_search_ticket($ticket_name, $update_booked_tickets);
      $this_ticket_values = $update_booked_tickets[$eventer_booked_ticket_key];
      $ticket_actual_price = (isset($actual_booking_tickets[$eventer_actual_ticket_key]))?$actual_booking_tickets[$eventer_actual_ticket_key]:$this_ticket_values['price'];
      $set_ticket_price = ($this_ticket_values['price']!='')?$this_ticket_values['price']:$ticket_actual_price['price'];
      $ticket_quantity = ($ticket_name==$product_name)?$quantity:0;
			$remaining = ($this_ticket_values['number']!='')?$this_ticket_values['number']:$ticket_actual_price['number'];
      $product_number = (isset($ticket_actual_price['pid']))?$ticket_actual_price['pid']:(isset($this_ticket_values['pid']))?$this_ticket_values['pid']:'';
			$remain_updated = ($ticket_name==$product_name)?$remaining-$ticket_quantity:$remaining;
      $ticket_id = '';
      $ticket_badge = (isset($this_ticket_values['badge']))?$this_ticket_values['badge']:'';
			$ticket_restrict = (isset($this_ticket_values['restrict']))?$this_ticket_values['restrict']:'';
			$new_ticket_id = ($ticket_id!='')?$ticket_id:mt_rand();
			$update_new_val[] = array('name'=>$ticket_name, 'number'=>$remain_updated, 'price'=>$set_ticket_price, 'pid'=>$product_number, 'id'=>$new_ticket_id, 'restrict'=>$ticket_restrict, 'badge'=>$ticket_badge);
		}
	$new_remaining_tickets = $update_new_val;
	$new_already_booked[$eventer_date] = $new_remaining_tickets;
	unset($booked_eventer_tickets[$eventer_date]);
	$update_new_tickets = array_merge($new_already_booked, $booked_eventer_tickets);
	update_post_meta($original_event, 'specific_eventer_tickets', $update_new_tickets);
	endforeach;
  update_post_meta($order_id, 'order_event_url', $order_event_url);
	$new_order_vals = array_unique(array_merge($ticket_orders, array($order_id)));
	update_option('eventer_ticket_orders', $new_order_vals);
}

function eventer_remove_editing_quantity( $product_quantity, $cart_item_key) {
  $cart_item = WC()->cart->cart_contents[ $cart_item_key ]; 
  $product_id = $cart_item['product_id'];
	if(!has_term('eventer', 'product_cat', $product_id) && !has_term('eventer_services', 'product_cat', $product_id)) return $product_quantity;
	$quantity = $cart_item['quantity'];
  return $quantity;
}
add_filter( 'woocommerce_cart_item_quantity', 'eventer_remove_editing_quantity', 10, 3);

function eventer_remove_permalink_thumb( $image, $cart_item, $cart_item_key ) {
  $product_id = $cart_item['product_id'];
  $event_id = $cart_item['wceventer_id'];
    if(!has_term('eventer', 'product_cat', $product_id) && !has_term('eventer_services', 'product_cat', $product_id)) return $image;
  return get_the_post_thumbnail($event_id);
} 
add_filter( 'woocommerce_cart_item_thumbnail', 'eventer_remove_permalink_thumb', 10, 3);
function eventer_change_item_key( $cart_item_data, $product_id ) {
	if(!has_term('eventer', 'product_cat', $product_id) && has_term('eventer_services', 'product_cat', $product_id)) return $cart_item_data;
  $unique_cart_item_key = md5( microtime() . rand() );
  $cart_item_data['unique_key'] = $unique_cart_item_key;
  return $cart_item_data;
}
add_filter( 'woocommerce_add_cart_item_data', 'eventer_change_item_key', 10, 2 );
add_filter( 'woocommerce_order_item_name', 'eventer_remove_hyperlink_from_order', 10, 2 );
function eventer_remove_hyperlink_from_order( $item_name, $item ) {
		if(!has_term('eventer', 'product_cat', $item['product_id']) && !has_term('eventer_services', 'product_cat', $item['product_id'])) return $item_name;
    $item_name = get_the_title($item['product_id']);
    return $item_name;
}
function eventer_add_meta_on_success($array)
{
  $order = $array['order'];
  if( $order->get_status() == "completed" )
  {
    wp_add_inline_script( 'eventer-init', 'jQuery(".eventer-show-download-tickets-form").show();' );
    $order_id = $order->get_id();
    $has_eventer = 0;
    
    foreach ($order->get_items() as $item_key => $item_values):
      $item_data = $item_values->get_data();
      $product_id = $item_data['product_id'];
      if(!has_term('eventer', 'product_cat', $product_id)) continue;
      $has_eventer = 1;
    endforeach;
    if($has_eventer==0) return $array;
    
    wp_schedule_single_event( time()+90, 'eventer_woocommerce_generate_ticket', array($order_id));
  }
  return $array;
}
add_filter( 'woocommerce_email_order_items_args', 'eventer_add_meta_on_success', 12, 1);

add_action( 'eventer_woocommerce_generate_ticket', 'eventer_woo_tickets_attachment', 10, 1);
function eventer_woo_tickets_attachment ( $order_id ) {
  $registrant_email = get_post_meta($order_id, '_billing_email', true);
  $attachments = array();
    $qrcode_name = array();
    $tickets_created = get_post_meta($order_id, 'eventer_woo_tickets_generated', true);
    if($tickets_created==1)
    {
      $tickets_registrants = get_post_meta($order_id, 'eventer_woo_registrants', true);
      if(!empty($tickets_registrants))
      {
        foreach($tickets_registrants as $ticket=>$values)
        {
            foreach($values as $value)
            {
              $qrcode_name[] = $value['ticket'];
            }
        }
      }
      $tickets_folder = get_post_meta($order_id, 'eventer_woo_tickets_folder', true);
      wp_schedule_single_event( time(), 'generate_ticket_for_registrants', array($registrant_email, $order_id, array(), '', $qrcode_name, '', $tickets_folder));
      //spawn_cron(time());
    }
}

function eventer_change_product_meta_key( $display_key ) { 
    if($display_key=="Event Ticket")
    {
      $display_key = esc_html__('Event Ticket', 'eventer');
    }
    elseif($display_key=="Event name")
    {
      $display_key = esc_html__('Event name', 'eventer');
    }
    elseif($display_key=="Event Date")
    {
      $display_key = esc_html__('Event Date', 'eventer');
    }
    elseif($display_key=="Event URL")
    {
      $display_key = esc_html__('Event URL', 'eventer');
    }
    elseif($display_key=="Services")
    {
      $display_key = esc_html__('Services', 'eventer');
    }
    return $display_key; 
}; 
add_filter( 'woocommerce_order_item_display_meta_key', 'eventer_change_product_meta_key', 10, 1 ); 

add_action( 'woocommerce_thankyou', 'eventer_generate_ticket_for_woocommerce', 20 );
add_action( 'woocommerce_view_order', 'eventer_generate_ticket_for_woocommerce', 20 );
function eventer_generate_ticket_for_woocommerce( $order_id )
{
  $nonce_qrcode = wp_create_nonce( 'eventer-qrcode-nonce' );
  $registered_ticket = $ticket_num_st = $elocation = '';
  $registrant_uname = get_post_meta($order_id, '_billing_first_name', true).' '.get_post_meta($order_id, '_billing_last_name', true);
  $registrant_email = get_post_meta($order_id, '_billing_email', true);
  $order = wc_get_order( $order_id );
  $order_items_start = 1;
  $organizer_email = $elocation = $all_registrant_data = '';
	foreach ($order->get_items() as $item_key => $item_values):
    $item_data = $item_values->get_data();
		$item_id = $item_values->get_id();
    $product_id = $item_data['product_id'];
    $eventer_product = wc_get_order_item_meta($item_id, '_eventer_product', true);
    if((!has_term('eventer', 'product_cat', $product_id) && !has_term('eventer_services', 'product_cat', $product_id)) || $eventer_product=='service') continue;
		$event_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
    $event_time = get_post_meta($event_id, 'eventer_event_start_dt', true);
    $event_time = date_i18n(get_option('time_format'), strtotime($event_time));
    $event_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
    $event_registrants = wc_get_order_item_meta($item_id, '_eventer_registrants', true);
    
    $event_date = strtotime($event_date);
		$product_name = $item_data['name'];
		$quantity = $item_data['quantity'];
    $order_num = 'we'.$order_id.'-'.$order_items_start;
    $eventer_organizer = get_the_terms($event_id, 'eventer-organizer');
    $eventer_venue = get_the_terms($event_id, 'eventer-venue');
    
    if(!is_wp_error($eventer_venue)&&!empty($eventer_venue))
    {
      foreach($eventer_venue as $venue)
      {
        $location_address = get_term_meta($venue->term_id, 'venue_address', true);
        $elocation = ($location_address!='')?$location_address:$venue->name;
      }
    }
    if(!is_wp_error($eventer_organizer)&&!empty($eventer_organizer))
    {
      foreach($eventer_organizer as $organizer)
      {
        $organizer_email = get_term_meta($organizer->term_id, 'organizer_email', true);
      }
    }
    if($order_items_start==1)
    {
      $back_order_tickets = (isset($_REQUEST['backorder']))?wp_get_referer():'';
      $all_registrant_data .= '<div class="eventer-all-registrants" style="" data-backorder="'.esc_attr($back_order_tickets).'" data-regpos="'.esc_attr(14).'" data-mainreg="'.$registrant_email.'" data-registrant="'.esc_attr($order_id).'" data-eid="'.esc_attr($product_id).'" data-organizer="'.$organizer_email.'" data-nonce="'.$nonce_qrcode.'">';
    }
    if(!empty($event_registrants))
    {
      foreach($event_registrants as $each_registrant)
      {
        $ticket_reg_name = (isset($each_registrant['name']))?$each_registrant['name']:'';
        $ticket_reg_email = (isset($each_registrant['email']) && $each_registrant['email']!='')?$each_registrant['email']:$registrant_email;
        if($ticket_reg_name=='') continue;
        $all_registrant_data .= '<span class="eventer-registrant-show" data-ticket="'.esc_attr($product_name).'" data-qrcode="'.esc_attr($order_num).'" data-img="" data-elocation="'.esc_attr($elocation).'" data-datetime="'.esc_attr($event_time).'<br>'.esc_attr(date_i18n(get_option('date_format'), $event_date)).'" data-eventid="'.esc_attr(get_the_title($event_id)).'" data-email="'.$ticket_reg_email.'" data-name="'.$ticket_reg_name.'"></span>';
      }
    }
    else
    {
      $all_registrant_data .= '<span class="eventer-registrant-show" data-ticket="'.esc_attr($product_name.' X '.$quantity).'" data-qrcode="'.esc_attr($order_num).'" data-img="" data-elocation="'.esc_attr($elocation).'" data-datetime="'.esc_attr($event_time).'<br>'.esc_attr(date_i18n(get_option('date_format'), $event_date)).'" data-eventid="'.esc_attr(get_the_title($event_id)).'" data-email="'.$registrant_email.'" data-name="'.$registrant_uname.'"></span>';
    }
    if(count($order->get_items()) == $order_items_start)
    {
      $all_registrant_data .= '</div>';
    }
    $order_items_start++;
	endforeach;
  
  echo $all_registrant_data;
  echo '<div style="opacity:0;" class="eventer eventer-temporary-tickets eventer-woo-tickets-create eventer_woo_tickets_to_hide">
   <div style="width:300px;" id="eventer-ticket-printable" class="eventer-ticket-final-tickets" data-nonce="'.$nonce_qrcode.'" data-uname="'.esc_attr($registrant_uname).'" data-uemail="'.$registrant_email.'" data-eid="'.esc_attr($order_id).'" data-regpos="'.esc_attr(14).'" data-registrant="'.esc_attr($order_id).'">
								<div class="eventer-ticket-printable">
									<div class="eventer-ticket-printable-top">
										<div class="eventer-qrcode eventer-on-ticket-qr" data-qr-content="'.esc_attr($order_num).'"></div>
										<label class="eventer-ticket-reg-code">'.esc_attr($order_num).'</label>
									</div>
									<div class="eventer-ticket-printable-bottom">
										<label>'.esc_html__('Attendee', 'eventer').'</label>
										<h3>'.esc_attr($registrant_uname).'</h3>
										<label>'.esc_html__('Event', 'eventer').'</label>
										<p class="eventer-woo-title">title</p>
										<div class="eventer-spacer-10"></div>
										<label>'.esc_html__('Ticket', 'eventer').'</label>
										<div class="registrant-ticket">'.$registered_ticket.'</div>
										<div class="eventer-spacer-10"></div>
										<div class="eventer-row">
											<div class="eventer-col5">
												<label>'.esc_html__('Venue Location', 'eventer').'</label>
												<p class="eventer-woo-location">'.esc_attr($elocation).'</p>
											</div>
											<div class="eventer-col5">
												<label>'.esc_html__('Date &amp; Time', 'eventer').'</label>
												<p class="eventer-woo-datetime">time</p>
											</div>
										</div>
										<div class="eventer-spacer-10"></div>
									</div>
								</div>
							</div>';
      echo '</div>';
}
add_action( 'woocommerce_thankyou', 'eventer_show_thanks_page_download_button', 1);
 
function eventer_show_thanks_page_download_button($order_id) {
    echo '<form action="'.esc_url(admin_url( 'admin-ajax.php' )).'" method="post" class="eventer-show-download-tickets-form" style="display:none;">';
    echo '<input type="hidden" name="action" value="eventer_woo_download_tickets">';
    echo '<input type="hidden" class="eventer-woo-tickets" name="tickets" value="">';
    echo '<input type="hidden" name="captcha" value="'.wp_create_nonce('eventer-tickets-download').'">';
    echo '<input type="submit" value="'.esc_html__('Download Tickets', 'eventer').'" class="button"></form><br/>';
}
add_action( 'woocommerce_thankyou', 'eventer_create_booking_woocommerce', 999);
 
function eventer_create_booking_woocommerce($order_id)
{
  if(!empty(get_post_meta($order_id, 'eventer_order_recorded', true))) return;
  $registrant_uname = get_post_meta($order_id, '_billing_first_name', true).' '.get_post_meta($order_id, '_billing_last_name', true);
  $registrant_email = get_post_meta($order_id, '_billing_email', true);
  $order = wc_get_order( $order_id );
  $event_ids = $registrants = $all_tickets = $all_services = $reg_details = $ticket_wise_registrants = array();
  foreach ($order->get_items() as $item_key => $item_values):
    $item_data = $item_values->get_data();
		$item_id = $item_values->get_id();
    $product_id = $item_data['product_id'];
    $eventer_product_type = wc_get_order_item_meta($item_id, '_eventer_product', true);
    if($eventer_product_type=='') continue;
    $event_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
		$event_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
    $event_ids[$event_id.'-'.mt_rand()] = $event_date;
    $event_time = get_post_meta($event_id, 'eventer_event_start_dt', true);
    $event_time = date_i18n(get_option('time_format'), strtotime($event_time));
    $event_registrants = wc_get_order_item_meta($item_id, '_eventer_registrants', true);
    $registrants[$event_id.'-'.mt_rand()] = $event_registrants;
    $event_date = strtotime($event_date);
		$product_name = $item_data['name'];
		$quantity = $item_data['quantity'];
    $all_tickets[] = array('name'=>$product_name, 'quantity'=>$quantity, 'number'=>$quantity);
    $ticket_wise_registrants[] = array('event'=>$event_id, 'date'=>$event_date, 'type'=>$eventer_product_type, 'ticket'=>$product_name, 'quantity'=>$quantity, 'registrants'=>$event_registrants);
    if($eventer_product_type!='ticket')
    {
      $all_services[] = array('name'=>$product_name, 'quantity'=>$quantity);
    }
    
  endforeach;
  $current_date = date_i18n('Y-m-d G:i');
  $transID = $order->get_transaction_id();
  $payment_method = $order->get_payment_method();
  $ip = eventer_client_ip();
  $status = $order->get_status();
  $amount = $order->get_total();
  $user_system_data = serialize(array('ip'=>$ip, 'services'=>$all_services, 'tickets'=>$ticket_wise_registrants, 'registrants'=>$registrants, 'events'=>$event_ids));
  $eventer_date = '';
  global $wpdb;
			$table_name = $wpdb->prefix."eventer_registrant";
			$wpdb->query( $wpdb->prepare( 
				"INSERT INTO $table_name
				( eventer, transaction_id , username, email, paymentmode, user_details, tickets, ctime, status, amount, user_system)
				VALUES ( %d, %s, %s, %s, %s, %s, %s, %s, %s, %d, %s )", 
				array($order_id, $transID, $registrant_uname, $registrant_email, $payment_method, serialize($reg_details), serialize($all_tickets), $current_date, $status, $amount, $user_system_data) 
				) 
			);
  update_post_meta($order_id, 'eventer_order_recorded', $wpdb->insert_id);
}

add_action( 'woocommerce_widget_shopping_cart_buttons', function(){
    // Removing Buttons
    remove_action( 'woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_button_view_cart', 10 );
    remove_action( 'woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_proceed_to_checkout', 20 );

    // Adding customized Buttons
    add_action( 'woocommerce_widget_shopping_cart_buttons', 'eventer_custom_widget_shopping_cart_button_view_cart', 10 );
    add_action( 'woocommerce_widget_shopping_cart_buttons', 'eventer_custom_widget_shopping_cart_button_view_cart', 20 );
}, 1 );

// Custom cart button
function eventer_custom_widget_shopping_cart_button_view_cart() {
  echo '';
}
add_action( 'woocommerce_order_status_changed', 'eventer_update_booking_status' );
function eventer_update_booking_status( $order_id) {
  if( is_admin()){
    $order = wc_get_order( $order_id );
    $status = $order->get_status();
     $registrant_id = get_post_meta($order_id, 'eventer_order_recorded', true);
     eventer_update_registrant_details(array('status' => $status), $registrant_id, array("%s", "%s"));
  }
}
