<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
add_action( 'add_meta_boxes_eventer', 'wceventer_add_event_fields' );
add_action( 'save_post', 'wceventer_update_event_tickets_data', 1, 2 );
/**
 * Add custom Meta Box to Posts post type
 */
function wceventer_add_event_fields() 
{
    add_meta_box('eventer_event_schedule',__('Event Tickets','eventer'),'wceventer_event_tickets_output','eventer','normal','core');
    add_meta_box('eventer_event_schedule_datewise',__('Date Wise Event Booking Record','eventer'),'wceventer_event_tickets_output_datewise','eventer','normal','core');
}
/**
 * Print the Meta Box content
 */
function wceventer_event_tickets_output() 
{
    global $post;
	// Add an nonce field so we can check for it later.
	wp_nonce_field( 'eventer_event_schedule_meta_box', 'eventer_event_tickets_meta_box_nonce' );
	$original_event = eventer_wpml_original_post_id($post->ID);
	$tickets = get_post_meta($original_event, 'wceventer_tickets', true);
  $total_tickets_count = ($tickets=='' || count($tickets)<3)?3:count($tickets);
	if($original_event!=$post->ID && $original_event!='')
	{
		echo '<div id="field_group">
    			<div id="field_wrap">';
		echo '<div id="add_field_row">
      		<p>'.esc_attr__('You can not add ticket for this event, as this event is the copy of ', 'eventer').get_the_title($original_event).'</p>
    			</div>';
		echo '</div></div>';
	}
	else
	{
?>
<div class="eventer-form-table">
<table class="form-table eventer-admin-woo-tickets-table">
	<tr>
		<th><strong><?php esc_html_e('Ticket Type', 'eventer'); ?></strong></th>
        <th><strong><?php esc_html_e('No of Tickets', 'eventer'); ?></strong></th>
        <th><strong><?php esc_html_e('Price', 'eventer'); ?></strong></th>
		<th><strong><?php esc_html_e('Woocommerce Ticket Actions', 'eventer'); ?></strong></th>
	</tr>
        <?php 
				$tickets_ids = $tickets_field = $ticket_identification = '';
				$eventer_term_id = get_term_by('slug', 'eventer', 'product_cat');
				$tickets_field .= '<option value="add">'.esc_html__('Add new', 'eventer').'</option>';
				if(!is_wp_error($eventer_term_id) && !empty($eventer_term_id))
				{
					$tickets_ids = get_objects_in_term($eventer_term_id->term_id, 'product_cat');
					foreach($tickets_ids as $ids)
					{
						if(get_post_type($ids)!='product' || get_post_status($ids)!='publish') continue;
						$tickets_field .= '<option value="'.$ids.'">'.get_the_title($ids).'</option>';
					}
				}
				for($field=0; $field<$total_tickets_count; $field++) {
				$ticket_price = $ticket_name = $ticket_number = '';
				$ticket_id = (isset($tickets[$field]['wceventer_ticket_id']) && get_post_type($tickets[$field]['wceventer_ticket_id'])=='product' && get_post_status($tickets[$field]['wceventer_ticket_id'])=='publish')?$tickets[$field]['wceventer_ticket_id']:'';
				$ticket_status_text = esc_html__('Add');
				$ticket_status_val = 'add';
				if($ticket_id!='' && get_post_type($ticket_id)=='product')
				{
					if(function_exists('wc_get_product'))
					{
						$_product = wc_get_product( $ticket_id );
						$ticket_price = $_product->get_price();
					}
					$ticket_name = get_the_title($ticket_id);
					$ticket_number = (isset($tickets[$field]['wceventer_ticket_number']))?$tickets[$field]['wceventer_ticket_number']:'';
					$ticket_status_text = esc_html__('Update');
					$ticket_status_val = 'update';
          $ticket_identification = (isset($tickets[$field]['id']))?$tickets[$field]['id']:''; 
				}
		?>
	<tr class="wc_ticket_section" data-wcticket="">
	<input type="hidden" name="wceventer_ticket_id[]" value="<?php echo esc_attr($ticket_id); ?>"/>
	<td><input type="text"  name="wceventer_ticket_name[]" class="meta_feat_title" value="<?php echo esc_attr($ticket_name); ?>" placeholder="<?php esc_html_e('Name of Ticket', 'eventer'); ?>"></td>
	<td><input type="text" name="wceventer_ticket_number[]" class="meta_feat_title" value="<?php echo esc_attr($ticket_number); ?>" placeholder="<?php esc_html_e('No of Tickets', 'eventer'); ?>"></td>
	<td><input class="meta_sch_title"  name="wceventer_ticket_price[]" value="<?php echo esc_attr($ticket_price); ?>" type="text" placeholder="<?php esc_html_e('Price', 'eventer'); ?>">
  	<input type="hidden" value="<?php echo esc_attr($ticket_identification); ?>" name="eventer_ticket_identification[]"></td>
	<td>
		<?php if($ticket_status_val!='add') { ?>
		<input checked="checked" type="radio" name="wceventer_ticket_status<?php echo esc_attr($field); ?>" value="<?php echo esc_attr($ticket_status_val); ?>"> 
		<?php echo esc_attr($ticket_status_text); }
					else { 
						echo '<select name="wceventer_ticket_status'.esc_attr($field).'">';
						echo $tickets_field;
						echo '</select>'; }
		if($ticket_id!='' && get_post_type($ticket_id)=='product')
				{ ?>
		<input type="radio" name="wceventer_ticket_status<?php echo esc_attr($field); ?>" value="del"> <?php esc_html_e('Remove', 'eventer'); ?>
		<br><small><a href="<?php echo get_edit_post_link( $ticket_id); ?>" class="more_options" target="_blank"><?php esc_html_e('View Ticket Woocommerce Product', 'eventer'); ?></a></small></td>
	<?php } ?>
	</tr>
<?php } ?>
<tr class="eventer_admin_new_additional_ticket" data-wcticket="" style="display:none;">
	<input type="hidden" name="wceventer_ticket_id[]" value=""/>
	<td><input type="text"  name="" class="meta_feat_title eventer-admin-dynamic-ticket-name" value="" placeholder="<?php esc_html_e('Name of Ticket', 'eventer'); ?>"></td>
	<td><input type="text" name="wceventer_ticket_number[]" class="meta_feat_title" value="" placeholder="<?php esc_html_e('No of Tickets', 'eventer'); ?>"></td>
	<td><input class="meta_sch_title"  name="wceventer_ticket_price[]" value="" type="text" placeholder="<?php esc_html_e('Price', 'eventer'); ?>">
  	<input type="hidden" value="" name="eventer_ticket_identification[]"></td>
	<td>
		<?php 
						echo '<select class="eventer-admin-dynamic-ticket-action" name="">';
						echo $tickets_field;
						echo '</select>';
            ?>
  </td>
	</tr>

</table>
<button name="eventer_admin_add_more_ticket" class="eventer_admin_add_more_ticket button"><?php esc_html_e('Add Ticket', 'eventer'); ?></button>
    <div id="add_field_row">
      	<p class="field-description"><?php echo esc_attr_e('Do not add currency in price field, currency should be selected from WooCommerce => Settings => General', 'eventer'); ?></p>
		<p class="field-description"><?php echo esc_attr_e('Ticket quantity is maintained on per date basis by the Eventer plugin only. Quantity/SKU/Inventory of WooCommerce product will not work here. Add quantity here for the ticket type which will be avilable for all events using the same ticket type.', 'eventer'); ?></p>
		<p class="field-description"><?php echo esc_attr_e('To add a new ticket type, enter the name, quantity and price for it and select "Add New" from the dropdown. To use a pre built ticket type select it from the dropdown available.', 'eventer'); ?></p>
    </div>
</div>
  <?php
	}
}

function wceventer_event_tickets_output_datewise() 
{
    global $post;
	// Add an nonce field so we can check for it later.
	wp_nonce_field( 'eventer_event_schedule_meta_box', 'eventer_event_tickets_meta_box_nonce');
	$all_dates = get_post_meta($post->ID, 'eventer_all_dates', true);
  $original_event = eventer_wpml_original_post_id($post->ID);
	$tickets = get_post_meta($original_event, 'wceventer_tickets', true);
  $total_tickets_count = ($tickets=='' || count($tickets)<3)?3:count($tickets);
?>
<div id="field_group" class="booked_ticket_section">
    <div id="field_wrap">
       	<select name="event_date_wise_bookings" class="generate_eventer_bookings" data-eventer="<?php echo esc_attr($post->ID); ?>">
			<option value="" selected><?php esc_html_e('Select', 'eventer'); ?></option>
			<option value="1"><?php esc_html_e('Enable Reset Button', 'eventer'); ?></option>
			<?php
				$all_dates = array_filter($all_dates, function($date){
				$start = date_i18n('Y-m-d G:i',strtotime(date_i18n("Y-m-d", time()) . " - 730 day"));
				$end = date_i18n('Y-m-d G:i',strtotime(date_i18n("Y-m-d", time()) . " + 730 day"));
				return (strtotime($date) >= strtotime($start) and strtotime($date) <= strtotime($end));
				});
				foreach($all_dates as $date)
				{
					echo '<option value="'.esc_attr($date).'">'.esc_attr($date).'</option>';
				}
				
			?>
		</select>
      	<span class="dashicons dashicons-update eventer-loading" style="display: none"></span>
       		
        <div class="field_row">
        	<table class="form-table">
        		<tr>
					<td width="30%"><strong><?php esc_html_e('Ticket Type', 'eventer'); ?></strong></td>
					<td width="30%"><strong><?php esc_html_e('Available Tickets', 'eventer'); ?></strong></td>
					<td width="30%"><strong><?php esc_html_e('Price', 'eventer'); ?></strong></td>
					<td width="10%"><strong><?php //esc_html_e('Restriction', 'eventer'); ?></strong></td>
				</tr>
			</table>
        </div>
        <div class="clear"></div>
        <?php 
				for($field=0; $field<$total_tickets_count; $field++) {
					$random_ticket_number = $post->ID+$field;
					$ticket_backend_generate = $random_ticket_number*2648;
          $already_booked_ids = get_post_meta($post->ID, 'wceventer_tickets', true);
          $product_id = (isset($already_booked_ids[$field]['wceventer_ticket_id']))?$already_booked_ids[$field]['wceventer_ticket_id']:'';
				?>
        <div class="field_row">
        <div class="field_left booked_eventer_section">
			<table class="form-table">
				<tr>
					<td width="30%"><input disabled type="text" class="meta_feat_title booked_record_event_title booked_fields" value="" placeholder="<?php esc_html_e('Name of Ticket', 'eventer'); ?>" style="width: 100%"></td>
					<td width="30%"><input disabled type="text" class="meta_feat_title booked_record_event_number booked_fields" value="" placeholder="<?php esc_html_e('Available Tickets', 'eventer'); ?>" style="width: 100%"></td>
					<td width="30%"><input disabled class="meta_sch_title booked_record_event_price booked_fields" value="" type="text" placeholder="<?php esc_html_e('Price', 'eventer'); ?>" style="width: 100%"></td>
					<td width="10%"><label><input class="meta_sch_title booked_record_event_restrict booked_fields" value="1" type="checkbox" style="width: 100%; display: none;"><input type="hidden" value="<?php echo esc_attr($product_id); ?>" class="booked_fields booked_record_event_pid eventer-admin-ticket-woo-id"></label></td>
					<td style="display: none;"><input class="meta_sch_title booked_record_event_id booked_fields" type="hidden"></td>
				</tr>
			</table>
        </div>
        <div class="clear"></div> 
  	</div>
    <?php } ?>
	<hr>
	<p>
		<label><?php esc_html_e('Add custom label for the selected date event', 'eventer'); ?></label><br>
    	<input type="text" class="eventer_admin_badge booked_record_event_badge" placeholder="<?php esc_html_e('Add Label', 'eventer'); ?>">
	</p>
    <button disabled data-eventer="<?php echo esc_attr($post->ID); ?>" data-position="save" type="button" class="button button-primary update_booked_tickets save_booked_btn"><?php esc_html_e('Save', 'eventer'); ?></button>
    <button disabled data-eventer="<?php echo esc_attr($post->ID); ?>" data-position="reset" type="button" class="button update_booked_tickets reset_booked_btn"><?php esc_html_e('Reset All Dates to Default', 'eventer'); ?></button>
    <div id="add_field_row">
      	<p class="field-description"><?php echo esc_attr_e('Do not add currency in price field, currency should be selected from PayPal Configuration Settings', 'eventer'); ?></p>
      	<p class="field-description"><?php echo esc_attr_e('Events dates are listing only between two years before and two years after from current date.', 'eventer'); ?></p>
      	<p class="field-description"><?php echo esc_attr_e('Ticket details are showing through original events of this language, like ticket details of default language of this post.', 'eventer'); ?></p>
      	<p class="field-description"><?php echo esc_attr_e('Label: A custom label is a small piece of text you can show next to event title. This can be used to show a small message like "Upcoming" next to event title. This field can be used differently for each selected date in this section.', 'eventer'); ?></p>
    </div>
</div>
</div>
  <?php
}
/**
 * Save post action, process fields
 */
function wceventer_update_event_tickets_data( $post_id, $post_object ) 
{
	//echo count($_POST['wceventer_ticket_name']); exit;
	if ( ! isset( $_POST['eventer_event_tickets_meta_box_nonce'] ) ) 
	{
		return;
	}
	$update_meta_box = array();
	// Verify that the nonce is valid.
	if ( ! wp_verify_nonce( $_POST['eventer_event_tickets_meta_box_nonce'], 'eventer_event_schedule_meta_box' ) ) {
		return;
	}
    // Doing revision, exit earlier **can be removed**
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )  
        return;
    // Doing revision, exit earlier
    if ( 'revision' == $post_object->post_type )
        return;
    // Verify authenticity
	// Check the user's permissions.
	if ( isset( $_POST['post_type'] ) && 'eventer' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) {
			return;
		}
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
	} 
	$booked_tickets = $update_meta_box = $new_booked_tickets = array();
	if(isset($_POST['wceventer_ticket_name']))
	{
		$total_tickets = count($_POST['wceventer_ticket_name']); echo $total_tickets.'ssssss';
		for($i=0; $i<$total_tickets; $i++) 
		{
			if(!empty($_POST['wceventer_ticket_name'][$i]) || get_post_type($_POST['wceventer_ticket_status'.$i])=='product')
			{
				//if($i==5) exit;
				$ticket_name = $_POST['wceventer_ticket_name'][$i];
				$ticket_price = $_POST['wceventer_ticket_price'][$i];
        $ticket_backend_generate = (isset($_POST['eventer_ticket_identification'][$i]) && $_POST['eventer_ticket_identification'][$i]!='')?$_POST['eventer_ticket_identification'][$i]:mt_rand();
				if($ticket_name!='' && ($post_object->post_type == 'eventer') && $_POST['wceventer_ticket_status'.$i]=='add')
				{
					$product_arg = array('post_type'=>'product', 'post_title'=>$ticket_name, 'post_status'=>'publish');
					$product_id = wp_insert_post($product_arg);
          if ( function_exists('icl_object_id') && class_exists('SitePress'))
          {
            wpml_add_translatable_content( 'post_product', $product_id, EVENTER__LANGUAGE_CODE );
          }
					wp_set_object_terms($product_id, 'eventer', 'product_cat');
					update_post_meta($product_id, '_regular_price', (float)$ticket_price);
    			update_post_meta($product_id, '_price', (float)$ticket_price);
          update_post_meta($product_id, '_virtual', 'yes');
					$update_meta_box[] = array('wceventer_ticket_id'=>$product_id, 'wceventer_ticket_number'=>$_POST['wceventer_ticket_number'][$i]);
					$booked_tickets[] = array('name'=>$ticket_name, 'number'=>$_POST['wceventer_ticket_number'][$i], 'price'=>$ticket_price, 'pid'=>$product_id, 'id'=>$ticket_backend_generate, 'restrict'=>'');
					$new_booked_tickets[$ticket_name] = $_POST['wceventer_ticket_number'][$i];
				}
				elseif($ticket_name!='' && ($post_object->post_type == 'eventer') && $_POST['wceventer_ticket_status'.$i]=='update')
				{
					$ticket_id = $_POST['wceventer_ticket_id'][$i];
					$product_arg = array('ID'=>$ticket_id, 'post_type'=>'product', 'post_title'=>$ticket_name, 'post_status'=>'publish');
					wp_update_post($product_arg);
					update_post_meta($ticket_id, '_regular_price', (float)$ticket_price);
    			update_post_meta($ticket_id, '_price', (float)$ticket_price);
					$update_meta_box[] = array('wceventer_ticket_id'=>$ticket_id, 'wceventer_ticket_number'=>$_POST['wceventer_ticket_number'][$i]);
					$booked_tickets[] = array('name'=>$ticket_name, 'number'=>$_POST['wceventer_ticket_number'][$i], 'price'=>$ticket_price, 'pid'=>$ticket_id, 'id'=>$ticket_backend_generate, 'restrict'=>'');
					$new_booked_tickets[$ticket_name] = $_POST['wceventer_ticket_number'][$i];
				}
				elseif(($post_object->post_type == 'eventer') && get_post_type($_POST['wceventer_ticket_status'.$i])=='product')
				{
					$ticket_id = $_POST['wceventer_ticket_status'.$i];
					$ticket_name = get_the_title($ticket_id);
					$ticket_price = get_post_meta($ticket_id, '_price', true);
					$update_meta_box[] = array('wceventer_ticket_id'=>$ticket_id, 'wceventer_ticket_number'=>$_POST['wceventer_ticket_number'][$i]);
					$booked_tickets[] = array('name'=>$ticket_name, 'number'=>$_POST['wceventer_ticket_number'][$i], 'price'=>$ticket_price, 'pid'=>$ticket_id, 'id'=>$ticket_backend_generate, 'restrict'=>'');
					$new_booked_tickets[$ticket_name] = $_POST['wceventer_ticket_number'][$i];
				}
				elseif($ticket_name!='' && ($post_object->post_type == 'eventer') && $_POST['wceventer_ticket_status'.$i]=='del')
				{
					$ticket_id = $_POST['wceventer_ticket_id'][$i];
					wp_trash_post( $ticket_id  );
				}
			}

		}
		update_post_meta($post_id, 'wceventer_tickets', $update_meta_box);
		update_post_meta($post_id, 'eventer_tickets', $booked_tickets);
		update_post_meta($post_id, 'eventer_booked_tickets', $new_booked_tickets);
	}
}
