<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
if(!function_exists('load_custom_wp_admin_scripts'))
{
	/*
	* load_custom_wp_admin_scripts function
	* Enqueue the style and js for back end
	* Variables of strings are used to send them in js file using wp_localize_script function, so that they can be fully translatable
	*/
	function load_custom_wp_admin_scripts($hook) {
		$screen = get_current_screen();
		if ( 'edit.php' != $hook && $screen->post_type!='eventer' ) {
			return;
		}
		$category_eventer = '';
		$google_map_api = eventer_get_settings( 'google_apikey' );
		$multiple_days_message = esc_html__('Recurring options will not work if you select event of more than one day/24 hours.', 'eventer');
		$primary_button = esc_html__('Primary', 'eventer');
		$saving_btn = esc_html__('Saving', 'eventer');
		$save_btn = esc_html__('Save', 'eventer');
		$remove_btn = esc_html__('Remove', 'eventer');
		$eventer_id = (isset($_REQUEST['post']))?get_post_meta($_REQUEST['post'], 'eventer_primary_term', true):'';
		$shortcode_copy = esc_html__('shortcode copied to clipboard', 'eventer');
		wp_enqueue_script('jquery-ui-datepicker');
		if(isset($_REQUEST['taxonomy'])=='eventer-venue'){
				wp_enqueue_media();
		}
		if(isset($_REQUEST['taxonomy'])=='eventer-category' || isset($_REQUEST['page'])=='eventer_settings_options')
		{
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_style('wp-color-picker');
			$category_eventer = 1;
		}
		$screen = get_current_screen();
		$screen_taxonomy = (property_exists($screen, 'taxonomy'))?$screen->taxonomy:'';
		wp_enqueue_style('eventer_ui_css','//ajax.googleapis.com/ajax/libs/jqueryui/1.9.0/themes/base/jquery-ui.css',false,"1.9.0",false);
		wp_enqueue_style( 'eventer_datetimepicker', EVENTER__PLUGIN_URL . 'css/jquery.simple-dtpicker.css');
		wp_enqueue_script( 'eventer_datetimepicker', EVENTER__PLUGIN_URL . 'js/jquery.simple-dtpicker.js', array('jquery-ui-core'), '', true);
		wp_enqueue_script( 'eventer_ui_plugins', EVENTER__PLUGIN_URL . 'js/jquery-ui.multidatespicker.js', array('jquery-ui-core'), '', true);
		wp_enqueue_script( 'eventer_admin_gmap_autocomplete', '//maps.googleapis.com/maps/api/js?libraries=places&key='.$google_map_api);
		wp_enqueue_script( 'eventer_admin_scripts', EVENTER__PLUGIN_URL . 'js/admin_scripts.js', array('jquery'), '', true);
		wp_localize_script('eventer_admin_scripts', 'dynamicval', array('multiplemsg' => $multiple_days_message, 'ajax_url' => admin_url( 'admin-ajax.php' ), 'venue_nonce'=> wp_create_nonce("eventer_make_event_primary_venue_nonce"), 'eventer'=>$eventer_id, 'event_cat'=>$category_eventer, 'registrant_remove_nonce'=> wp_create_nonce("eventer_remove_registrant_nonce"), 'shortcode_copied'=>$shortcode_copy, 'primary_btn'=>$primary_button, 'gmap_api'=>$google_map_api, 'screen_tax'=>$screen_taxonomy, 'saving_btn' => $saving_btn, 'save_btn'=>$save_btn, 'remove_btn'=>$remove_btn));
		wp_enqueue_style( 'eventer_admin_style', EVENTER__PLUGIN_URL . 'css/admin_style.css');

	}
	add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_scripts' );
}

if(!function_exists('eventer_get_post_language'))
{
	/*
	* eventer_get_post_language function
	* Get language of post while using WPML plugin
	*/
	function eventer_get_post_language($post_id){
		if (class_exists('SitePress')) 
		{
			global $wpdb;
			$query = $wpdb->prepare('SELECT language_code FROM ' . $wpdb->prefix . 'icl_translations WHERE element_id="%d"', $post_id);
			$query_exec = $wpdb->get_row($query);
			if(!empty($query_exec))
			{
				return $query_exec->language_code;
			}
		}
	}
	//add_action('init', 'eventer_get_post_language');
}

if(!function_exists('eventer_add_form_fields_venue'))
{
	/*
	* eventer_add_form_fields_venue function
	* Make term description field to WYSIWYG, if yoast seo plugin activated then this function will not work
	*/
	function eventer_add_form_fields_venue($term, $taxonomy){
			?>
			<table class="form-table">
			<tbody>
			<tr valign="top" class="form-field">
					<th scope="row">
						<label><?php esc_html_e('Description', 'eventer'); ?></label>
					</th>
					<td>
							<?php wp_editor(html_entity_decode($term->description), 'description', array('media_buttons' => true)); ?>
							<script>
									jQuery(window).ready(function(){
											jQuery('label[for=description]').parent().parent().remove();
									});
							</script>
					</td>
			</tr>
			</tbody>
			</table>
			<?php
	}
	if(is_admin() && function_exists('is_plugin_active') && !is_plugin_active('wordpress-seo/wp-seo.php'))
	{
		$taxonomies = array('eventer-venue', 'eventer-category', 'eventer-organizer', 'eventer-tag');
		foreach($taxonomies as $taxonomy)
		{
			add_action("{$taxonomy}_edit_form_fields", 'eventer_add_form_fields_venue', 10, 2);
		}
		remove_filter( 'pre_term_description', 'wp_filter_kses' );
		remove_filter( 'term_description', 'wp_kses_data' );
	}
}

function eventer_date_sort($a, $b) {
    return strtotime($a) - strtotime($b);
}

if(!function_exists('eventer_find_non_recurring_events'))
{
	/*
	* eventer_find_non_recurring_events function
	* This function create array of all dates of recurring events and save them in database, so that we can easily get the all date of event by ID 		only.
	* This is the case if user do not select any recurring option for event
	*/
	function eventer_find_non_recurring_events($ID)
	{
		$update_date = array();
		$show_event_until = eventer_get_settings( 'countdown_timer' );
		$eventer_start_dt = get_post_meta($ID, 'eventer_event_start_dt', true);
		$eventer_end_dt = get_post_meta($ID, 'eventer_event_end_dt', true);
		$eventer_start_dt_str = strtotime($eventer_start_dt);
		$eventer_end_dt_str = strtotime($eventer_end_dt);

		$eventer_dynamic_include = get_post_meta($ID, 'eventer_event_multiple_dt_inc', true);
		$eventer_dynamic_include_get = array_map('trim', explode(',', $eventer_dynamic_include));
		$eventer_dynamic_include_get = array_filter($eventer_dynamic_include_get);

		$count_date_diff = eventer_dateDiff(date('Y-m-d', $eventer_start_dt_str), date('Y-m-d', $eventer_end_dt_str));
		$eventer_multi_date = (!empty(get_option('eventer_multi_day_event')))?get_option('eventer_multi_day_event'):array();
		if($count_date_diff<=0)
		{
				$actual_date = date_i18n('Y-m-d', $eventer_start_dt_str);
				$update_date = (!empty($eventer_dynamic_include_get))?array_merge($eventer_dynamic_include_get, array($actual_date)):array($actual_date);
				if(in_array($ID, $eventer_multi_date))
				{
					$updated_multi = array_diff($eventer_multi_date,array($ID));
					update_option('eventer_multi_day_event', $updated_multi);
				}
		}
		else
		{
			$update_date[] = date_i18n('Y-m-d', $eventer_start_dt_str);
			for($i=0; $i<$count_date_diff; $i++)
			{
				$event_new_date = strtotime("+1 days", $eventer_start_dt_str);
				$event_new_date = date_i18n('Y-m-d', $event_new_date);
				$update_date[] = $event_new_date;
				$eventer_start_dt_str = strtotime($event_new_date);
			}
			if(!empty($eventer_dynamic_include_get))
			{
				$update_date = array_merge($update_date, $eventer_dynamic_include_get);
			}

			$updating_multi_ids = array_merge($eventer_multi_date, array($ID));
			$updating_multi_ids = array_unique($updating_multi_ids);
			update_option('eventer_multi_day_event', $updating_multi_ids);
		}
		return $update_date;
	}
}

if(!function_exists('eventer_find_first_recurring_events'))
{
	/*
	* eventer_find_first_recurring_events function
	* This function create array of all dates of recurring events and save them in database, so that we can easily get the all date of event by ID 		only.
	* This is the case if user select fixed date option for event frequency
	*/
	function eventer_find_first_recurring_events($ID)
	{
		$show_event_until = eventer_get_settings( 'countdown_timer' );
		$eventer_start_dt = get_post_meta($ID, 'eventer_event_start_dt', true);
		$eventer_end_dt = get_post_meta($ID, 'eventer_event_end_dt', true);
		$eventer_start_dt_str = strtotime($eventer_start_dt);
		$eventer_end_dt_str = strtotime($eventer_end_dt);
		$eventer_start_time = date('G:i', $eventer_start_dt_str);
		$eventer_end_time = date('G:i', $eventer_end_dt_str);
		$eventer_time_set = ($show_event_until==1)?$eventer_start_time:$eventer_end_time;
		$eventer_default_set = ($show_event_until==1)?$eventer_start_dt_str:$eventer_end_dt_str;

		//First Selection Fixed Date EveryDay, EveryWeek, EveryMonth
		$eventer_frequency = get_post_meta($ID, 'eventer_event_frequency', true);

		$eventer_dynamic_include = get_post_meta($ID, 'eventer_event_multiple_dt_inc', true).',';
		$eventer_dynamic_include_get = array_map('trim', explode(',', $eventer_dynamic_include));
		$eventer_dynamic_include_get = array_filter($eventer_dynamic_include_get);

		$eventer_frequency_count = get_post_meta($ID, 'eventer_event_frequency_count', true);
		$eventer_dynamic_exclude = get_post_meta($ID, 'eventer_event_multiple_dt_exc', true).',';
		$eventer_dynamic_exclude_get = array_map('trim', explode(',', $eventer_dynamic_exclude));
		$eventer_dynamic_exclude_get = array_filter($eventer_dynamic_exclude_get);

		$count_date_diff = eventer_dateDiff(date('Y-m-d', $eventer_start_dt_str), date('Y-m-d', $eventer_end_dt_str));
		$update_date = array();
		$update_date[] = date('Y-m-d', $eventer_start_dt_str);
		//if($count_date_diff<=0)
		//{
			if($eventer_frequency_count>0)
			{
				$eventer_frequency_val = ($eventer_frequency==30)?'month':'days';
				$eventer_frequency = ($eventer_frequency==30)?1:$eventer_frequency;
				for($i=0; $i<$eventer_frequency_count; $i++)
				{ 
					$event_new_date = strtotime("+".$eventer_frequency." ".$eventer_frequency_val, $eventer_start_dt_str);
					$event_new_date = date('Y-m-d', $event_new_date);
					$update_date[] = $event_new_date;
					$eventer_start_dt_str = strtotime($event_new_date);
				}
			}
		//}
		$update_date_new = array_merge($update_date, $eventer_dynamic_include_get);
		$update_date_unique = array_unique($update_date_new);
		$updated_date_get = array_diff($update_date_unique, $eventer_dynamic_exclude_get);
		usort($updated_date_get, "eventer_date_sort");
		$eventer_multi_date = (!empty(get_option('eventer_multi_day_event')))?get_option('eventer_multi_day_event'):array();
		if(in_array($ID, $eventer_multi_date))
		{
			$updated_multi = array_diff($eventer_multi_date,array($ID));
			update_option('eventer_multi_day_event', $updated_multi);
		}
		return $updated_date_get;
	}
}

if(!function_exists('eventer_find_second_recurring_events'))
{
	/*
	* eventer_find_second_recurring_events function
	* This function create array of all dates of recurring events and save them in database, so that we can easily get the all date of event by ID 		only.
	* This is the case if user select week day option for event frequency
	*/
	function eventer_find_second_recurring_events($ID)
	{
		$all_events = array();
		$show_event_until = eventer_get_settings( 'countdown_timer' );
		$eventer_start_dt = get_post_meta($ID, 'eventer_event_start_dt', true);
		$eventer_end_dt = get_post_meta($ID, 'eventer_event_end_dt', true);
		$eventer_start_dt_str = strtotime($eventer_start_dt);
		$eventer_end_dt_str = strtotime($eventer_end_dt);
		$eventer_start_time = date_i18n('G:i', $eventer_start_dt_str);
		$eventer_end_time = date_i18n('G:i', $eventer_end_dt_str);
		$eventer_time_set = ($show_event_until==1)?$eventer_start_time:$eventer_end_time;
		$eventer_default_set = ($show_event_until==1)?$eventer_start_dt_str:$eventer_end_dt_str;
		$event_weekly = get_post_meta($ID, 'eventer_event_weekly_repeat', true);

		//Second Selection Week Day First Sunday of First Week ETC
		$eventer_week_number = get_post_meta($ID, 'eventer_event_day_month', true);
		$eventer_week_day = get_post_meta($ID, 'eventer_event_week_day', true);

		$eventer_dynamic_include = get_post_meta($ID, 'eventer_event_multiple_dt_inc', true).',';
		$eventer_dynamic_include_get = array_map('trim', explode(',', $eventer_dynamic_include));
		$eventer_dynamic_include_get = array_filter($eventer_dynamic_include_get);

		$eventer_frequency_count = get_post_meta($ID, 'eventer_event_frequency_count', true);
		$eventer_dynamic_exclude = get_post_meta($ID, 'eventer_event_multiple_dt_exc', true).',';
		$eventer_dynamic_exclude_get = array_map('trim', explode(',', $eventer_dynamic_exclude));
		$eventer_dynamic_exclude_get = array_filter($eventer_dynamic_exclude_get);

		$count_date_diff = eventer_dateDiff(date('Y-m-d', $eventer_start_dt_str), date('Y-m-d', $eventer_end_dt_str));

		
		$get_updated_date = $eventer_start_dt_str;
		if($event_weekly==='on')
		{
			foreach($eventer_week_number as $week_number)
			{
				switch($week_number)
				{
					case 'first':
					$daysbyweek = 7;
					break;
					case 'second':
					$daysbyweek = 14;
					break;
					case 'third':
					$daysbyweek = 21;
					break;
					case 'fourth':
					$daysbyweek = 28;
					break;
					default:
					$daysbyweek = 35;
					break;
				}
				$eventer_frequency_val = 'days';
				$event_new_date_original = date_i18n('Y-m-d', $eventer_start_dt_str);
				for($i=1; $i<=$eventer_frequency_count; $i++)
				{
					$extent_for = $daysbyweek*$i;
					$event_new_date_get = date_i18n('Y-m-d', strtotime($event_new_date_original.' + '.$extent_for.' '.$eventer_frequency_val));
					foreach($eventer_week_day as $week_day)
					{
						$day_num = date('N', strtotime($week_day));
						$dayofweek = date('w', strtotime($event_new_date_get));
						$event_new_date    = date('Y-m-d', strtotime(($day_num - $dayofweek).' day', strtotime($event_new_date_get)));
						$all_events[] = $event_new_date;
					}
				}
			}
		}
		else
		{
			$all_events[] = date_i18n('Y-m-d', $eventer_start_dt_str);
			for($i=1; $i<=$eventer_frequency_count; $i++)
			{
				$eventDate = strtotime( date_i18n('Y-m-01', $get_updated_date) );
				$event_start_date_next = strtotime("+".$i." month", $eventDate);
				$next_month = date_i18n('F',$event_start_date_next);
				$next_event_year = date_i18n('Y',$event_start_date_next);
				$start_date_time = date_i18n('G:i', $get_updated_date);
				foreach($eventer_week_number as $week_number)
				{
					foreach($eventer_week_day as $week_day)
					{
						$all_events_add = date('Y-m-d', strtotime($week_number.' '.$week_day.' of '.$next_month.' '.$next_event_year));
						$all_events[] = $all_events_add;
					}
				}
			}
		}
		
		$update_date_new = array_merge($all_events, $eventer_dynamic_include_get);
		$update_date_unique = array_unique($update_date_new);
		$updated_date_get = array_diff($update_date_unique, $eventer_dynamic_exclude_get);
		usort($updated_date_get, "eventer_date_sort");
		$eventer_multi_date = (!empty(get_option('eventer_multi_day_event')))?get_option('eventer_multi_day_event'):array();
		if(in_array($ID, $eventer_multi_date))
		{
			$updated_multi = array_diff($eventer_multi_date,array($ID));
			update_option('eventer_multi_day_event', $updated_multi);
		}
		return $updated_date_get;
	}
}

if(!function_exists('eventer_date_updated'))
{
	/*
	* eventer_find_second_recurring_events function
	* This function create array of all dates of recurring events and save them in database, so that we can easily get the all date of event by ID 		only.
	* This is the case if user select week day option for event frequency
	*/
	function eventer_date_updated( $post_id ) 
	{
		if(get_post_type($post_id)!='eventer') return;
		$eventer_frequency_type = get_post_meta($post_id, 'eventer_event_frequency_type', true);
		update_option('eventer_saved_show_until', '');
		$update_all_date = '';
		$site_lang = EVENTER__LANGUAGE_CODE;
		update_option($site_lang.'_eventer_future_data_wp', array());
		$eventer_stored = get_option($site_lang.'_eventer_stored');
		$new_eventer_save[$post_id] = get_the_title($post_id);
		$merge_eventer_stored = array_merge($eventer_stored, $new_eventer_save);
		update_option($site_lang.'_eventer_stored', $merge_eventer_stored);
		switch($eventer_frequency_type)
		{
			case 'no':
			$update_all_date = eventer_find_non_recurring_events($post_id);
			update_post_meta($post_id, 'eventer_all_dates', $update_all_date);
			break;
			case '1':
			$update_all_date = eventer_find_first_recurring_events($post_id);
			update_post_meta($post_id, 'eventer_all_dates', $update_all_date);
			break;
			case '2':
			$update_all_date = eventer_find_second_recurring_events($post_id);
			update_post_meta($post_id, 'eventer_all_dates', $update_all_date);
			break;
			default:
			$update_all_date = eventer_find_non_recurring_events($post_id);
			update_post_meta($post_id, 'eventer_all_dates', $update_all_date);
		}
	}
}

if(!function_exists('eventer_actioned_post'))
{
	/*
	* eventer_actioned_post function
	* This function remove all recurring date from database if trash action trigerred
	*/
	function eventer_actioned_post($post_id)
	{
		if(get_post_type($post_id)!='eventer') return;
		update_post_meta($post_id, 'eventer_all_dates', '');
		$eventer_multi_date = (!empty(get_option('eventer_multi_day_event')))?get_option('eventer_multi_day_event'):array();
		if(in_array($post_id, $eventer_multi_date))
		{
			$eventer_multi_date = array_diff($eventer_multi_date, array($post_id));
			$updating_multi_ids = array_unique($eventer_multi_date);
			update_option('eventer_multi_day_event', $updating_multi_ids);
		}
	}
	add_action( 'save_post', 'eventer_date_updated', 99, 2 );
	add_action( 'edit_post', 'eventer_date_updated', 99, 2 );
	add_action( 'publish_eventer', 'eventer_date_updated', 999, 2 );
	add_action( 'trashed_post', 'eventer_actioned_post', 10, 2 );
	add_action('untrash_post', 'eventer_date_updated', 10, 2);
}

function eventer_get_eventer_list()
{
	$event_list = array(''=>esc_html__('Next Future Event', 'eventer'));
	$args = array('post_type'=>'eventer', 'posts_per_page'=>-1);
	$eventer_list = new WP_Query($args);
	if($eventer_list->have_posts()):while($eventer_list->have_posts()):$eventer_list->the_post();
		$event_list[get_the_ID()] = get_the_title();
	endwhile; endif; wp_reset_postdata();
	return $event_list;
}

if(!function_exists('eventer_get_terms'))
{
	/*
	* eventer_get_terms function
	* This function returns all terms of given taxonomy
	*/
	function eventer_get_terms($taxonomy = '')
	{
		if($taxonomy=='') return;
		$event_terms = array(''=>esc_html__('All', 'eventer'));
		$term_args = get_terms($taxonomy);
		if(!is_wp_error($term_args)&&!empty($term_args))
		{
			foreach($term_args as $term)
			{
				$event_terms[$term->term_id] = $term->name;
			}
		}
		return $event_terms;
	}
}

if(!function_exists('eventer_make_event_primary_venue'))
{
	/*
	* eventer_make_event_primary_venue function
	* This function make venue primary if selected multiple for event
	*/
	function eventer_make_event_primary_venue()
	{
		$status = '';
		if ( !wp_verify_nonce( $_REQUEST['nonce'], "eventer_make_event_primary_venue_nonce")) 
		{
				exit();
		} 
		$eventer_id = $_REQUEST['post_id'];
		$term_id = $_REQUEST['term'];
		$uncheck = $_REQUEST['uncheck'];
		$terms = explode("-", $term_id);

		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) 
		{ 
			$old_status = get_post_meta($eventer_id, 'eventer_primary_term', true);
			if($old_status==$terms[2]&&$uncheck=='1')
			{
				$status = update_post_meta($eventer_id, 'eventer_primary_term', '');
				echo 0;
			}
			elseif($uncheck!='1')
			{
				$status = update_post_meta($eventer_id, 'eventer_primary_term', $terms[2]);
				echo 1;
			}
			echo 'eventer-venue-'.get_post_meta($eventer_id, 'eventer_primary_term', true);

			die();
		}
		else 
		{
			exit();
		}
	}
	add_action( 'wp_ajax_eventer_make_event_primary_venue', 'eventer_make_event_primary_venue' );
}

if(!function_exists('eventer_update_registrant_status'))
{
	/*
	* eventer_update_registrant_status function
	* This function update the status of registrant payment
	*/
	function eventer_update_registrant_status()
	{
		$nonce = (isset($_REQUEST['nonce']))?$_REQUEST['nonce']:'';
		if ( ! wp_verify_nonce( $nonce, 'eventer_update_registrant_status' ) ) 
		{
			wp_die();
		}
		$registrant_id = (isset($_REQUEST['id']))?$_REQUEST['id']:'';
		$status = (isset($_REQUEST['status']))?$_REQUEST['status']:'woo';
		if($status=="woo")
		{
			$registrants = eventer_get_registrant_details('id', $registrant_id);
			echo apply_filters('eventer_status_changed_completed', $registrants);
			wp_die();
		}
		$registrants = eventer_get_registrant_details('id', $registrant_id);
		$user_system = unserialize($registrants->user_system);
		$user_system['email_post'] = "1";
		$new_user_system = serialize($user_system);
		eventer_update_registrant_details(array('status' => $status), $registrant_id, array("%s", "%s"));
		if($status=="Completed")
		{
			eventer_pass_email_registration($registrant_id, 4);
			eventer_update_registrant_details(array('user_system' => $new_user_system), $registrant_id, array("%s", "%s"));
			echo apply_filters('eventer_status_changed_completed', $registrants);
		}
		
		wp_die();
	}
	add_action( 'wp_ajax_eventer_update_registrant_status', 'eventer_update_registrant_status' );
}

if(!function_exists('eventer_send_tickets_again'))
{
	/*
	* eventer_update_registrant_status function
	* This function update the status of registrant payment
	*/
	function eventer_send_tickets_again()
	{
		$nonce = (isset($_REQUEST['nonce']))?$_REQUEST['nonce']:'';
		if ( ! wp_verify_nonce( $nonce, 'eventer_send_tickets_again' ) ) 
		{
			wp_die();
		}
		$registrant_id = (isset($_REQUEST['id']))?$_REQUEST['id']:'';
		$registrants = eventer_get_registrant_details('id', $registrant_id);
		echo apply_filters('eventer_status_changed_completed', $registrants);
		wp_die();
	}
	add_action( 'wp_ajax_eventer_send_tickets_again', 'eventer_send_tickets_again' );
}



if(!function_exists('eventer_remove_registrant'))
{
	/*
	* eventer_remove_registrant function
	* This function removes entry of registrant from database, whenever user click remove button from dashboard bookings section
	*/
	function eventer_remove_registrant()
	{
		if ( !wp_verify_nonce( $_REQUEST['nonce'], "eventer_remove_registrant_nonce")) 
		{
			exit();
		} 
		$reg_id = $_REQUEST['reg_id'];
		$reg_email = $_REQUEST['reg_email'];
		$new_already_booked = array();
		if($reg_id!=''&&$reg_email!='')
		{
			global $wpdb;
			$table_name = $wpdb->prefix."eventer_registrant";
			$reg_details = $wpdb->get_row( "SELECT * FROM $table_name WHERE id = $reg_id" );
			if($reg_details)
			{
				$reg_tickets = $reg_details->tickets;
				$reg_tickets = unserialize($reg_tickets);
				$eventer_id = $reg_details->eventer;
				$eventer_date = $reg_details->eventer_date;
				$original_event = eventer_wpml_original_post_id($eventer_id);
				$booked_eventer_tickets = (!empty(get_post_meta($original_event, 'specific_eventer_tickets', true)))?get_post_meta($original_event, 'specific_eventer_tickets', true):array();
				if(!empty($reg_tickets)&&array_key_exists($eventer_date, $booked_eventer_tickets))
				{
					$current_date_booked = $booked_eventer_tickets[$eventer_date];
					$find_matched_details = array_column($current_date_booked, 'number', 'name');
					$find_matched_details_more = array_column($current_date_booked, 'price', 'name');
					$update_new_val = array();
					foreach($reg_tickets as $ticket)
					{
						$ticket_name = (isset($ticket['name']))?$ticket['name']:'';
						$ticket_count = (isset($ticket['number']))?$ticket['number']:'';
						if($ticket_name!='')
						{
							$remaining = (isset($find_matched_details[$ticket_name]))?$find_matched_details[$ticket_name]:'';
							if($remaining=='') break;
							$remain_updated = $remaining+$ticket_count;
							$update_new_val[] = array('name'=>$ticket_name, 'number'=>$remain_updated, 'price'=>$find_matched_details_more[$ticket_name]);
						}
					}
					$new_remaining_tickets = $update_new_val;
					$new_already_booked[$eventer_date] = $new_remaining_tickets;
					unset($booked_eventer_tickets[$eventer_date]);
					$update_new_tickets = array_merge($new_already_booked, $booked_eventer_tickets);
					update_post_meta($original_event, 'specific_eventer_tickets', $update_new_tickets);
				}
			}
			$wpdb->delete( $table_name, array( 'id' => $reg_id, 'email' => $reg_email ), array( '%d', '%s' ) );
			echo "deleted";
		}
		die();
	}
	add_action( 'wp_ajax_eventer_remove_registrant', 'eventer_remove_registrant' );
}

if(!function_exists('eventer_export_bookings_csv'))
{
	/*
	* eventer_export_bookings_csv function
	* This function export registrant details to csv file
	*/
	add_action('wp_ajax_eventer_export_bookings_csv', 'eventer_export_bookings_csv');
	function eventer_export_bookings_csv() 
	{
		global $wpdb;
		$booking_status = (isset($_REQUEST['status']))?$_REQUEST['status']:'';
		$specific_event = (isset($_REQUEST['eventer']))?$_REQUEST['eventer']:'';
		$where = "";
		if($booking_status!=''&&$specific_event!='')
		{
			$where = "WHERE status = '$booking_status' AND eventer = $specific_event";
		}
		elseif($booking_status!=''&&$specific_event=='')
		{
			$where = "WHERE status = '$booking_status'";
		}
		elseif($booking_status==''&&$specific_event!='')
		{
			$where = "WHERE eventer = '$specific_event'";
		}
		$wpdb->show_errors(); 					
		$table_name = $wpdb->prefix."eventer_registrant";
		$file = 'eventer_booking_csv';
		$export_query = $wpdb->get_results( "SELECT * FROM $table_name $where", ARRAY_A );
		if (! $export_query) 
		{
			$Error = $wpdb->print_error();
			die("The following error was found: $Error");
		} 
		else 
		{
			$csv_fields=array();
			$csv_fields[] = 'Registrant ID';
			$csv_fields[] = 'Eventer ID';
			$csv_fields[] = 'Registration Time';
			$csv_fields[] = 'Eventer Date';
			$csv_fields[] = 'Transaction ID';
			$csv_fields[] = 'Registrant User Name';
			$csv_fields[] = 'Registrant Email';
			$csv_fields[] = 'Payment Mode';
			$csv_fields[] = 'Payment Status';
			$csv_fields[] = 'Amount';
			$csv_fields[] = 'User Details';
			$csv_fields[] = 'Tickets';
			$csv_fields[] = 'User ID';
			$csv_fields[] = 'Payment Details';
			$output_filename = $file."_".date_i18n("Y-m-d_H-i-s").".csv";
			$output_handle = @fopen( 'php://output', 'w' );

			header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
			header( 'Content-Description: File Transfer' );
			header( 'Content-type: text/csv' );
			header( 'Content-Disposition: attachment; filename=' . $output_filename );
			header( 'Expires: 0' );
			header( 'Pragma: public' );	

			fputcsv( $output_handle, $csv_fields );
			foreach ($export_query as $Result) 
			{
				$sb = array();
				foreach($Result as $key=>$value)
				{
					$new_data = @unserialize($value);
					$show_data = ($new_data!==false)?unserialize($value):$value;
					if(is_array($show_data) && $key=='user_details')
					{
						$user_details = '';
						foreach($show_data as $data)
						{
							$field_val = (isset($data['value']))?$data['value']:'';
							$field_name = (isset($data['name']))?$data['name']:'';
							$user_details .= ($field_val!='')?'{'.$field_name.': '.$field_val.'}':'';
						}
						$show_data = $user_details;
					}
					elseif(is_array($show_data) && $key=='tickets')
					{
						$user_tickets = '';
						foreach($show_data as $data)
						{
							$tickets_count = (isset($data['number']) && $data['number']!='')?$data['number']:0;
							$tickets_name = (isset($data['name']) && $data['name']!='')?$data['name']:0;
							$user_tickets .= ($tickets_count!=0)?'{'.$tickets_name.': '.$tickets_count.'}':'';
						}
						$show_data = $user_tickets;
					}
					elseif(is_array($show_data) && $key=='paypal_details')
					{
						$payment_details = '';
						foreach($show_data as $key=>$value)
						{
							$payment_details .= '{'.$key.': '.$value.'}';
						}
						$show_data = $payment_details;
					}
					$sb[$key] = $show_data;
				}
				$leadArray = $sb;
				fputcsv( $output_handle, $leadArray );
			}
			fclose( $output_handle ); 
		}
		die();
	}
}

if(!function_exists('manage_eventer_posts_columns'))
{
	/*
	* manage_eventer_posts_columns function
	* Create column in evener post type for event start and end date
	*/
	add_filter( 'manage_eventer_posts_columns', 'eventer_set_eventer_column_label' );
	function eventer_set_eventer_column_label($columns) {
			$columns['edate'] = __( 'EDate', 'eventer' );
			return $columns;
	}
}

if(!function_exists('eventer_show_eventer_column_data'))
{
	/*
	* eventer_show_eventer_column_data function
	* Update values in event date admin column
	*/
	// Add the data to the custom columns for the eventer post type:
	add_action( 'manage_eventer_posts_custom_column' , 'eventer_show_eventer_column_data', 10, 2 );
	function eventer_show_eventer_column_data( $column, $post_id ) {
			switch ( $column ) 
			{
				case 'edate' :
				$event_start_date 		= get_post_meta($post_id, 'eventer_event_start_dt', true);
				$event_end_date 			= get_post_meta($post_id, 'eventer_event_end_dt', true);
				$event_end_date 			= ($event_end_date!='')?$event_end_date:$event_start_date;
				$event_start_dt_str 	= strtotime($event_start_date);
				$event_end_dt_str 		= strtotime($event_end_date);
				echo date_i18n('Y-m-d H:i', $event_start_dt_str).'<br><abbr title="">'.date_i18n('Y-m-d H:i', $event_end_dt_str).'</abbr>';
				break;
			}
	}
}

if(!function_exists('eventer_get_booked_tickets'))
{
	/*
	* eventer_get_booked_tickets function
	* Show status of event tickets booked status
	*/
	function eventer_get_booked_tickets()
	{
		$eventer_id = ($_REQUEST['eventer_id'])?$_REQUEST['eventer_id']:'';
		$booked_date = ($_REQUEST['booked_date'])?$_REQUEST['booked_date']:'';
		$original_event = eventer_wpml_original_post_id($eventer_id);
		$tickets = get_post_meta($original_event, 'eventer_tickets', true);
		$booked_eventer_tickets = get_post_meta($original_event, 'specific_eventer_tickets', true);
		//This code has been added when date wise ticket feature is added for Woocommerce
		//Because remaining tickets were saving in wrong format, so we need to rectify them to work properly in future
		/*if(!empty($booked_eventer_tickets) && count($booked_eventer_tickets[$booked_date])>3)
		{
			if(!empty($tickets))
			{
				$actual_tickets = array();
				foreach($tickets as $new_ticket)
				{
					$actual_tickets[$new_ticket['name']] = $new_ticket['price'];
				}
			}
			$new_updated_bookings = array();
			foreach($actual_tickets as $name=>$price)
			{
				$new_booked_tickets_key = eventer_search_ticket($name, $booked_eventer_tickets[$booked_date], 0);
				$exact_ticket_find = (isset($booked_eventer_tickets[$booked_date][$new_booked_tickets_key]))?$booked_eventer_tickets[$booked_date][$new_booked_tickets_key]:array();
				if(!empty($exact_ticket_find))
				{
					$ticket_name = $name;
					$remaining_booked = esc_attr($exact_ticket_find['number']);
					$raw_price = $price;
					$new_updated_bookings[] = array('name'=>$ticket_name, 'number'=>$remaining_booked, 'price'=>$raw_price);
					
				}
			}
			$booked_tickets_find = get_post_meta($original_event, 'specific_eventer_tickets', true);
			unset($booked_tickets_find[$booked_date]);
			$booked_tickets_find[$booked_date] = $new_updated_bookings;
			update_post_meta($original_event, 'specific_eventer_tickets', $booked_tickets_find);
			$booked_eventer_tickets = get_post_meta($original_event, 'specific_eventer_tickets', true);
		}*/
		//End of custom code of Woo
		if(is_array($booked_eventer_tickets) && array_key_exists($booked_date, $booked_eventer_tickets))
		{
			echo json_encode($booked_eventer_tickets[$booked_date]);
		}
		else
		{
			echo json_encode($tickets);
		}
		die();
	}
	add_action( 'wp_ajax_eventer_get_booked_tickets', 'eventer_get_booked_tickets' );
}

if(!function_exists('eventer_update_booked_tickets'))
{
	/*
	* eventer_update_booked_tickets function
	* Show booked ticket information in event post type section while editing any event
	*/
	function eventer_update_booked_tickets()
	{
		$eventer_id = (isset($_REQUEST['eventer_id']))?$_REQUEST['eventer_id']:'';
		$booked_date = (isset($_REQUEST['booked_date']))?$_REQUEST['booked_date']:'';
		$tickets_new = (isset($_REQUEST['updated_detail']))?$_REQUEST['updated_detail']:'';
		$position = (isset($_REQUEST['position']))?$_REQUEST['position']:'';
		$original_event = eventer_wpml_original_post_id($eventer_id);
		$tickets = get_post_meta($original_event, 'eventer_tickets', true);
		$tickets_validate = serialize($tickets);
		$tickets_new_validate = serialize($tickets_new);
		if($position=="save")
		{
			$booked_eventer_tickets = (!empty(get_post_meta($original_event, 'specific_eventer_tickets', true)))?get_post_meta($original_event, 'specific_eventer_tickets', true):array();
			$new_updated_val = array();
			if(array_key_exists($booked_date, $booked_eventer_tickets))
			{
				$new_updated_val[$booked_date] = $tickets_new;
				unset($booked_eventer_tickets[$booked_date]);
				$update_this_val = array_merge($new_updated_val, $booked_eventer_tickets);
			}
			else
			{
				$new_updated_val[$booked_date] = $tickets_new;
				$update_this_val = array_merge($new_updated_val, $booked_eventer_tickets);
			}
			$updation_switch = strcmp($tickets_new_validate, $tickets_validate);
			if(!empty($updation_switch))
			{
				update_post_meta($original_event, 'specific_eventer_tickets', $update_this_val);
			}
		}
		else
		{
			update_post_meta($original_event, 'specific_eventer_tickets', '');
		}
		die();
	}
	add_action( 'wp_ajax_eventer_update_booked_tickets', 'eventer_update_booked_tickets' );
}

function eventer_get_term_details()
{
	$term_id = (isset($_REQUEST['term_id']))?$_REQUEST['term_id']:'';
	$taxonomy = (isset($_REQUEST['taxonomy']))?$_REQUEST['taxonomy']:'';
	if($taxonomy=='list:eventer-venue')
	{
		$location = get_term_meta($term_id, 'venue_address', true);
		echo '<div id="misc-publishing-actions" class="eventer-admin-term-metas-show"><div class="">'.esc_html__('Location', 'eventer').': <span id="post-status-display">'.esc_attr($location).'</span></div>';
	}
	else
	{
		$organizer_email = get_term_meta($term_id, 'organizer_email', true);
		$organizer_phone = get_term_meta($term_id, 'organizer_phone', true);
		$organizer_website = get_term_meta($term_id, 'organizer_website', true);
		echo '<div id="misc-publishing-actions" class="eventer-admin-term-metas-show"><div class="">'.esc_html__('Email', 'eventer').': <span id="post-status-display">'.esc_attr($organizer_email).'</span></div><div class="">'.esc_html__('Phone', 'eventer').': <span id="post-status-display">'.esc_attr($organizer_phone).'</span></div><div class="">'.esc_html__('Website', 'eventer').': <span id="post-status-display">'.esc_url($organizer_website).'</span></div></div>';
	}
	wp_die();
}
add_action('wp_ajax_eventer_get_term_details', 'eventer_get_term_details');

function eventer_woo_get_return_url($order = null)
{
    if ($order) {
        $return_url = $order->get_checkout_order_received_url();
    } else {
        $return_url = wc_get_endpoint_url('order-received', '', wc_get_page_permalink('checkout'));
    }
    if (is_ssl() || get_option('woocommerce_force_ssl_checkout') == 'yes') {
        $return_url = str_replace('http:', 'https:', $return_url);
    }
    return apply_filters('woocommerce_get_return_url', $return_url);
}
