<?php
$usersystem = unserialize($usersystem);
$user_registrants_list = (!empty($usersystem) && isset($usersystem['registrants']))?$usersystem['registrants']:array();
$tickets_generated =  (!empty($usersystem) && isset($usersystem['tickets_generated']))?$usersystem['tickets_generated']:'';
$nonce_qrcode = wp_create_nonce( 'eventer-qrcode-nonce' );
$registered_ticket = $elocation = $organizer_email = '';
$eventer_organizer = get_the_terms(get_the_ID(), 'eventer-organizer');
$eventer_venue = get_the_terms($event_id, 'eventer-venue');
if(!is_wp_error($eventer_venue)&&!empty($eventer_venue))
{
	foreach($eventer_venue as $venue)
	{
		$location_address = get_term_meta($venue->term_id, 'venue_address', true);
		$elocation = ($location_address!='')?$location_address:$venue->name;
	}
}
if(!is_wp_error($eventer_organizer)&&!empty($eventer_organizer))
{
	foreach($eventer_organizer as $organizer)
	{
		$organizer_email = get_term_meta($organizer->term_id, 'organizer_email', true);
	}
}
if(!empty($user_registrants_list) && $woocommerce_ticketing != 'on')
{
    $all_registrants_list_create = $all_registrants_list = '';
    echo '<div class="eventer eventer-all-registrants" style="display:none;" data-regpos="'.esc_attr($reg_position).'" data-mainreg="'.$registrant_email.'" data-registrant="'.esc_attr($registrant).'" data-eid="'.esc_attr(get_the_ID()).'" data-organizer="'.$organizer_email.'" data-nonce="'.$nonce_qrcode.'">';
    $ticket_num_st = 1;
    $all_registrants_list .= '<div class="eventer-ticket-printable-top">
										<div class="eventer-on-ticket-qr" data-qr-content="'.esc_attr($registrant).'"></div>
										<label class="eventer-ticket-reg-code">'.$registrant.'</label>
									</div>
									<div class="eventer-ticket-printable-bottom">
										<label>'.esc_html__('Attendees', 'eventer').'</label>';
    $all_registrants_list .= '<div class="eventer-row">';
    foreach($user_registrants_list as $ticket_list=>$registrant_list)
    {
        //if($ticket_list=="main" || $single_registrant['name']=='') continue;
        foreach($registrant_list as $single_registrant)
        {
            if($ticket_list=="main" || $single_registrant['name']=='') continue;
            $all_registrants_list_create .= '<div class="eventer-col5">';
            $all_registrants_list_create .= $single_registrant['name'];
            $all_registrants_list_create .= '</div>';
            $all_registrants_list_create .= '<div class="eventer-col5">';
            $all_registrants_list_create .= esc_attr($ticket_list);
            $all_registrants_list_create .= '</div>';
            echo '<span class="eventer-registrant-show" data-ticket="'.esc_attr($ticket_list).'" data-qrcode="'.esc_attr($registrant).'-'.$ticket_num_st.'" data-img="" data-email="'.$single_registrant['email'].'" data-name="'.$single_registrant['name'].'"></span>';
            $ticket_num_st++;
         }
    }
    $all_registrants_list .= $all_registrants_list_create;
    $all_registrants_list .= '</div>';
    $all_registrants_list .= '</div>';
    echo '</div>';
      
    if(!empty($booked_registrant_tickets))
	{ 
		foreach($booked_registrant_tickets as $reg_ticket)
		{
         if($reg_ticket['name']=='' || $reg_ticket['number']<=0) continue;
			$registered_ticket .= '<p class="eventer-tickets-booked-info">'.esc_attr($reg_ticket['name']).' x <strong>'.esc_attr($reg_ticket['number']).'</strong></p>';
		}
	}
    $order_num = sprintf('%06d', $registrant);
    echo '<div class="clearfix"></div>
	<div style="opacity:0;" class="eventer eventer-temporary-tickets">
   <div style="width:300px;" id="eventer-ticket-printable" class="eventer-ticket-final-tickets" data-nonce="'.$nonce_qrcode.'" data-uname="'.esc_attr($username).'" data-uemail="'.$registrant_email.'" data-eid="'.esc_attr(get_the_ID()).'" data-regpos="'.esc_attr($reg_position).'" data-registrant="'.esc_attr($registrant).'">
								<div class="eventer-ticket-printable">
									<div class="eventer-ticket-printable-top">
										<div class="eventer-qrcode eventer-on-ticket-qr" data-qr-content="'.esc_attr($ticket_id).'"></div>
										<label class="eventer-ticket-reg-code">'.esc_attr($ticket_id).'</label>
									</div>
									<div class="eventer-ticket-printable-bottom">
										<label>'.esc_html__('Attendee', 'eventer').'</label>
										<h3>'.esc_attr($username).'</h3>
										<label>'.esc_html__('Event', 'eventer').'</label>
										<p>'.get_the_title().'</p>
										<div class="eventer-spacer-10"></div>
										<label>'.esc_html__('Ticket', 'eventer').'</label>
										<div class="registrant-ticket">'.$registered_ticket.'</div>
										<div class="eventer-spacer-10"></div>
										<div class="eventer-row">
											<div class="eventer-col5">
												<label>'.esc_html__('Venue Location', 'eventer').'</label>
												<p>'.esc_attr($elocation).'</p>
											</div>
											<div class="eventer-col5">
												<label>'.esc_html__('Date &amp; Time', 'eventer').'</label>
												<p>'.esc_attr($event_time_show).'<br>'.esc_attr(date_i18n(get_option('date_format'), $event_cdate)).'</p>
											</div>
										</div>
										<div class="eventer-spacer-10"></div>
									</div>
								</div>
							</div>';
    if($ticket_num_st>=2)
    {
        echo '<div id="eventer-ticket-reverse-printable" class="eventer-ticket-final-tickets eventer-back-print">
								<div class="eventer-ticket-printable">
                        '.$all_registrants_list.'
							</div></div>';
    }
    echo '</div>';
}