<div class="eventer eventer-event-single eventer-single-event-details">
	<div class="eventer-cat-header">
		<?php $eventer_cats = get_the_terms($event_id, 'eventer-category');
			if(!is_wp_error($eventer_cats)&&!empty($eventer_cats))
			{
				foreach($eventer_cats as $cat)
				{
					$color = get_term_meta( $cat->term_id, 'category_color', true);
					echo '<a href="'.get_term_link($cat->term_id).'" class="pull-right" style="background-color: '.$color.'">'.$cat->name.'</a>';
				}
			}
		?>

		<h3><?php esc_html_e('Event details', 'eventer'); ?></h3>
	</div>
	<ul class="eventer-single-event-info">
		<?php $eventer_venue = get_the_terms($event_id, 'eventer-venue');
			$elocation = '';
			if(!is_wp_error($eventer_venue)&&!empty($eventer_venue))
			{
				foreach($eventer_venue as $venue)
				{
					$location_address = get_term_meta($venue->term_id, 'venue_address', true);
					$location_coordinates = get_term_meta($venue->term_id, 'venue_coordinates', true);
					$venue_name = $venue->name;
					if($location_coordinates!='')
					{
						$elocation = $location_coordinates;
					}
					elseif($location_address!='')
					{
						$elocation = $location_address;
					}
					else
					{
						$elocation = $venue->name;
					}
					echo '<li><span class="eventer-event-venue"><i class="eventer-icon-location-pin"></i> '.$venue_name.'</span></li>';
				}
			}
		?>
		<li><span class="eventer-event-date"><i class="eventer-icon-calendar"></i> <?php echo esc_attr(date_I18n(get_option('date_format'), $event_cdate)); ?></span></li>

		<?php
			echo '<li><span class="eventer-event-time"><i class="eventer-icon-clock"></i> '.$event_time_show.'</span></li>';
			$event_organizer = get_the_terms($event_id, 'eventer-organizer');
			if(!is_wp_error($event_organizer)&&!empty($event_organizer))
			{
				$organizer_phone = get_term_meta($event_organizer[0]->term_id, 'organizer_phone', true);
				$organizer_website = get_term_meta($event_organizer[0]->term_id, 'organizer_website', true);
				if($organizer_phone)
				{
					echo '<li><span class="eventer-event-time"><i class="eventer-icon-phone"></i> '.$organizer_phone.'</span></li>';
				}
				if($organizer_website)
				{
					echo '<li><div class="eventer-event-time"><i class="eventer-icon-globe"></i> <a href="'.esc_url($organizer_website).'">'.$organizer_website.'</a></div></li>';
				}
			}
		?>

	</ul>
	<ul class="eventer-actions">
		<li><a href="javascript:" onclick="window.print();" title="Print"><?php esc_html_e('Print', 'eventer'); ?></a></li>
		<li><a href="javascript:void(0)" title="Contact" class="eventer-modal-trigger" data-eventer-modal="#eventer-contact-form"><?php esc_html_e('Contact', 'eventer'); ?></a></li>
			<?php if($elocation)
				{
					echo '<li><a href="'.esc_url("https://www.google.co.in/maps/dir//".$elocation).'" title="Directions" target="_blank">'.esc_html__('Get Directions', 'eventer').'</a></li>';
				}
			echo '<li><a href="'.esc_url(add_query_arg('eid', $event_id, get_post_type_archive_link('eventer'))).'" title="Future events">'.esc_html__('Future Events', 'eventer').'</a></li>';
			?>
	</ul>
</div>