<?php
$registration_switch = get_post_meta($event_id, 'eventer_event_registration_swtich', true);
if($registration_switch!="1") return;
$original_event = eventer_wpml_original_post_id($event_id);
$tickets = get_post_meta($original_event, 'wceventer_tickets', true);
$eventer_formatted_date = date_i18n('Y-m-d', $event_cdate);
$eventer_start_time = get_post_meta($event_id, 'eventer_event_start_dt', true);
$event_start_time_str = strtotime($eventer_start_time);
$eventer_st_time = date_i18n("H:i", $event_start_time_str);
$booking_url = (function_exists('wc_get_cart_url'))?wc_get_cart_url():'';
$booking_url_target = get_post_meta($event_id, 'eventer_event_registration_target', true);
$registration_url = get_post_meta($event_id, 'eventer_event_custom_registration_url', true);
if (filter_var($registration_url, FILTER_VALIDATE_URL))
{ 
	$booking_url = $registration_url;
}
$new_updated_bookings = $all_tickets_name = array();
?>
<div class="eventer eventer-event-single" >
<div class="eventer-ticket-details-wrap">
			<?php
						$ticket_remaining_modal = $remaining_for_reg = $check_duplicate = '';
						$show_tickets_info = $tickets;
						if(!empty($show_tickets_info))
						{
							echo '<div class="eventer-ticket-details">
										<h3>'.esc_html__('Tickets details', 'eventer').'</h3>
										<ul class="eventer-tickets-info">';
							foreach($show_tickets_info as $ticket)
							{ 
								$remaining_for_reg = $remaining_booked = '';
								$wceventer_ticket_id = (isset($ticket['wceventer_ticket_id']))?$ticket['wceventer_ticket_id']:'';
								if(get_post_type($wceventer_ticket_id)!='product' || get_post_status($wceventer_ticket_id)!='publish') continue;
								$ticket_name = get_the_title($wceventer_ticket_id);
								$product = wc_get_product( $wceventer_ticket_id );
								$woocommerce_currency = get_woocommerce_currency_symbol();
								$raw_price = $product->get_price();
								$ticket_regular_price = $product->get_regular_price();
								$show_old_price = ($currency_position!='postfix')?$woocommerce_currency.$ticket_regular_price:$ticket_regular_price.$woocommerce_currency;
								$old_price = ($raw_price!=$ticket_regular_price)?'<del class="eventer-price-currency">'.$show_old_price.'</del> ':'';
								$new_booked_tickets_key = eventer_search_ticket($ticket_name, $booked_tickets, 0);
								$exact_ticket_find = (isset($booked_tickets[$new_booked_tickets_key]))?$booked_tickets[$new_booked_tickets_key]:array();
								if(!empty($exact_ticket_find))
								{
									$pid = (isset($exact_ticket_find['pid']))?$exact_ticket_find['pid']:'';
									if($pid==$wceventer_ticket_id || $exact_ticket_find['name'] == $ticket_name)
									{
										$ticket_name = esc_attr($exact_ticket_find['name']);
										$remaining_booked = esc_attr($exact_ticket_find['number']);
										$raw_price = ($exact_ticket_find['price']!='')?esc_attr($exact_ticket_find['price']):$raw_price;
									}
								}
								if(in_array($ticket_name, $all_tickets_name))
								{
									$check_duplicate = "1";
									continue;
								}
								$all_tickets_name[] = $ticket_name;
								$ticket_number = (isset($ticket['wceventer_ticket_number']) && $remaining_booked=='')?$ticket['wceventer_ticket_number']:$remaining_booked;
								
								$ticket_price = ($currency_position!='postfix')?$old_price.$woocommerce_currency.$raw_price:$old_price.$raw_price.$woocommerce_currency;
								$remaining_tickets = ($ticket_number<=0)?'<i class="eventer-ticket-remaining eventer-ticket-full">'.esc_html__('All Booked', 'eventer').'</i>':'<i class="eventer-ticket-remaining">'.$ticket_number.' '.esc_html__('remaining', 'eventer').'</i>';
								if($ticket_number>0)
								{ 
									$remaining_for_reg = 1;
								}
								$remain_for_booking = ($ticket_number>10)?10:$ticket_number;
								$btn_txt = esc_html__('Add to cart', 'eventer');
								$added_cart = esc_html__('Added to cart', 'eventer');
								echo '<li data-btntxt="'.esc_attr($btn_txt).'" data-addedcart="'.esc_attr($added_cart).'" data-currency="'.$woocommerce_currency.'" data-price="'.esc_attr($raw_price).'" data-product="'.esc_attr($wceventer_ticket_id).'" data-eventer="'.$event_id.'" data-edate="'.$event_cdate.'" data-eventerurl="'.esc_url(eventer_generate_endpoint_url('edate', $eventer_formatted_date, get_permalink($event_id))).'" data-etime="'.date_i18n(get_option('time_format'), $event_start_time_str).'">';
								if($remaining_for_reg==1 && date_i18n('Y-m-d')<=$eventer_formatted_date) {
								echo '<table class="eventer-wc-ticket-table"><tr>
								<td width="35%" valign="center"><span class="eventer-ticket-type-name">'.$ticket_name.' '.$remaining_tickets.'</span></td>
								<td width="20%"><span class="eventer-wc-ticket-price eventer-ticket-type-price">'.$ticket_price.'</span></td>
								<td width="20%"><span class="eventer-wc-ticket-quantity-wrap"><select class="eventer-wc-ticket-quantity">';
											for($start=1; $start<=$remain_for_booking; $start++)
											{
												echo '<option value="'.$start.'">'.$start.'</option>';
											}
								echo '</select></span></td>
								<td width="25%" align="right">
								<div class="eventer-wc-addtocart"><input type="button" class="eventer-btn add-ticket-wc" value="'.esc_attr($btn_txt).'">
											<!-- <span class="eventer-wc-ticket-total"></span> -->
											<span class="eventer-wc-ticket-added"></span></div></td>
								</tr></table>';
								}
								else
								{
									esc_html_e('Sorry, Event passed', 'eventer');
								}
								echo '</li>';
							}
							echo '</ul></div>';
						}
				?>
			<a href="<?php echo esc_url($booking_url); ?>" target="<?php echo esc_attr($booking_url_target); ?>" class="eventer-btn eventer-btn-primary"><?php esc_html_e('View cart', 'eventer'); ?></a>
		</div>
</div>
