<?php
function eventer_show_title($title = '', $id = '', $all_data = array())
{
   $booked_tickets_status = (!empty($all_data) && isset($all_data['booked_tickets']) && isset($all_data['booked_tickets'][0]['badge']) && $all_data['booked_tickets'][0]['badge']!='')?'<span class="eventer-status-badge">'.$all_data['booked_tickets'][0]['badge'].'</span>':'';
   $recurring_icon_switch = (!empty($all_data) && isset($all_data['recurring']))?$all_data['recurring']:'';
   $badge_switch = (!empty($all_data) && isset($all_data['badges']))?$all_data['badges']:'';
   $all_dates = (!empty($all_data) && isset($all_data['all_dates']))?$all_data['all_dates']:array();
   $recurring_icon = (($recurring_icon_switch=="on"&&count($all_dates)>1))?' <i class="eventer-icon-refresh"></i>':'';
   $event_cdate = $all_data['event_cdate'];
   $passed_badge = ($badge_switch=="on" && date_i18n('Y-m-d', $event_cdate)<date_i18n('Y-m-d'))?'<span class="eventer-status-badge eventer-status-passed">'.esc_html__('Passed', 'eventer').'</span>':'';
   $title .= '<div class="eventer-single-header">';
   $title .= apply_filters('eventer_content_before_title', $content = '', $id);
   $title .= '<h2>';
   $title .= apply_filters('eventer_raw_event_title', $title, $id);
   $title .= $recurring_icon.' '.$passed_badge;
   $title .= $booked_tickets_status;
   $title .= '</h2>';
   $title .= apply_filters('eventer_content_after_title', $content = '', $id);
   $title .= '</div>';
   return $title;
}
add_filter('eventer_styled_single_title', 'eventer_show_title', 10, 3);

function eventer_show_raw_title($raw_title = '', $id = '')
{
   $raw_title = get_the_title($id);
   return $raw_title;
}
add_filter('eventer_raw_event_title', 'eventer_show_raw_title', 10, 2);

function eventer_content_before_title($content = '', $id = '')
{
   return $content;
}
add_filter('eventer_content_before_title', 'eventer_content_before_title', 10, 2);

function eventer_content_after_title($content = '', $id = '')
{
   return $content;
}
add_filter('eventer_content_after_title', 'eventer_content_after_title', 10, 2);

function eventer_show_title_listing($title = '', $id = '', $all_data = array())
{
   $event_cdate = (isset($all_data['event_cdate']))?$all_data['event_cdate']:date_i18n('U');
   $booked_tickets_create = (!empty($all_data) && isset($all_data['booked_tickets'][date_i18n('Y-m-d', $event_cdate)]))?$all_data['booked_tickets'][date_i18n('Y-m-d', $event_cdate)]:'';
   $booked_tickets_status = (!empty($booked_tickets_create) && isset($booked_tickets_create[0]['badge']) && $booked_tickets_create[0]['badge']!='')?'<span class="eventer-status-badge">'.$booked_tickets_create[0]['badge'].'</span>':'';
   $recurring_icon_switch = (!empty($all_data) && isset($all_data['recurring']))?$all_data['recurring']:'';
   $badge_switch = (!empty($all_data) && isset($all_data['badges']))?$all_data['badges']:'';
   $all_dates = (!empty($all_data) && isset($all_data['all_dates']))?$all_data['all_dates']:array();
   $recurring_icon = (($recurring_icon_switch=="on"&&count($all_dates)>1))?' <i class="eventer-icon-refresh"></i>':'';
   
   $passed_badge = ($badge_switch=="on" && date_i18n('Y-m-d', $event_cdate)<date_i18n('Y-m-d'))?'<span class="eventer-status-badge eventer-status-passed">'.esc_html__('Passed', 'eventer').'</span>':'';
   $title .= '<span class="eventer-event-title">';
   $title .= apply_filters('eventer_content_before_title', $content = '', $id);
   $title .= apply_filters('eventer_raw_event_title', $title, $id);
   $title .= $recurring_icon.' '.$passed_badge;
   $title .= $booked_tickets_status;
   $title .= apply_filters('eventer_content_after_title', $content = '', $id);
   $title .= '</span>';
   return $title;
}
add_filter('eventer_styled_listing_title', 'eventer_show_title_listing', 10, 3);

add_action ('template_redirect', 'eventer_custom_permalink_redirect', 9999);
function eventer_custom_permalink_redirect() {
  global $post;
   if( is_singular('eventer') )
   {
      $external_link =  get_post_meta( $post->ID, 'eventer_event_custom_permalink', true );
      if($external_link)
      {
         if ( ! wp_script_is( 'jquery', 'done' ) )
         {
            wp_enqueue_script( 'jquery' );
         }
         wp_add_inline_script( 'jquery-migrate', 'window.location.href="'.esc_url($external_link).'"' );
      }
   }
}

function eventer_event_permalink_setup($create_link='', $URL='', $id='')
{
   $event_permalink_target = get_post_meta($id, 'eventer_event_custom_permalink_target', true);
   $create_link = (empty($create_link))?'href="'.esc_url($URL).'" target="'.esc_attr($event_permalink_target).'"':$create_link;
   return $create_link;
}
add_filter('eventer_permalink_setup', 'eventer_event_permalink_setup', 10, 3);

function eventer_formatting_email_content($content = '', $registrant_details = array(), $email_content = '')
{
   if(empty($registrant_details) || empty($email_content)) return '';
   $eventer_id = $registrant_details->eventer;
	$tickets = $registrant_details->tickets;
	$registrant_id = $registrant_details->id;
	$registrant_email = $registrant_details->email;
	$amount = $registrant_details->amount;
	$eventer_date = $registrant_details->eventer_date;
   $eventer_date_formatted = date_i18n(get_option('date_format'), strtotime($eventer_date));
	$transaction_id = ($registrant_details->transaction_id!='')?$registrant_details->transaction_id:md5(uniqid($registrant_id, true));
   if($registrant_details->transaction_id=='')
   {
      eventer_update_registrant_details(array('transaction_id' => $transaction_id), $registrant_id, array("%s", "%s"));
   }
	$payment_status = $registrant_details->status;
	$user_details = $registrant_details->user_details;
	$paymentmode = $registrant_details->paymentmode;
	$organizer = wp_get_object_terms($eventer_id, 'eventer-organizer');
	$organizer_email = $completed_url_tkt = $pending_url_tkt = $failed_url_tkt = '';
   //Getting all tickets data that registrant selected
	$reg_tickets = unserialize($tickets);
	$tickets = '';
   $user_fields_val = $registrant_tickets_name = $registrant_tickets_vals = array();
	if(!empty($reg_tickets))
	{
      $ticket_start = 1;
		foreach($reg_tickets as $ticket)
		{
			if(isset($ticket['number']) && $ticket['number']!='')
			{
				$tickets .= $ticket['name'].' X '.$ticket['number'].'<br/>';
			}
         $registrant_tickets_name['{ticket'.$ticket_start.'}'] = $ticket['name'];
         $registrant_tickets_vals['{ticket_nos'.$ticket_start.'}'] = $ticket['number'];
         $ticket_start++;
		}
	}
	$user_info = '';
   
	if(!empty($user_details))
	{
		//Getting all user details that user fills before selecting event tickets
		$user_details = unserialize($user_details);
		foreach($user_details as $details)
		{
         $user_fields_val['{'.$details['name'].'}'] = $details['value'];
			$user_info .= '<p>'.esc_attr($details['name']).': '.esc_attr($details['value']).'</p>';
		}
	}
	$message_dynamic = $email_content;
	//This switch checks payment mode and filter shortcodes of email content for respective payment mode
	//This will remoe all shortcodes except the selected mode
	switch($paymentmode)
	{
		case 'Free':
		remove_shortcode('eventer_paid');
		remove_shortcode('eventer_offline');
		$content = do_shortcode($message_dynamic);
		$registration_content_new = preg_replace('#\[[^\]]+\]#', '',$content);
		break;
		case 'Offline':
		remove_shortcode('eventer_paid');
		remove_shortcode('eventer_free');
		$content = do_shortcode($message_dynamic);
		$registration_content_new = preg_replace('#\[[^\]]+\]#', '',$content);
		break;
		default:
		remove_shortcode('eventer_offline');
		remove_shortcode('eventer_offline');
		$content = do_shortcode($message_dynamic);
		$registration_content_new = preg_replace('#\[[^\]]+\]#', '',$content);
		break;
	}
	//Generate unique number using registration ID
	//We here using $start =8 and $end = 9, so that user can see tickets when receiving this email
	$registration_unique_number = eventer_encode_security_registration($registrant_id, 8, 9);
	if($payment_status=="Completed" || $payment_status=="completed")
	{
		$completed_url_tkt = eventer_generate_endpoint_url('edate', $eventer_date, get_permalink($eventer_id));
		$completed_url_tkt = add_query_arg(array('reg' => $registration_unique_number), $completed_url_tkt);
	}
	if($payment_status=="Pending" || $payment_status=="pending")
	{
		$pending_url_tkt = 'pending';
	}
	elseif($payment_status=="Failed" || $payment_status=="failed")
	{
		$failed_url_tkt = 'failed';
	}
   $eventer_currency = eventer_get_currency_symbol(eventer_get_settings( 'eventer_paypal_currency' ));
	//We are here changing provided codes to the dynamic data of registrants
	$vars = array(
		'{reg_id}'       	=> esc_attr($registrant_id),
		'{tx_id}' 				=> esc_attr($transaction_id),
		'{pmt_st}'       	=> esc_attr($payment_status),
		'{reg_email}'   	=> $registrant_email,
		'{amt_pd}'   			=> esc_attr($eventer_currency.$amount),
      '{evt_date}'   			=> esc_attr($eventer_date_formatted),
      '{evt_title}'   			=> apply_filters('eventer_raw_event_title', '', $eventer_id),
		'{evt_url}' 			=> esc_url(eventer_generate_endpoint_url('edate', $eventer_date, get_permalink($eventer_id))),
		'{tkt}'   				=> $tickets,
		'{user_details}'  => $user_info,
		'{completed}'   	=> $completed_url_tkt,
		'{pending}'   		=> $pending_url_tkt,
		'{failed}'   			=> $failed_url_tkt,
	);
   $new_vars = array_merge($vars, $user_fields_val, $registrant_tickets_name, $registrant_tickets_vals);
	$message = strtr($registration_content_new, $new_vars);
   $content = $message;
   return $content;
}
add_filter('eventer_filter_email_content_body', 'eventer_formatting_email_content', 10, 3);


function eventer_formatting_woo_email_content($content = '', $order_id = '', $email_content = '')
{
   if(empty($email_content) && $order_id!='')
   {
      $event_trs = $venue_image = '';
      $order = wc_get_order( $order_id );
      $order_items_start = 1;
      $organizer_email = $elocation = '';
      $registrant_uname = get_post_meta($order_id, '_billing_first_name', true).' '.get_post_meta($order_id, '_billing_last_name', true);
      $registrant_email = get_post_meta($order_id, '_billing_email', true);
   foreach ($order->get_items() as $item_key => $item_values):
      $item_data = $item_values->get_data();
      $item_id = $item_values->get_id();
      $product_id = $item_data['product_id'];
      if(!has_term('eventer', 'product_cat', $product_id)) continue;
      $event_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
      $event_time = get_post_meta($event_id, 'eventer_event_start_dt', true);
      $event_time = date_i18n(get_option('time_format'), strtotime($event_time));
      $event_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
      $event_date = strtotime($event_date);
      $product_name = $item_data['name'];
      $quantity = $item_data['quantity'];
      $order_num = 'we'.$order_id.'-'.$order_items_start;
      $eventer_organizer = get_the_terms($event_id, 'eventer-organizer');
      $eventer_venue = get_the_terms($event_id, 'eventer-venue');
     
      if(!is_wp_error($eventer_venue)&&!empty($eventer_venue))
      {
         foreach($eventer_venue as $venue)
         {
            $location_address = get_term_meta($venue->term_id, 'venue_address', true);
            $elocation = ($location_address!='')?$location_address:$venue->name;
            $venue_image = get_term_meta($venue->term_id, 'venue_image', true);
            if($venue_image)
            {
               $image_src = wp_get_attachment_image_src($venue_image, 'full');
               $venue_image = $image_src[0];
            }
         }
      }
      if(!is_wp_error($eventer_organizer)&&!empty($eventer_organizer))
      {
         foreach($eventer_organizer as $organizer)
         {
            $organizer_email = get_term_meta($organizer->term_id, 'organizer_email', true);
         }
      }
      $event_trs .= '<tr>
				<td align="left" valign="top" style="border-collapse: collapse; border-spacing: 0;
					padding-top: 30px;
					padding-right: 20px;"><img
				border="0" vspace="0" hspace="0" style="padding: 0; margin: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; border: none; display: block;
					color: #000000;"
					src="'.get_the_post_thumbnail_url($event_id, 'medium').'"
					alt="H" title="Highly compatible"
					width="100" height="100"></td>
				<td align="left" valign="top" style="font-size: 17px; font-weight: 400; line-height: 160%; border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;
					padding-top: 25px;
					color: #000000;
					font-family: sans-serif;" class="paragraph">
						<b style="color: #333333;">'.get_the_title($event_id).'</b><br/>
						'.esc_attr($product_name).' X '.esc_attr($quantity).'<br/>
						'.esc_html__('Event Date', 'eventer').': '.esc_attr(date_i18n(get_option('date_format'), $event_date)).'<br/>
						'.(($organizer_email!='')?esc_html__('Contact Manager', 'eventer').': '.$organizer_email.'<br/>':'').'
                  '.(($elocation!='')?esc_html__('Location', 'eventer').': '.$elocation.'<br/>':'').'
				</td>

			</tr>';
      endforeach;
      $email_content = '<html xmlns="http://www.w3.org/1999/xhtml">
                           <head>
                              <meta name="viewport" content="width=device-width, initial-scale=1.0;">
                              <meta name="format-detection" content="telephone=no"/>
                              <style>
                                 body { margin: 0; padding: 0; min-width: 100%; width: 100% !important; height: 100% !important;}
                                 body, table, td, div, p, a { -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%; }
                                 table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse !important; border-spacing: 0; }
                                 img { border: 0; line-height: 100%; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; }
                                 #outlook a { padding: 0; }
                                 .ReadMsgBody { width: 100%; } .ExternalClass { width: 100%; }
                                 .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div { line-height: 100%; }
                                 @media all and (min-width: 560px) {
                                 .container { border-radius: 8px; -webkit-border-radius: 8px; -moz-border-radius: 8px; -khtml-border-radius: 8px;}
                                 }

                                 /* Set color for auto links (addresses, dates, etc.) */ 
                                 a, a:hover {
                                    color: #127DB3;
                                 }
                                 .footer a, .footer a:hover {
                                    color: #999999;
                                 }

                              </style>
                           </head>
                           <body topmargin="0" rightmargin="0" bottommargin="0" leftmargin="0" marginwidth="0" marginheight="0" width="100%" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%; height: 100%; -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%;
                              background-color: #F0F0F0;
                              color: #000000;"
                              bgcolor="#F0F0F0"
                              text="#000000">
                              <table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%;" class="background"><tr><td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;"
                                 bgcolor="#F0F0F0">
                                 <table border="0" cellpadding="0" cellspacing="0" align="center"
                                    bgcolor="#FFFFFF"
                                    width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
                                    max-width: 560px;" class="container">
                                    <tr>
                                       <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 24px; font-weight: bold; line-height: 130%;
                                          padding-top: 25px;
                                          color: #000000;
                                          font-family: sans-serif;" class="header">
                                          '.esc_html__('Here is your order details', 'eventer').'
                                       </td>
                                    </tr>
                                    <tr>
                                       <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-bottom: 3px; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 18px; font-weight: 300; line-height: 150%;
                                          padding-top: 5px;
                                          color: #000000;
                                          font-family: sans-serif;" class="subheader">
                                          '.esc_html__('Welcome to', 'eventer').' '.get_bloginfo('name').'
                                       </td>
                                    </tr>
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;
			padding-top: 20px;" class="hero"><img border="0" vspace="0" hspace="0"
			src="'.esc_url($venue_image).'"
			alt="" title="Event Image"
			width="560" style="
			width: 100%;
			max-width: 560px;
			color: #000000; font-size: 13px; margin: 0; padding: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; border: none; display: block;"/></td>
	</tr>
	<tr>
		<td align="left" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 25px; 
			color: #000000;
			font-family: sans-serif;" class="paragraph">
			'.esc_html__('Please see order details below and make sure that every details are correct as you filled while registering for event.', 'eventer').'<br/>
			Registrant: '.$registrant_uname.'<br/>
			Order ID: we'.$order_id.'<br/>
         Email: '.$registrant_email.'<br/>
			
		</td>
	</tr>
	<tr>	
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;" class="line"><hr
			color="#E0E0E0" align="center" width="100%" size="1" noshade style="margin: 0; padding: 0;" />
		</td>
	</tr>

	<!-- LIST -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%;" class="list-item">
			<table align="left" border="0" cellspacing="0" cellpadding="0" style="width: inherit; margin: 0; padding: 0; border-collapse: collapse; border-spacing: 0;">
			
			<!-- LIST ITEM -->
			'.$event_trs.'

		</table></td>
	</tr>
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;" class="line"><hr
			color="#E0E0E0" align="center" width="100%" size="1" noshade style="margin: 0; padding: 0;" />
		</td>
	</tr>
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 20px;
			padding-bottom: 25px;
			color: #000000;
			font-family: sans-serif;" class="paragraph">
				Have a&nbsp;question? <a href="mailto:'.get_option('admin_email').'" target="_blank" style="color: #127DB3; font-family: sans-serif; font-size: 17px; font-weight: 400; line-height: 160%;">'.get_option('admin_email').'</a>
		</td>
	</tr>

<!-- End of WRAPPER -->
</table>
<table border="0" cellpadding="0" cellspacing="0" align="center"
	width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="wrapper">

	<!-- FOOTER -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 13px; font-weight: 400; line-height: 150%;
			padding-top: 20px;
			padding-bottom: 20px;
			color: #999999;
			font-family: sans-serif;" class="footer">

				'.esc_html__('Thanks for registering event at our website', 'eventer').' '.esc_attr(get_bloginfo('name')).', '.esc_html__('we will be very happy to see you in event.', 'eventer').'

		</td>
	</tr>

<!-- End of WRAPPER -->
</table>

<!-- End of SECTION / BACKGROUND -->
</td></tr></table>

</body>
</html>';
return $email_content;
   }
   if(empty($order_id) || empty($email_content)) return '';
   $registrant_uname = get_post_meta($order_id, '_billing_first_name', true).' '.get_post_meta($order_id, '_billing_last_name', true);
	$registrant_email = get_post_meta($order_id, '_billing_email', true);
	$booked_registrant_tickets = array();
	$order = wc_get_order( $order_id );
   $generate_ticket_url = '';
	foreach ($order->get_items() as $item_key => $item_values):
		$item_data = $item_values->get_data();
		$item_id = $item_values->get_id();
		$event_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
		$product_name = $item_data['name'];
      $product_id = $item_values->get_product_id();
      if(!has_term('eventer', 'product_cat', $product_id)) continue;
		//if($event_id!=get_the_ID()) continue;
		$quantity = $item_data['quantity'];
		$booked_registrant_tickets[] = array('name'=>$product_name, 'number'=>$quantity);
      $generate_dynamic_order_id = eventer_encode_security_registration($order_id, 9, 9);
      $eventer_url = wc_get_order_item_meta($item_id, 'Event URL', true);
      $generate_ticket_url .= esc_url(add_query_arg('reg', $generate_dynamic_order_id, $eventer_url)).'<br/>';
	endforeach;
   $user_fields_val = $registrant_tickets_name = $registrant_tickets_vals = array();
	$order_num = 'we'.$order_id;
	$tickets = '';
	if(!empty($booked_registrant_tickets))
	{
      $ticket_start = 1;
		foreach($booked_registrant_tickets as $ticket)
		{
			if(isset($ticket['number']) && $ticket['number']!='')
			{
				$tickets .= $ticket['name'].' X '.$ticket['number'].'<br/>';
			}
         $registrant_tickets_name['{ticket'.$ticket_start.'}'] = $ticket['name'];
         $registrant_tickets_vals['{ticket_nos'.$ticket_start.'}'] = $ticket['number'];
         $ticket_start++;
		}
	}
   $event_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);
   $event_date = strtotime($event_date);
   
   
   
   $eventer_date_formatted = date_i18n(get_option('date_format'), $event_date);
	$message_dynamic = $email_content;
   
   $eventer_date = date_i18n('Y-m-d', $event_date);
	//We are here changing provided codes to the dynamic data of registrants
	$vars = array(
		'{reg_id}'       	=> esc_attr($order_id),
		'{tx_id}' 				=> esc_attr(get_post_meta($order_id, '_order_key', true)),
		'{pmt_st}'       	=> esc_attr($order->get_status()),
		'{reg_email}'   	=> $registrant_email,
		'{amt_pd}'   			=> esc_attr(get_post_meta($order_id, '_order_currency', true).get_post_meta($order_id, '_order_total', true)),
      '{evt_date}'   			=> esc_attr($eventer_date_formatted),
      '{evt_title}'   			=> apply_filters('eventer_raw_event_title', '', $event_id),
		'{evt_url}' 			=> esc_url(eventer_generate_endpoint_url('edate', $eventer_date, get_permalink($event_id))),
		'{tkt}'   				=> $tickets,
      '{evt_tkt}'   				=> $generate_ticket_url,
	);
   $new_vars = array_merge($vars, $registrant_tickets_name, $registrant_tickets_vals);
	$message = strtr($message_dynamic, $new_vars);
   $content = $message;
   return $content;
}
add_filter('eventer_filter_woo_email_content_body', 'eventer_formatting_woo_email_content', 10, 3);