<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
/*
	* Shortcode function file
	* These shortcode can be overwrite by using remove_shortcode function in init action
	* To alter shortcode in parent or child theme functions.php file
	* Please create a function and hook that in init action
	* create another function with any name and place all code of that shortcode which you would like to alter
*/
function eventer_register_shortcodes()
{
	if(!function_exists('eventer_counter_shortcode'))
	{
		/*
			* eventer_counter_shortcode function
			* Used to generate output of counter shortcode
		*/
		function eventer_counter_shortcode( $atts ) {
		$atts = shortcode_atts( array(
			'ids' => array(), //comma separated ids of event to show only those specific events
			'terms_cats' => array(), //comma separated category terms ids to show events from that categories only
			'terms_tags' => array(), //comma separated tag terms ids to show events from those tags only
			'terms_venue' => array(), //comma separated venues terms ids to show events from that venues only
			'terms_organizer' => array(), //comma separated organizers terms ids to show events from that organiers only
			'venue' => '1', //Whether to show venue or not
			'type' => '', //WP or Google
			'event_until' => '1', //Show event until start time or end time
			'pass' => '',
		), $atts, 'eventer_counter' );
		$countdown_output = '';
		$event_ids = eventer_merge_all_ids($atts['ids'], $atts['terms_cats'], $atts['terms_tags'], $atts['terms_venue'], $atts['terms_organizer']);
		$get_eventer_counter = eventer_get_events_array($event_ids, 'counters', '', '', '1', $atts['type'], $atts['event_until'], EVENTER__LANGUAGE_CODE, $atts['pass']);
		$no_result = '<div class="eventer eventer-countdown">';
		$no_result .= '<div class="eventer-event-details">';
		$no_result .= '<h3>'.esc_html__('Sorry, No more event to show', 'eventer').'</h3>';
		$no_result .= '</div>';
		$no_result .= '</div>';
		if($get_eventer_counter['results']<=0) return $no_result;
		$eventer = $get_eventer_counter['events'];
		$stime_format = esc_attr(eventer_get_settings('start_time_format'));
		$etime_format = esc_attr(eventer_get_settings('end_time_format'));
		$time_separator = esc_attr(eventer_get_settings('time_separator'));
		$date_format = esc_attr(eventer_get_settings('eventer_date_format'));
		$stime_format = ($stime_format=='')?get_option('time_format'):$stime_format;
		$etime_format = ($etime_format=='')?get_option('time_format'):$etime_format;
		$date_format = ($date_format=='')?get_option('date_format'):$date_format;
		$time_separator = ($time_separator=='')?' - ':$time_separator;
		$recurring_icon_switch = eventer_get_settings('eventer_recurring_icon_yes');
		foreach($eventer as $key=>$value)
		{
			if(get_post_status($value)!='publish') continue;
			$string_date = strtotime($key);
			$eventer_data = eventer_explore_event_ids($string_date, $value, $stime_format, $etime_format, $time_separator, $atts['event_until']);
			$event_all_dates = get_post_meta($value, 'eventer_event_frequency_type', true);
				$event_dynamic_dates = get_post_meta($value, 'eventer_event_multiple_dt_inc', true);
				$recurring_icon = (($recurring_icon_switch=="on"&&is_numeric($event_all_dates))||($recurring_icon_switch=="on"&&$event_dynamic_dates!=''))?' <i class="eventer-icon-refresh"></i>':'';
			if(!empty($eventer_data))
			{
				$event_ymd = date_i18n('Y-m-d', $eventer_data['show_counter']);
				$eventer_url = ($eventer_data['google_url']=='')?eventer_generate_endpoint_url('edate', $event_ymd, get_permalink($value)):$eventer_data['google_url'];
				$eventer_url = apply_filters('eventer_permalink_setup', '', $eventer_url, $value);
				$eventer_category = get_the_terms($value, 'eventer-category');
				if(!is_wp_error($eventer_category)&&!empty($eventer_category))
				{
					$color = get_term_meta( $eventer_category[0]->term_id, 'category_color', true);
					$color = ($color!='')?$color:'';
				}
				$counter_id = wp_rand();
					$countdown_output .= 
					'<div class="eventer eventer-countdown">
						<div class="eventer-event-date" style="background-color: '.$eventer_data['color'].'">
							<span class="eventer-event-day">'.esc_attr(date_i18n('d', $eventer_data['show_counter'])).'</span>
							<span class="eventer-event-month">'.esc_attr(date_i18n('F', $eventer_data['show_counter'])).'</span>
						</div>
						<div class="eventer-event-details">
							<label>'.esc_html__('Next', 'eventer').'</label>
							<span class="eventer-labeler">'.esc_attr($eventer_data['status']).' '.esc_html__('Event', 'eventer').'</span>
							<h3><a '.$eventer_url.'">'.esc_attr($eventer_data['etitle']).$recurring_icon.'</a></h3>';
						if($eventer_data['elocation']!='')
						{
							$countdown_output .= '<span class="eventer-event-venue"><i class="eventer-icon-location-pin"></i> '.esc_attr($eventer_data['elocation']).'</span>';
						}
						$countdown_output .= '</div>
						<div id="counter-'.$counter_id.'" class="eventer-countdown-timer" data-date="'.esc_attr(date_i18n('Y/m/d H:i', $string_date)).'"></div>
					</div>';
			}	
		}
		return $countdown_output;
	}
	add_shortcode( 'eventer_counter', 'eventer_counter_shortcode' );
	}
	
if(!function_exists('eventer_calendar_shortcode'))
{
	/*
			* eventer_calendar_shortcode function
			* Used to generate output of calendar shortcode
	*/
	function eventer_calendar_shortcode( $atts ) 
	{
		$atts = shortcode_atts( array(
			'ids' => '',
			'terms_cats' => '',
			'terms_tags' => '',
			'terms_venue' => '',
			'terms_organizer' => '',
			'type' => '',
			'preview' => '',
		), $atts, 'eventer_calendar' );
		$calendar_output = '';
		$google_calendar_id = '';
		if($atts['type']!="wp")
		{
			$google_calendar_id = eventer_get_settings('cal_id');
		}

		$site_lang = substr(get_locale(),0,2);
		if(function_exists('icl_object_id') && class_exists('SitePress'))
		{
			 $site_lang = ICL_LANGUAGE_CODE;
		}
		$calendar_view = (eventer_get_settings('eventer_calendar_view')!='')?eventer_get_settings('eventer_calendar_view'):'month';
		$calendar_header_left = eventer_get_settings('eventer_calendar_header_left_view');
		$calendar_header_center = eventer_get_settings('eventer_calendar_header_center_view');
		$calendar_header_right = eventer_get_settings('eventer_calendar_header_right_view');
		$calendar_week_start = get_option('start_of_week');
		$calendar_rtl = (eventer_get_settings('eventer_calendar_rtl')=='1')?true:false;
		$google_calendar_api = eventer_get_settings('google_cal_apikey');
		$time_format = eventer_convert_timeformat_tojs(get_option('time_format'));
		wp_enqueue_script('fullcalendar-min');
		wp_enqueue_script('fullcalendar-gcal');
		wp_enqueue_script('fullcalendar-locale');
		wp_enqueue_script('fullcalendar-load');
		//These are the values that we are sending to eventer_calenadar.js file
		wp_localize_script('fullcalendar-load', 'fcal', array('sitelan'=>$site_lang, 'homeurl' => EVENTER__PLUGIN_URL, 'calendar_api'=>$google_calendar_api, 'time_format'=>$time_format, 'cal_view'=>$calendar_view, 'header_left'=>$calendar_header_left, 'header_center'=>$calendar_header_center, 'header_right'=>$calendar_header_right, 'week_str'=>$calendar_week_start, 'cal_rtl'=>$calendar_rtl));
		wp_enqueue_style('fullcalendar-min');
		wp_enqueue_style('fullcalendar-print-min');

		$calendar_output .= '<div class="calendar"><div data-calendar="'.$google_calendar_id.'" class="shortcode-vals" style="display:none;">'.esc_attr(json_encode($atts)).'</div></div>';
		return $calendar_output;
	}
	add_shortcode( 'eventer_calendar', 'eventer_calendar_shortcode' );
}


if(!function_exists('eventer_shortcode_list'))
{
	/*
			* eventer_shortcode_list function
			* Used to generate output of event list shortcode
	*/
	function eventer_shortcode_list( $atts ) 
	{
		$atts = shortcode_atts( array(
			'ids' => array(),
			'terms_cats' => array(),
			'terms_tags' => array(),
			'terms_venue' => array(),
			'terms_organizer' => array(),
			'venue' => '1',
			'type' => '',
			'status' => 'future',
			'calview' => '',
			'filters' => '',
			'view' => 'compact',
			'count' => get_option('posts_per_page'),
			'pagination' => '',
			'pass' => '',
			'month_filter' => '',
			'event_until' => '1',
		), $atts, 'eventer_list' );
		$date_array = $time_icon = $calview = $today_btn = $date_range = $eventkeys = $search_range = '';
		$event_count = $atts['count'];
		$site_lang = substr(get_locale(),0,2);
		if(function_exists('icl_object_id') && class_exists('SitePress'))
		{
			 $site_lang = ICL_LANGUAGE_CODE;
		}
		$from_date = (isset($_REQUEST['efrom']))?$_REQUEST['efrom']:'';
		$to_date = (isset($_REQUEST['eto']))?$_REQUEST['eto']:'';
		$all_cats = array();
		$atts['site_lang'] = $site_lang;
		
		$first_event_date = get_option('eventer_extreme_first_event_date');
		$current_date = date_i18n('Y-m-d');
		$date_start = $current_date;
		$date_end = date_i18n('Y-m-d', strtotime('+5 year', date_i18n('U')));
		if($atts['month_filter']!='')
		{
			$month = (isset($_REQUEST['jump_date']))?esc_attr($_REQUEST['jump_date']):$current_date;
			$cal_view = (isset($_REQUEST['calview']))?esc_attr($_REQUEST['calview']):'';
			$cal_view = ($cal_view!='')?$cal_view:$atts['status'];
			$filtering_data = eventer_filtering_values($cal_view, $month);
			$date_start = $filtering_data['start_dt'];
			$date_end = $filtering_data['end_dt'];
			$event_count = 1000;
		}
		$atts['current_date'] = $current_date;
		
		$date_array = ($from_date!=''&&$to_date!='')?array($from_date, $to_date):array($date_start, $date_end);
		if($atts['view']!="minimal")
		{
			$time_icon = '<i class="eventer-icon-clock"></i>';
		}
		$terms_cats = (!empty($atts['terms_cats']))?explode(',', $atts['terms_cats']):array();
		$terms_tags = (!empty($atts['terms_tags']))?explode(',', $atts['terms_tags']):array();
		$terms_venue = (!empty($atts['terms_venue']))?explode(',', $atts['terms_venue']):array();
		$terms_organizer = (!empty($atts['terms_organizer']))?explode(',', $atts['terms_organizer']):array();
		if($atts['filters']!='' && ($atts['status']!='future' && $atts['status']!='past'))
		{
			$cats = (isset($_REQUEST['terms_cats']))?explode(',', $_REQUEST['terms_cats']):array();
			$terms_cats = array_merge($terms_cats, $cats);
			$tags = (isset($_REQUEST['terms_tags']))?explode(',', $_REQUEST['terms_tags']):array();
			$terms_tags = array_merge($terms_tags, $tags);
			$venues = (isset($_REQUEST['terms_venue']))?explode(',', $_REQUEST['terms_venue']):array();
			$terms_venue = array_merge($terms_venue, $venues);
			$organizers = (isset($_REQUEST['terms_organizer']))?explode(',', $_REQUEST['terms_organizer']):array();
			$terms_organizer = array_merge($terms_organizer, $organizers);
			$all_cats = array_merge($terms_cats, $terms_tags, $terms_venue, $terms_organizer);
		}
		$pagination = $atts['pagination'];
		$pagin = ($pagination)?get_query_var('pagin'):1;
		$list_output = '';
		$event_ids = eventer_merge_all_ids($atts['ids'], $terms_cats, $terms_tags, $terms_venue, $terms_organizer);
		$event_ids = array_merge($event_ids, $all_cats);
		if(is_search())
		{
			$get_eventer_list = eventer_search_result_data($event_ids, $atts['status'], $date_array, $pagin, $event_count, $atts['type'], $atts['event_until']);
		}
		else
		{
			$get_eventer_list = eventer_get_events_array($event_ids, $atts['status'], $date_array, $pagin, $event_count, $atts['type'], $atts['event_until'], EVENTER__LANGUAGE_CODE, $atts['pass']);
		}


		$eventer = $get_eventer_list['events'];
		$list_output .= 
					'<div class="eventer eventer-list">
					<div data-status="'.$atts['status'].'" style="display:none;" class="shortcode-attrs">'.esc_attr(json_encode($atts)).'</div>';
		if($atts['filters']!='' || ($atts['month_filter']!='' && $pagination!='yes') && $atts['status']!='future' && $atts['status']!='past')
		{
			$atts['from_date'] = $from_date;
			$atts['to_date'] = $to_date;
			$list_output .= '<div class="eventer-month-switcher-wrap">';
			$list_output .= apply_filters('eventer_list_date_filter', $atts, $filtering_data);
			$list_output .= apply_filters('eventer_list_category_filter', $atts, $all_cats);
			$list_output .= '</div>';
		}
		$list_output .= '<div class="eventer-'.$atts['view'].'-list">
							<div class="eventer-loader-wrap" style="display: none"><div class="eventer-loader"></div></div>
							<ul class="monthly-list">';
		if($get_eventer_list['results']>0)
		{
			$stime_format = esc_attr(eventer_get_settings('start_time_format'));
			$etime_format = esc_attr(eventer_get_settings('end_time_format'));
			$time_separator = esc_attr(eventer_get_settings('time_separator'));
			$date_format = esc_attr(eventer_get_settings('eventer_date_format'));
			$stime_format = ($stime_format=='')?get_option('time_format'):$stime_format;
			$etime_format = ($etime_format=='')?get_option('time_format'):$etime_format;
			$date_format = ($date_format=='')?get_option('date_format'):$date_format;
			$time_separator = ($time_separator=='')?' - ':$time_separator;
			$recurring_icon_switch = eventer_get_settings('eventer_recurring_icon_yes');
			$title_data_passed = array();
			$badge_switch = eventer_get_settings('eventer_show_badges');
			$title_data_passed['recurring'] = $recurring_icon_switch;
			$title_data_passed['badges'] = $badge_switch;
			foreach($eventer as $key=>$value)
			{
				if(strtotime($key)<date_i18n('U') || get_post_status($value)!='publish') continue;
				$color = '';
				$start_date_span = $start_details_span = $start_list = $start_hyperlink = $list_end = $event_venue = '';
				$string_date = strtotime($key);

				$eventer_data = eventer_explore_event_ids($string_date, $value, $stime_format, $etime_format, $time_separator, $atts['event_until']);
				$event_all_dates = get_post_meta($value, 'eventer_event_frequency_type', true);
				$event_dynamic_dates = get_post_meta($value, 'eventer_event_multiple_dt_inc', true);
				$recurring_icon = (($recurring_icon_switch=="on"&&is_numeric($event_all_dates))||($recurring_icon_switch=="on"&&$event_dynamic_dates!=''))?' <i class="eventer-icon-refresh"></i>':'';
				$event_ymd = date_i18n('Y-m-d', $eventer_data['show_counter']);
				$eventer_url = ($eventer_data['google_url']=='')?eventer_generate_endpoint_url('edate', $event_ymd, get_permalink($value)):$eventer_data['google_url'];
				$eventer_url = apply_filters('eventer_permalink_setup', '', $eventer_url, $value);
				$event_month = '<span class="eventer-event-month">'.esc_attr(date_i18n('F', $eventer_data['show_counter'])).'</span>';
				$event_year = '<span class="eventer-event-year">'.esc_attr(date_i18n(' Y', $eventer_data['show_counter'])).'</span>';
				$event_time = '<span class="eventer-event-time">'.$time_icon.' '.$eventer_data['etime'].'</span>';
				$original_event = eventer_wpml_original_post_id($value);
				$title_data_passed['event_cdate'] = strtotime($key);
				$title_data_passed['all_dates'] = get_post_meta($value, 'eventer_all_dates', true);
				$title_data_passed['booked_tickets'] = get_post_meta($original_event, 'specific_eventer_tickets', true);
				$event_title = apply_filters('eventer_styled_listing_title', $title = '', $value, $title_data_passed);
				$color = $eventer_data['color'];
				$multiday_class = (isset($eventer_data['multiday_start']) && $eventer_data['multiday_start']!='')?'eventer-event-multiday ':'eventer-event-day ';
				$multiday_start = (isset($eventer_data['multiday_start']) && $eventer_data['multiday_start']!='')?'<span class="'.esc_attr($multiday_class).' eventer-event-multiday-border">'.$eventer_data['multiday_start'].'</span>':'';
				$multiday_end = (isset($eventer_data['multiday_end']) && $eventer_data['multiday_end']!='')?'<span class="'.esc_attr($multiday_class).'">'.$eventer_data['multiday_end'].'</span>':'';
				$single_day_set = (isset($eventer_data['multiday_start']) && $eventer_data['multiday_start']!='')?$multiday_start.$multiday_end:'<span class="'.esc_attr($multiday_class).'">'.date_i18n('d', $eventer_data['show_counter']).'</span>';
				if($atts['view']=="minimal")
				{
					$single_day_set = ($multiday_start=='')?'<span class="eventer-event-day pull-left">'.date_i18n('d', $eventer_data['show_counter']).'</span>':'';
					$event_year = ($multiday_start=='')?$event_year:'';
					$event_month = ($multiday_start=='')?$event_month:'<span class="eventer-event-month">'.$eventer_data['multiday_start'].'-'.$eventer_data['multiday_end'].'</span>';
					$border_left_color = ($color)?' style="border-left-color:'.$color.'"':'';
					$start_list .= '<li class="eventer-event-item eventer-event-list-item" '.$border_left_color.'>';
					$start_hyperlink .= '<a '.$eventer_url.'" class="eventer-event-item-link equah">';

					$start_date_span .= '<span class="eventer-event-date">';
					$start_date_span .= '<span><span class="eventer-cell">
												'.$single_day_set.'
												<span class="eventer-dater">';
					$start_date_span .= $event_month;
					$start_date_span .= $event_year;
					$start_date_span .= $event_time;
					$start_date_span .= '</span>
										</span></span></span>';

					$start_details_span .= '<span class="eventer-event-details">';
					$start_details_span .= $event_title;
					if($eventer_data['elocation']!='' && $atts['venue']!='no')
					{
						if($atts['venue']=='name')
						{
							$start_details_span .= '<span class="eventer-event-venue"> '.esc_attr($eventer_data['venue_name']).'</span>';
						}
						else
						{
							$start_details_span .= '<span class="eventer-event-venue"> '.esc_attr($eventer_data['elocation']).'</span>';
						}
						
					}
					$start_details_span .= '</span>';
					$list_end .= '</a>
									</li>';
				}
				else
				{
					$start_details_span .= '<span class="eventer-event-details">';
					$class_thumb = '';
					if(has_post_thumbnail($value))
					{
						$start_details_span .= get_the_post_thumbnail($value, 'eventer-thumb-170x170', array('class'=>'eventer-event-image'));
						$class_thumb = 'eventer-event-list-item-wi';
					}
					$border_top_color = ($color)?' style="border-top-color:'.$color.'"':'';
					$start_list .= '<li class="eventer-event-item eventer-event-list-item '.$class_thumb.'">';
					$start_hyperlink .= '<a '.$eventer_url.'" class="eventer-event-item-link">';

					$start_date_span .= '<span class="eventer-event-date" '.$border_top_color.'>';
					$start_date_span .= $single_day_set;
					if($multiday_start=='')
					{
						$start_date_span .= $event_month;
					}
					
					$start_date_span .= $event_year;
					$start_date_span .= '</span>';


					$start_details_span .= '<span class="eventer-event-details-side">';
					$start_details_span .= $event_time;;
					$start_details_span .= $event_title;
					if($eventer_data['elocation']!='' && $atts['venue']!='no')
					{
						if($atts['venue']=='name')
						{
							$start_details_span .= '<span class="eventer-event-venue"><i class="eventer-icon-location-pin"  style="color:'.$color.'"></i> '.esc_attr($eventer_data['venue_name']).'</span>';
						}
						else
						{
							$start_details_span .= '<span class="eventer-event-venue"><i class="eventer-icon-location-pin"  style="color:'.$color.'"></i> '.esc_attr($eventer_data['elocation']).'</span>';
						}
						
					}
					$start_details_span .= '</span>';
					$start_details_span .= '</span>';
					$start_details_span .= '<i class="eventer-icon-arrow-right"></i>';
					$list_end .= '</a>
									</li>';
				}

				if(!empty($eventer_data))
				{
					$list_output .= $start_list;
					$list_output .= $start_hyperlink;
					$list_output .= $start_date_span;
					$list_output .= $start_details_span;
					$list_output .= $list_end;
				}
			}	

			if($atts['pagination'])
			{
				$total_results = $get_eventer_list['results'];
				$current_page_count = $event_count;
				$pages_pagination = $total_results/$current_page_count;
				$pages_pagination_floor = floor($pages_pagination);
				$pages = ($pages_pagination>$pages_pagination_floor)?$pages_pagination_floor+1:$pages_pagination_floor;
				$pagin_paged = (get_query_var('pagin'))?get_query_var('pagin'):1;
				$pagination = eventer_pagination($pages, $pagin_paged);
			}
		}
		elseif($pagination!='yes')
		{
			$halfyear_msg = esc_html__('Search events for next six months.', 'eventer');
			$fullyear_msg = esc_html__('Search events for next twelve months.', 'eventer');
			$longjump = date_i18n('Y-m', strtotime('+1 month'));
			$list_output .= '<div class="noresult-msg">';
			$list_output .= '<p>'.esc_html__('Sorry, no more events available for this month.', 'eventer').'</p>';
			$list_output .= '<p><a class="eventer-btn show_month_events next-month" data-jump="5" data-arrow="'.$longjump.'">'.$halfyear_msg.'</a></p>';
			$list_output .= '<p><a class="eventer-btn show_month_events next-month" data-jump="11" data-arrow="'.$longjump.'">'.$fullyear_msg.'</a></p>';
			$list_output .= '</div>';
		}
		else
		{

		}
		$list_output .= '
							</ul>
						</div>';
		$list_output .= $pagination;
		$list_output .= '</div>';
		return $list_output;
	}
	add_shortcode( 'eventer_list', 'eventer_shortcode_list' );
}

if(!function_exists('eventer_shortcode_grid'))
{
	/*
			* eventer_shortcode_grid function
			* Used to generate output of event grid shortcode
	*/
	function eventer_shortcode_grid( $atts ) 
	{
		$atts = shortcode_atts( array(
			'ids' => array(),
			'terms_cats' => array(),
			'terms_tags' => array(),
			'terms_venue' => array(),
			'terms_organizer' => array(),
			'type' => '',
			'status' => 'future',
			'background' => '',
			'column' => '3',
			'venue' => '1',
			'pagination' => '',
			'pass' => '',
			'count' => get_option('posts_per_page'),
			'event_until' => '1',
		), $atts, 'eventer_grid' );
		$date_array = $time_icon = '';
		$event_count = $atts['count'];
		$pagination = $atts['pagination'];
		$grid_output = '';
		$pagin = ($pagination)?get_query_var('pagin'):1;
		$event_ids = eventer_merge_all_ids($atts['ids'], $atts['terms_cats'], $atts['terms_tags'], $atts['terms_venue'], $atts['terms_organizer']);
		if(is_search())
		{
			$get_eventer_grid = eventer_search_result_data($event_ids, $atts['status'], $date_array, $pagin, $event_count, $atts['type'], $atts['event_until'], $atts['pass']);
		}
		else
		{
			$get_eventer_grid = eventer_get_events_array($event_ids, $atts['status'], $date_array, $pagin, $event_count, $atts['type'], $atts['event_until'], $atts['pass']);
		}
		if($get_eventer_grid['results']<=0) return;
		$eventer = $get_eventer_grid['events'];
		$grid_output .= '<div class="eventer eventer-grid eventer-grid-col'.$atts['column'].'">
											<div class="eventer-grid">
												<ul class="equah">';
		$stime_format = esc_attr(eventer_get_settings('start_time_format'));
		$etime_format = esc_attr(eventer_get_settings('end_time_format'));
		$time_separator = esc_attr(eventer_get_settings('time_separator'));
		$date_format = esc_attr(eventer_get_settings('eventer_date_format'));
		$stime_format = ($stime_format=='')?get_option('time_format'):$stime_format;
		$etime_format = ($etime_format=='')?get_option('time_format'):$etime_format;
		$date_format = ($date_format=='')?get_option('date_format'):$date_format;
		$time_separator = ($time_separator=='')?' - ':$time_separator;
		$recurring_icon_switch = eventer_get_settings('eventer_recurring_icon_yes');
		$title_data_passed = array();
		$badge_switch = eventer_get_settings('eventer_show_badges');
		$title_data_passed['recurring'] = $recurring_icon_switch;
		$title_data_passed['badges'] = $badge_switch;
		foreach($eventer as $key=>$value)
		{
			if(get_post_status($value)!='publish') continue;
			$start_date_span = $start_details_span = $start_list = $start_hyperlink = $list_end = $event_venue = $image_url = '';
			$string_date = strtotime($key);

			$eventer_data = eventer_explore_event_ids($string_date, $value, $stime_format, $etime_format, $time_separator, $atts['event_until']);
			$event_all_dates = get_post_meta($value, 'eventer_event_frequency_type', true);
			$event_dynamic_dates = get_post_meta($value, 'eventer_event_multiple_dt_inc', true);
			$recurring_icon = (($recurring_icon_switch=="on"&&is_numeric($event_all_dates))||($recurring_icon_switch=="on"&&$event_dynamic_dates!=''))?' <i class="eventer-icon-refresh"></i>':'';
			$event_ymd = date_i18n('Y-m-d', $eventer_data['show_counter']);
			$eventer_url = $eventer_url = ($eventer_data['google_url']=='')?eventer_generate_endpoint_url('edate', $event_ymd, get_permalink($value)):$eventer_data['google_url'];
			$eventer_url = apply_filters('eventer_permalink_setup', '', $eventer_url, $value);
			if(has_post_thumbnail($value))
			{
				$image_url = get_the_post_thumbnail_url($value);
			}
			if($atts['background']=='2' && $image_url==''){
				$grid_class = 'eventer-event-grid-item-plain';
			} elseif($atts['background']=='1' && ($eventer_data['color']=='' || $image_url=='')){
				$grid_class = 'eventer-event-grid-item-bg eventer-event-grid-item-dbg';
			} elseif($atts['background']!='3' && ($eventer_data['color']!='' || $image_url!='')){
				$grid_class = 'eventer-event-grid-item-bg';
			} else {
				$grid_class = 'eventer-event-grid-item-plain';
			}
			$grid_output .= '<li class="eventer-event-item eventer-event-grid-item '.$grid_class.'">';

			if(($atts['background']=='2'&&$image_url!='')||$atts['background']==''&&$image_url!='')
			{
				$grid_output_bg = '<a '.$eventer_url.'" class="eventer-event-grid-item-inside eventer-event-grid-item-bg-dark eventer-event-item-link" style="border-left-color:'.$eventer_data['color'].';background-image:url('.$image_url.')">';
			}
			elseif(($atts['background']=='1'&&$eventer_data['color']!='')||$atts['background']==''&&$eventer_data['color']!='')
			{
				$grid_output_bg = '<a '.$eventer_url.'" class="eventer-event-grid-item-inside eventer-event-item-link" style="border-left-color:'.$eventer_data['color'].'; background-color: '.$eventer_data['color'].'">';
			}
			else
			{
				$grid_output_bg = '<a '.$eventer_url.'" class="eventer-event-grid-item-inside eventer-event-item-link" style="border-left-color:'.$eventer_data['color'].'">';
			}
			$grid_output .= $grid_output_bg;
			$grid_output .= '<span class="eventer-event-details equah-item">';
			$original_event = eventer_wpml_original_post_id($value);
			$title_data_passed['event_cdate'] = strtotime($key);
			$title_data_passed['all_dates'] = get_post_meta($value, 'eventer_all_dates', true);
			$title_data_passed['booked_tickets'] = get_post_meta($original_event, 'specific_eventer_tickets', true);
			$grid_output .= apply_filters('eventer_styled_listing_title', $title = '', $value, $title_data_passed);
			if($eventer_data['elocation']!='' && $atts['venue']!='no')
			{
				if($atts['venue']=='name')
				{
					$grid_output .= '<span class="eventer-event-venue"><i class="eventer-icon-location-pin" style="color:'.$eventer_data['color'].'"></i> '.esc_attr($eventer_data['venue_name']).'</span>';
				}
				else
				{
					$grid_output .= '<span class="eventer-event-venue"><i class="eventer-icon-location-pin" style="color:'.$eventer_data['color'].'"></i> '.esc_attr($eventer_data['elocation']).'</span>';
				}
			}

			$grid_output .= '</span>';			
			$grid_output .= '<span class="eventer-event-date">';
			$grid_output .= '<span class="eventer-event-day">'.esc_attr(date_i18n('d', $eventer_data['show_counter'])).'</span>';
			$grid_output .= '<span class="eventer-event-month">'.esc_attr(date_i18n('F, Y', $eventer_data['show_counter'])).'</span>';
			$grid_output .= '<span class="eventer-event-time">'.$time_icon.' '.$eventer_data['etime'].'</span>';
			$grid_output .= '</span>';			
			$grid_output .= '</a>';		
			$grid_output .= '</li>';	


		}
		if($pagination)
		{
			$total_results = $get_eventer_grid['results'];
			$current_page_count = $event_count;
			$pages_pagination = $total_results/$current_page_count;
			$pages_pagination_floor = floor($pages_pagination);
			$pages = ($pages_pagination>$pages_pagination_floor)?$pages_pagination_floor+1:$pages_pagination_floor;
			$pagin_paged = (get_query_var('pagin'))?get_query_var('pagin'):1;
			$pagination = eventer_pagination($pages, $pagin_paged);
		}
		$grid_output .= '</ul>';
		$grid_output .= $pagination;

		$grid_output .= '</div></div>';
		return $grid_output;
	}
	add_shortcode( 'eventer_grid', 'eventer_shortcode_grid' );
}

if(!function_exists('eventer_generate_field'))
{
	/*
			* eventer_generate_field function
			* Used to generate output of fields that are using in book ticket and contact manager forms
	*/
	function eventer_generate_field($atts)
	{
		$atts = shortcode_atts( array(
			'type' => 'text',
			'class' => '',
			'id' => '',
			'placeholder' => '',
			'param' => array(),
			'name' => '',
			'label' => '',
			'text_row' => '4',
			'required' => 'no',
		), $atts, 'eventer_fields' );
		$checkbox_class = ($atts['type']=="checkbox")?'':'';
		$required_data = ($atts['required']=="yes")?'data-required="1"':'';
		$class = esc_attr($atts['class']);
		$id = ($atts['id']!='')?'id="'.esc_attr($atts['id']).'"':'';
		$name = ($atts['name']!='')?'name="'.esc_attr($atts['name']).'"':'';
		switch($atts['type'])
		{
			case 'textarea':
			$field = '<label>'.esc_attr($atts['label']).'</label> <textarea '.$required_data.' rows="'.esc_attr($atts['text_row']).'" '.$name.' '.$class.' '.$id.'></textarea>';
			break;
			case 'select':
			$field = '';
			$options = '';
			$options .= '<option value="">'.esc_html__('Select', 'eventer').'</option>';
			if(!empty($atts['param']))
			{
				$params = explode(',', $atts['param']);
				foreach($params as $param)
				{
					$selected = '';
					if(strpos($param, "{") !== false)
					{
						$param = preg_replace(array('/^\{/','/\}$/'), '',$param); 
						$selected = 'selected';
					}
					$options .= '<option '.$selected.' value="'.esc_attr($param).'">'.esc_attr($param).'</option>';
				}
				$field .= '<label>'.esc_attr($atts['label']).'</label> <select '.$required_data.' '.$name.' '.$class.' '.$id.'>';
				$field .= $options;
				$field .= '</select>';
			}
			break;
			case 'checkbox':
			$field = '';
			$checkboxes = '';
			if(!empty($atts['param']))
			{
				$field .= '<div class="check-radio-wrap"><label class="'.$checkbox_class.'">'.esc_attr($atts['label']).'</label>';
				$params = explode(',', $atts['param']);
				foreach($params as $param)
				{
					$checked = '';
					if(strpos($param, "{") !== false)
					{
						$param = preg_replace(array('/^\{/','/\}$/'), '',$param); 
						$checked = 'checked';
					}
					$checkboxes .= ' <input type="checkbox" '.$required_data.' '.$name.' '.$checked.' '.$class.' value="'.esc_attr($param).'"> '.esc_attr($param);
				}
				$field .= $checkboxes;
				$field .= '</div>';
			}
			break;
			case 'radio':
			$field = '';
			$radio = '';
			if(!empty($atts['param']))
			{
				$field .= '<div class="check-radio-wrap"><label class="'.$checkbox_class.'">'.esc_attr($atts['label']).'</label>';
				$params = explode(',', $atts['param']);
				foreach($params as $param)
				{
					$checked = '';
					if(strpos($param, "{") !== false)
					{
						$param = preg_replace(array('/^\{/','/\}$/'), '',$param); 
						$checked = 'checked';
					}
					$radio .= ' <input type="radio" '.$required_data.' '.$name.' '.$checked.' '.$class.' value="'.esc_attr($param).'"> '.esc_attr($param);
				}
				$field .= $radio;
				$field .= '</div>';
			}
			break;
			case 'number':
			$field = '<label>'.esc_attr($atts['label']).'</label> <input type="number" '.$required_data.' value="" '.$name.' '.$class.' '.$id.'>';
			break;
			case 'email':
			$field = '<label>'.esc_attr($atts['label']).'</label> <input type="email" '.$required_data.' value="" '.$name.' '.$class.' '.$id.'>';
			break;
			default:
			$field = '<label>'.esc_attr($atts['label']).'</label> <input type="text" '.$required_data.' value="" '.$name.' '.$class.' '.$id.'>';
			break;
		}
		return $field;
	}
	add_shortcode( 'eventer_fields', 'eventer_generate_field' );
}

	
function eventer_paid_shortcode($atts, $content = null) {
		extract(shortcode_atts(array(
			"data"		=> "",
		), $atts));		
		return $data;
	}
add_shortcode('eventer_paid', 'eventer_paid_shortcode');

function eventer_offline_shortcode($atts, $content = null) {
		extract(shortcode_atts(array(
			"data"		=> "",
		), $atts));		
		return $data;
	}
add_shortcode('eventer_offline', 'eventer_offline_shortcode');

function eventer_free_shortcode($atts, $content = null) {
		extract(shortcode_atts(array(
			"data"		=> "",
		), $atts));		
		return $data;
	}
add_shortcode('eventer_free', 'eventer_free_shortcode');
	
function eventer_field_row($atts, $content = null) {	
		return '<div class="eventer-row">'.do_shortcode($content).'</div>';
	}
add_shortcode('eventer_field_row', 'eventer_field_row');
	
function eventer_field_halfcol($atts, $content = null) {	
		return '<div class="eventer-col5 eventer-col10-xs">'.do_shortcode($content).'</div>';
	}
add_shortcode('eventer_field_halfcol', 'eventer_field_halfcol');
	
function eventer_ticket_url_in_email($atts, $content = null) {
		extract(shortcode_atts(array(
			"completed"		=> "",
			"pending"		=> "",
			"failed"		=> "",
		), $atts));	
		$completed = (isset($atts['completed']) && $atts['completed']=="1")?"1":'';
		$pending = (isset($atts['pending']) && $atts['pending']=="1")?"1":'';
		$failed = (isset($atts['failed']) && $atts['failed']=="1")?"1":'';
		$print_tkt = '';
		if($completed=="1")
		{
			$print_tkt .= '{completed}';
		}
		elseif($pending=="1")
		{
			$print_tkt .= '{pending}';
		}
		elseif($failed=="1")
		{
			$print_tkt .= '{failed}';
		}
		return $print_tkt;
	}
add_shortcode('eventer_tkturl', 'eventer_ticket_url_in_email');
}
add_action('init', 'eventer_register_shortcodes');	