jQuery(function($){
	"use strict";
	var EVENTER = window.EVENTER || {};
	
	// Match Height Function
	EVENTER.MH = function() {
		$('.equah').each(function() {
			$(this).find('.equah-item').matchHeight();
		});
	};
	    
	$(document).ready(function(){
		$('.eventers-filter-check').click(function(){
        $(".eventer-filter-select").slideUp();
    });
		
		function split( val ) {
		  return val.split( /,\s*/ );
		}
		function extractLast( term ) {
		  return split( term ).pop();
		}
 		var projects = initval.eventer_stored; 
		var eventers_show = $.map(projects, function(label, value) {
			return {value, label};
		});
    $( ".keyword-search-eventer" )
      .on( "keydown", function( event ) {
        if ( event.keyCode === $.ui.keyCode.TAB &&
            $( this ).autocomplete( "instance" ).menu.active ) {
          event.preventDefault();
        }
      })
      .autocomplete({
        minLength: 0,
        source: function( request, response ) {
          response( $.ui.autocomplete.filter(
            eventers_show, extractLast( request.term ) ) );
        },
        focus: function() {
          return false;
        },
        select: function( event, ui ) {
					var search_ids = split($(this).attr('data-search'));
					search_ids.push(ui.item.value);
					$(this).attr('data-search', search_ids);
          var terms = split( this.value );
          terms.pop();
          terms.push( ui.item.label );
          terms.push( "" );
          this.value = terms.join( ", " );
					var target_url = window.location.href;
				var status = $('.shortcode-attrs').attr("data-status");
				var shortcode_actual = JSON.parse($(this).closest('.eventer-list').find('.shortcode-attrs').text());
				var filter_data = EVENTER.GETFILTERDATA();
				$.each(filter_data, function(key, object) {
					target_url = EVENTER.APPENDQUERYURL(key, object, target_url);
				});
				var send_date = $(this).attr("data-arrow");
				EVENTER.EVENTERAJAXMONTHWISE(shortcode_actual, send_date, '', $(this).closest('div.eventer-list'), 0, target_url, filter_data, status);
          return false;
        }
      });
if (!!$.prototype.datepicker) {
$( function() {
    var dateFormat = "mm/dd/yy",
      from = $( "#eventer_from" )
        .datepicker({
			dateFormat: 'yy-mm-dd',
          	defaultDate: "+1w",
          	changeMonth: false,
          	numberOfMonths: 1,
			beforeShow: function() {
			   $('#ui-datepicker-div').addClass('eventer-custom-ui-datepicker');
		   }
        })
        .on( "change", function() {
					if($('#eventer_to').val()!='')
					{
						var target_url = window.location.href;
						target_url = EVENTER.APPENDQUERYURL('eto', $('#eventer_to').val(), target_url);
						target_url = EVENTER.APPENDQUERYURL('efrom', $(this).val(), target_url);
						var status = $('.shortcode-attrs').attr("data-status");
						var shortcode_actual = JSON.parse($(this).closest('.eventer-list').find('.shortcode-attrs').text());
						var filter_data = EVENTER.GETFILTERDATA();
						$.each(filter_data, function(key, object) {
							target_url = EVENTER.APPENDQUERYURL(key, object, target_url);
						});
						EVENTER.EVENTERAJAXMONTHWISE(shortcode_actual, $(this).val(), '', $(this).closest('div.eventer-list'), 0, target_url, filter_data, status);
					}
          to.datepicker( "option", "minDate", getDate( this ) );
        }),
      to = $( "#eventer_to" ).datepicker({
				dateFormat: 'yy-mm-dd',
        		defaultDate: "+1w",
        		changeMonth: false,
        		numberOfMonths: 1,
				beforeShow: function() {
				   $('#ui-datepicker-div').addClass('eventer-custom-ui-datepicker');
			   }
      })
      .on( "change", function() {
				var target_url = window.location.href;
				target_url = EVENTER.APPENDQUERYURL('efrom', $('#eventer_from').val(), target_url);
				target_url = EVENTER.APPENDQUERYURL('eto', $(this).val(), target_url);
				var status = $('.shortcode-attrs').attr("data-status");
				var shortcode_actual = JSON.parse($(this).closest('.eventer-list').find('.shortcode-attrs').text());
				var filter_data = EVENTER.GETFILTERDATA();
				$.each(filter_data, function(key, object) {
					target_url = EVENTER.APPENDQUERYURL(key, object, target_url);
				});
				EVENTER.EVENTERAJAXMONTHWISE(shortcode_actual, $(this).val(), '', $(this).closest('div.eventer-list'), 0, target_url, filter_data, status);
        from.datepicker( "option", "maxDate", getDate( this ) );
      });
 
    function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }
 
      return date;
    }
  	});
}
	window.addEventListener('popstate', function(e){
      	if(e.state) {
				//EVENTER.EVENTERAJAXMONTHWISE(shortcode_attr, send_date, arrow_class, $(this).closest('div.eventer-list'), data_jump, e.state.href, filter_data, status);
		}
   }); 
		
	//$('.save-registrant').prop('disabled', true); 
		EVENTER.MH();
		EVENTER.GETMODALHEIGHT = function(modalTrigger)
		{
			var windowHeight = $(window).height();
			var ticket_confirm = $('body').find(modalTrigger);
			var modalInner = ticket_confirm.find('.eventer-modal-wrap');
			var modalBody = modalInner.find('.eventer-modal-body');
			var modalHeight = modalBody.actual('innerHeight');
			var modalHeightn = parseInt(modalHeight, 10);
			if(modalHeight < windowHeight){
				modalInner.css("margin-top",-+modalHeightn/2);
			} else{
				modalInner.css({"top":60,"margin-bottom":"60px"});
			}
			ticket_confirm.fadeIn();
			$('body').addClass('eventer-overflow-hidden');
		};
		if(initval.register_status!=="")
		{ 
			EVENTER.GETMODALHEIGHT("#eventer-ticket-confirmation");
		}
		
		
		// Eventer filters date wise trigger
		$('.eventer-filter-datewise-wrap').hide();
		$(document).delegate('.eventer-datewise-filter-trigger', 'click',function(){
			$('.eventer-filter-datewise-wrap').slideToggle();
			$(this).toggleClass('trigger-active');
		});
	});
	$(document).delegate('.eventer-event-save', 'hover',function(){
		$(this).find('ul').toggle();
	});
	
	
	$(document).delegate('.eventer-modal-trigger', 'click',function(e){
		$('.eventer-modal').fadeOut();
		var modalTrigger = $(this).attr('data-eventer-modal');
		if(modalTrigger==='') { return; }
		EVENTER.GETMODALHEIGHT(modalTrigger);
		e.preventDefault();
	});
	$(document).delegate(".eventer-modal-body", 'click',function(e){
		e.stopPropagation();
	});
	$(document).delegate('.eventer-modal', 'click',function(){
		$(this).fadeOut();
		$('body').removeClass('eventer-overflow-hidden');
	});
	$(document).delegate('.eventer-modal-close', 'click',function(e){
		$(this).parents('.eventer-modal').fadeOut();
		$('body').removeClass('eventer-overflow-hidden');
		e.preventDefault();
	});
	
	$(document).delegate('.eventer-toggle-area-trigger', 'click',function(e){
		var dialog_heading = $(this).attr('data-eventer-dialog-heading');
		if(typeof dialog_heading!=='undefined' && dialog_heading!=='')
		{
			$(this).closest('.eventer-modal').find('.eventer-section-wise-heading').text(dialog_heading);
		}
		var targetIn = $(this).attr('data-eventer-toggle-in');
		var targetOut = $(this).attr('data-eventer-toggle-out');
		$(this).parents('.eventer-toggle-area').find(targetOut).slideUp('fast');
		$(this).parents('.eventer-toggle-area').find(targetIn).slideDown('slow');
		e.preventDefault();
	});
	
	
	$(document).delegate('.eventer-filter-trigger', 'click',function(e){ 
		if ($(this).parents('.eventer-filter-col').find('.eventer-filter-select').is(":visible")) {
		  	$(".eventer-filter-select").hide();
		} else {
		  $(".eventer-filter-select").hide();
		  $(this).parents('.eventer-filter-col').find('.eventer-filter-select').toggle();
		}
		e.preventDefault();
	});
EVENTER.EVENTERPRINTTICKET = function(elem)
{
	var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
	if(isChrome)
	{
		var divToPrint=document.getElementById(elem);
	var newWin=window.open('','Print-Window');
	newWin.document.open();
	newWin.document.write('<link rel="stylesheet" href="'+initval.eventer_style+'" type="text/css" />');
	newWin.document.write('<html><body class="eventer eventer-print-window" onload="window.print()">'+divToPrint.innerHTML+'</body></html>');
	newWin.document.close();
	setTimeout(function(){newWin.close();},10);
	}
	else
	{
    var mywindow = window.open('', 'PRINT', 'height=400,width=600');
	 mywindow.document.write('<html><head><title>' + document.title  + '</title>');
	 
	 mywindow.document.write('<link rel="stylesheet" href="'+initval.eventer_style+'" type="text/css" />');
    mywindow.document.write('</head><body class="eventer eventer-print-window">');
    mywindow.document.write('<h1>' + document.title  + '</h1>');
	 
    mywindow.document.write(document.getElementById(elem).innerHTML);
    mywindow.document.write('</body></html>');

    mywindow.document.close(); // necessary for IE >= 10
    mywindow.focus(); // necessary for IE >= 10*/

    mywindow.print();
    mywindow.close();

    return true;
	}

    
};

EVENTER.GENERATEQRCODE = function(qrInstance, qrContent, qrSize)
{
	qrInstance.qrcode({
			// render method: 'canvas', 'image' or 'div'
			render: 'image',
			// version range somewhere in 1 .. 40
			minVersion: 1,
			maxVersion: 40,
			// error correction level: 'L', 'M', 'Q' or 'H'
			ecLevel: 'L',
			// offset in pixel if drawn onto existing canvas
			left: 0,
			top: 0,
			// size in pixel
			size: qrSize,
			// code color or image element
			fill: '#000',
			// background color or image element, null for transparent background
			background: null,
			// content
			text: qrContent,
			// corner radius relative to module width: 0.0 .. 0.5
			radius: 0,
			// quiet zone in modules
			quiet: 0,
			// modes
			// 0: normal
			// 1: label strip
			// 2: label box
			// 3: image strip
			// 4: image box
			mode: 0,
			mSize: 0.1,
			mPosX: 0.5,
			mPosY: 0.5,
			label: 'no label',
			fontname: 'sans',
			fontcolor: '#000',
			image: null
		});
};
$('.eventer-temporary-tickets').hide();
EVENTER.GENERATETICKETSREGISTRANTS = function()
{
	if($('.eventer-temporary-tickets').length<=0) return;
	$('.eventer-temporary-tickets').show();
	var qrcode_data = [];
	var nonce_qrcode = $('#eventer-ticket-printable').attr('data-nonce');
	var organizer;
	var backorder = '';
	var ticket_img = null;
	var registrant = $('#eventer-ticket-printable').attr('data-registrant');
	var i = 0;
	var ticket_reverse = null;
	var ticket_front = null;
	var event_id = $('#eventer-ticket-printable').attr('data-eid');
	var registrant_span = [];
	var main_reg = $('#eventer-ticket-printable').attr('data-uemail');
	var reg_pos = $('#eventer-ticket-printable').attr('data-regpos');
	$('.eventer-registrant-show').each(function(){
		registrant_span.push($(this));
	});
	//if(registrant_span.length<=0) return false;
	function nextStep(){
		if(i >= registrant_span.length) return;
	//$('.eventer-registrant-show').each(function(){
		//sleep(2000);
		var qrcode_merged = {};
		var registrant_listing = registrant_span[i];
		if(i===0)
		{
			nonce_qrcode = registrant_listing.parent('.eventer-all-registrants').attr('data-nonce');
			organizer = registrant_listing.parent('.eventer-all-registrants').attr('data-organizer');
			event_id = registrant_listing.parent('.eventer-all-registrants').attr('data-eid');
			registrant = registrant_listing.parent('.eventer-all-registrants').attr('data-registrant');
			main_reg = registrant_listing.parent('.eventer-all-registrants').attr('data-mainreg');
			reg_pos = registrant_listing.parent('.eventer-all-registrants').attr('data-regpos');
			backorder = registrant_listing.parent('.eventer-all-registrants').attr('data-backorder');
			$('#eventer-ticket-printable').find('.eventer-qrcode').removeClass('eventer-on-ticket-qr');
			$('#eventer-ticket-printable').find('.eventer-qrcode').attr('data-qr-content', '');
		}
		
		var qrcode = registrant_listing.attr('data-qrcode');
		var reg_email = registrant_listing.attr('data-email');
		var reg_name = registrant_listing.attr('data-name');
		var reg_event_name = registrant_listing.attr('data-eventid');
		var reg_event_datetime = registrant_listing.attr('data-datetime');
		var reg_elocation = registrant_listing.attr('data-elocation');
		EVENTER.GENERATEQRCODE(registrant_listing, qrcode, 100);
		var qrcode_src = registrant_listing.find('img');
		var reg_ticket = registrant_listing.attr('data-ticket');
		$('#eventer-ticket-printable').find('h3').html('');
		$('#eventer-ticket-printable').find('.eventer-tickets-booked-info').remove();
		$('#eventer-ticket-printable').find('.eventer-ticket-reg-code').html('');
		
		$('#eventer-ticket-printable').find('.eventer-qrcode').html('');
		$('#eventer-ticket-printable').find('h3').html(reg_name);
		$('#eventer-ticket-printable').find('.registrant-ticket').html('<p>'+reg_ticket+'</p>');
		$('#eventer-ticket-printable').find('.eventer-woo-title').html(reg_event_name);
		$('#eventer-ticket-printable').find('.eventer-woo-datetime').html(reg_event_datetime);
		$('#eventer-ticket-printable').find('.eventer-woo-location').html(reg_elocation);
		$('#eventer-ticket-printable').find('.eventer-ticket-reg-code').html(qrcode);
		$('#eventer-ticket-printable').find('.eventer-qrcode').html(qrcode_src);
		html2canvas($('#eventer-ticket-printable'),
		{
         onrendered: function (canvas) {
         ticket_img = canvas.toDataURL("image/png",1.0);
			qrcode_merged.src = ticket_img;
			//registrant_listing.attr('data-img', ticket_img);
			nextStep();
			}
      });
		qrcode_merged.code = qrcode;
			qrcode_merged.email = reg_email;
			qrcode_merged.name = reg_name;
			//qrcode_merged.src = qrcode_src;
			qrcode_merged.ticket = reg_ticket;
			//qrcode_merged.src = registrant_listing.attr('data-img');
			qrcode_data.push(qrcode_merged);
		//sleep(50000);
		//return false; 
	//});
	i++;
	}
	html2canvas($('#eventer-ticket-printable'),
	{
      onrendered: function (canvas) {
      ticket_front = canvas.toDataURL("image/png",1.0);
		nextStep();
		}
   });
	

/*if ($(".eventer-back-print").length>0) {
html2canvas($('#eventer-ticket-reverse-printable'),
		{
         onrendered: function (canvas) {
         ticket_reverse = canvas.toDataURL("image/png",1.0);
			}
      });
}*/
$('<div class="eventer-loader-wrap eventer_custom_loader_tickets"><div class="eventer-loader"></div></div>').appendTo('body');
	setTimeout(
		function() {
	var request = $.ajax({
        url: initval.ajax_url,
        type: "post",
			dataType:'json',
			//async: false,
        data : {
				action : 'eventer_generate_ticket_qrcode',
				qrdata: qrcode_data,
				backorder: backorder,
				regpos: reg_pos,
				front: ticket_front,
				mainreg: main_reg,
				reverse: ticket_reverse,
				reg: registrant,
				eid: event_id,
				nonce: nonce_qrcode,
				organizer: organizer,
				//img: img
				},
				beforeSend: function( xhr ) {
					
  			},
    });
	request.done(function (response){
		$('form.eventer-show-download-tickets-form').find('.eventer-woo-tickets').val(response.tickets);
		$('.eventer-temporary-tickets').remove();
		$('.eventer_custom_loader_tickets').hide();
		if(typeof response.event_url!=='undefined' && response.event_url!=='')
		{
			window.location.href = response.event_url;
		}
		
	});
	request.fail(function (jqXHR, textStatus, errorThrown){ 
			$('.eventer-temporary-tickets').remove();
    });
	},
		1500);
};


if(initval.reg_now==="1")
{
	EVENTER.GENERATETICKETSREGISTRANTS();
}

$('.eventer-print-ticket').click(function(){
	EVENTER.EVENTERPRINTTICKET('eventer-ticket-show-now');
});




	//QR Code Generator
	$('.eventer-on-ticket-qr').each(function(){
		var qrInstance = $(this); 
		var qrContent = qrInstance.attr("data-qr-content") ? qrInstance.attr("data-qr-content") : "";
		var qrSize = qrInstance.attr("data-qr-size") ? qrInstance.attr("data-qr-size") : 100;
		EVENTER.GENERATEQRCODE(qrInstance, qrContent, qrSize);
	});
	
	
	// Eventer CountDown
	$('.eventer-countdown-timer').each(function(){
		var expiryDate = $(this).data('date');
		var countdown_id = $(this).attr('id');
		$('#'+countdown_id).countdown(expiryDate).on('update.countdown', function(event) {
	  $(this).html(event.strftime(''+ '<div class="eventer-timer-col"><div><div><span>%D</span> <strong>'+initval.day+'</strong></div></div></div>' + '<div class="eventer-timer-col"><div><div><span>%H</span> <strong>'+initval.hr+'</strong></div></div></div>' + '<div class="eventer-timer-col"><div><div><span>%M</span> <strong>'+initval.min+'</strong></div></div></div>' + '<div class="eventer-timer-col"><div><div><span>%S</span> <strong>'+initval.sec+'</strong></div></div></div>'));
		});
	});
	
	
	EVENTER.CHECKBOXVALIDATE = function(names, fields) 
	{
		var chkds = $("input[name='"+names+"']:"+fields);
		if(chkds.is(":checked"))  
		{
				return "1";  
		}
		else
		{
			return "0";
		}
	};
	
	EVENTER.VALIDATEEMAIL = function (emailField)
	{
  	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;

  	if (reg.test(emailField.val()) === false) 
    {
       return "0";
    }
		return "1";

	};
	
	EVENTER.APPENDQUERYURL = function(key, value, url) {
    if (!url) { url = window.location.href; }
    var re = new RegExp("([?&])" + key + "=.*?(&|#|$)(.*)", "gi"),
        hash;
    if (re.test(url)) {
        if (typeof value !== 'undefined' && value !== null) {
            return url.replace(re, '$1' + key + "=" + value + '$2$3'); }
        else {
            hash = url.split('#');
            url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '');
            if (typeof hash[1] !== 'undefined' && hash[1] !== null) {
                url += '#' + hash[1]; }
            return url;
        }
    }
    else {
        if (typeof value !== 'undefined' && value !== null) {
            var separator = url.indexOf('?') !== -1 ? '&' : '?';
            hash = url.split('#');
            url = hash[0] + separator + key + '=' + value;
            if (typeof hash[1] !== 'undefined' && hash[1] !== null) {
                url += '#' + hash[1]; }
            return url; 
        }
        else{ return url; }
            
    }
};
	EVENTER.EVENTERAJAXMONTHWISE = function(shortcode_attr, send_date, arrow_class, element, data_jump, target_url, filters, status)
	{
		shortcode_attr.eventerid = $('.keyword-search-eventer').attr('data-search');
		var date_range = $('.keyword-search-eventer').attr('data-range');
		var date_from = $('.keyword-search-eventer').attr('data-from');
		var date_to = $('.keyword-search-eventer').attr('data-to');
		var searchfrom = $('#eventer_from').val();
		var searchto = $('#eventer_to').val();
		var fromdate, todate;
		if(searchfrom!=='' && searchto!=='')
		{
			fromdate = searchfrom;
			todate = searchto;
			shortcode_attr.efrom = fromdate;
			shortcode_attr.eto = todate;
		}
		else if(date_range==="1" && $('.keyword-search-eventer').val()!=='')
		{
			fromdate = date_from;
			todate = date_to;
			shortcode_attr.efrom = fromdate;
			shortcode_attr.eto = todate;
		}
		
		var currmonth = $(element).find(".eventer-switcher-current-month-in");
		var prevarrow = $(element).find("a.prev-month");
		var nextarrow = $(element).find("a.next-month");
		var twelvemonths = $(element).find(".eventer-twelve-months");
		$(element).find(".eventer-loader-wrap").show();
    var request = $.ajax({
        url: initval.ajax_url,
        type: "post",
				dataType:'json',
        data : {
				action : 'eventer_month_wise_events',
				get_month : send_date,
				arrow: arrow_class,
				lang: initval.wpml_lang,
				datajump: data_jump,
				shortcode_attr: shortcode_attr,
				filters: filters,
				stat: status,
				nonce: initval.month_events_nonce,
				},
    });

    // Callback handler that will be called on success
    request.done(function (response, textStatus, jqXHR){
			if(response.next_result!==1)
			{
				nextarrow.hide();
			}
			else
			{
				nextarrow.show();
			}
			if(response.previous_result!==1)
			{
				prevarrow.hide();
			}
			else
			{
				prevarrow.show();
			}
			window.history.replaceState({href: target_url}, '', target_url);
			$('.today-btn').removeClass('show_month_events');
			$('.show_month_events').attr('data-arrow', send_date);
			$('.keyword-search-eventer').attr('data-arrow', send_date);
			$('.today-btn').addClass('show_month_events');
			var show_result = '';
			var monthsshow = '';
				currmonth.html(response.thismonth);
				if(response.thisyear!=='')
				{
					currmonth.append('<span>'+response.thisyear+'</span>');
				}
				prevarrow.attr('data-arrow', response.prevmonth);
				nextarrow.attr('data-arrow', response.nextmonth);
				if(response.noresult==1)
				{
					show_result += '<div class="noresult-msg">';
					show_result += '<p>'+response.blank+'</p>';
					if(response.tabs==='month')
					{
						show_result += '<p>'+response.halfyear+'</p>';
						show_result += '<p>'+response.fullyear+'</p>';
					}
					show_result += '</div>';
				}
				
        
			$.each(response['lidata'], function( key, value ) {
				var recurring_icon = '';
				var class_thumb = '';
				if(value.recurring_icon==="1")
				{
					recurring_icon = ' <i class="eventer-icon-refresh"></i>';
				}
				var $event_month = '<span class="eventer-event-month">'+value.mon+'</span>';
				var $event_year = '<span class="eventer-event-year">'+value.year+'</span>';
				var $event_title = value.title;
				var $event_time = '<span class="eventer-event-time">'+value.ticon+' '+value.time+'</span>';
				if(response.layout==="minimal")
				{
					show_result += '<li class="eventer-event-item eventer-event-list-item" '+value.borderleft+'>';
					show_result += '<a href="'+value.eventer_url+'" class="eventer-event-item-link">';

					show_result += '<span class="eventer-event-date">';
					show_result += '<span><span class="eventer-cell">';
					show_result += value.da;
					show_result += 	'<span class="eventer-dater">';
					show_result += $event_month;
					
					show_result += $event_year;
					show_result += $event_time;
					show_result += '</span></span></span></span>';

					show_result += '<span class="eventer-event-details">';
					show_result += $event_title;
					if(value.venue!=='')
					{
						show_result += '<span class="eventer-event-venue"> '+value.venue+'</span>';
					}
					show_result += '</span>';
					show_result += '</a></li>';
				}
				else
				{
					if(value.image_url)
					{
						class_thumb = 'eventer-event-list-item-wi';
					}
					show_result += '<li class="eventer-event-item eventer-event-list-item '+class_thumb+'">';
					show_result += '<a href="'+value.eventer_url+'" class="eventer-event-item-link">';
					show_result += '<span class="eventer-event-date" '+value.bordertop+'>';
					show_result += value.da;
					if(value.multidays==='')
					{
						show_result += '<span class="eventer-event-month">'+$event_month+'</span>';
					}
					show_result += '<span class="eventer-event-year">'+$event_year+'</span>';
					show_result += '</span>';
					show_result += '<span class="eventer-event-details">';
					if(value.image_url)
					{
						show_result += '<img class="eventer-event-image" src="'+value.image_url+'">';
					}
					show_result += '<span class="eventer-event-details-side">';
					show_result += $event_time;
					show_result += $event_title;
					if(value.venue!='')
					{
						show_result += '<span class="eventer-event-venue"><i class="eventer-icon-location-pin"  style="color:'+value.color+'"></i> '+value.venue+'</span>';
					}
					
					show_result += '</span>';
					show_result += '</span>';
					show_result += '<i class="eventer-icon-arrow-right"></i>';
					show_result += '</a></li>';
				}
				
			});
			$(element).find(".monthly-list").empty();
			$(element).find(".eventer-loader-wrap").hide();
			$(element).find(".monthly-list").html(show_result);	
			twelvemonths.empty();
			$.each(response['monthsgrid'], function(key, value)
			{
				monthsshow += '<li data-jump="0" data-arrow="'+value.lival+'" class="show_month_events next-month">'+value.lishow+'</li>';
			});
			twelvemonths.html(monthsshow);
			$(".eventer-filter-select").slideUp();
    });

    // Callback handler that will be called on failure
    request.fail(function (jqXHR, textStatus, errorThrown){
    });
	};
	EVENTER.VALIDATEFORMFIELDS = function(element)
	{
		
		var passing = "1";
		var required = element.attr("data-required");
			if(required==="1")
			{
				var field_type = element.prop("type");
				if(field_type==="text"||field_type==="textarea"||field_type==="email"||field_type==="number")
				{
					if(element.val()==='')
					{
						element.addClass("eventer-required-field");
						passing = "0";
					}
					else if(field_type==="email"&&EVENTER.VALIDATEEMAIL(element)==="0")
					{
						element.addClass("eventer-required-field");
						element.closest("form").find(".message").empty();
						element.closest("form").find(".message").append(element.attr("name")+' <p>'+initval.email_msg+'</p>');
						passing = "0";
					}
					else if(field_type==="number"&&!$.isNumeric(element.val()))
					{
						element.addClass("eventer-required-field");
						element.closest("form").find(".message").empty();
						element.closest("form").find(".message").append(element.attr("name")+' <p>'+initval.number_msg+'</p>');
						passing = "0";
					}
					else
					{
						element.removeClass("eventer-required-field");
						passing = "1";
					}
				}
				else if(field_type==="checkbox"||field_type==="radio")
				{
					var fname = element.attr("name");
					var result = EVENTER.CHECKBOXVALIDATE(fname, element.prop("type"));
					if(result==="1")
					{
						element.closest("label").removeClass("eventer-required-field");
						passing = "1";
					}
					else
					{
						element.closest("label").addClass("eventer-required-field");
						passing = "0";
					}
				}
				else
				{ 
					if(element.val()==='')
					{
						element.addClass("eventer-required-field");
						passing = "0";
					}
					else
					{
						element.removeClass("eventer-required-field");
						passing = "1";
					}
				}
			}
			return passing;
	};
	
	EVENTER.GETFILTERDATA = function()
	{
		var filters = {};
			$(".filter_eventers").each(function(){
				var taxonomy_atts = $(this).attr("data-taxonomy");
				var filter_ids = [];
				$(this).find(".activated").each(function(){
					var term = $(this).attr("data-term");
					filter_ids.push(term);
				});
				filters[taxonomy_atts] = filter_ids;
			});
		return filters;
	};
	
	$(document).delegate(".show_month_events", 'click', function(){
		var target_url = window.location.href;
		if($(this).hasClass('eventers-filter-check'))
		{
			
		}
		else
		{
			$('.eventer-filter-datewise').val('');
			target_url = EVENTER.APPENDQUERYURL('efrom', null, target_url);
			target_url = EVENTER.APPENDQUERYURL('eto', null, target_url);
		}
		var arrow_class = "0";
		var data_jump;
		
		var calview = $(this).attr('data-calview');
		var shortcode_attr = JSON.parse($(this).closest('.eventer-list').find('.shortcode-attrs').text());
		shortcode_attr.efrom = $('#eventer_from').val();
		shortcode_attr.eto = $('#eventer_to').val();
		if (typeof calview !== 'undefined' && calview !== null)
		{
			$('.shortcode-attrs').attr('data-status', calview);
			$('.list_calendar_view').removeClass('active');
			$('.list_calendar_view').addClass('show_month_events');
			$(this).addClass('active');
			$(this).removeClass('show_month_events');
			target_url = EVENTER.APPENDQUERYURL('calview', $('.shortcode-attrs').attr('data-status'), target_url);
		}
		var send_date = $(this).attr("data-arrow");
		if($(this).hasClass("next-month"))
		{
			arrow_class = "1";
		}
		target_url = EVENTER.APPENDQUERYURL('jump_date', send_date, target_url);
		data_jump = $(this).attr("data-jump");
		if($(this).attr("data-arrowclass")==="2")
		{
			arrow_class = "2";
			if($(this).is(':checked'))
			{
				$(this).addClass("activated");
				$(this).parents("ul").addClass("filter_eventers");
			}
			else
			{
				$(this).removeClass("activated");
				if($(this).parents("ul").find('.activated').length === 0)
				{
					$(this).parents("ul").removeClass("filter_eventers");
				}
			}
		}
		var status = $('.shortcode-attrs').attr("data-status");
		target_url = EVENTER.APPENDQUERYURL('terms_cats', null, target_url);
		target_url = EVENTER.APPENDQUERYURL('terms_tags', null, target_url);
		target_url = EVENTER.APPENDQUERYURL('terms_venue', null, target_url);
		target_url = EVENTER.APPENDQUERYURL('terms_organizer', null, target_url);
		var filter_data = EVENTER.GETFILTERDATA();
		$.each(filter_data, function(key, object) {
			target_url = EVENTER.APPENDQUERYURL(key, object, target_url);
		});
		EVENTER.EVENTERAJAXMONTHWISE(shortcode_attr, send_date, arrow_class, $(this).closest('div.eventer-list'), data_jump, target_url, filter_data, status);
	});
	
	$('input:radio[name="chosen-payment-option"]').change(
    function(){
        if (this.checked && this.value === '0') 
				{
					$("form#ticket-reg").attr('action', $("#paypal_return").text());
					$(".offline_message").show();
					$(".save-registrant").val(initval.proceed_register);
					$(".save-registrant").attr("data-payment", "");
					$('form.ticket-reg').find(".message").empty();
        }
				else
				{
					$("form#ticket-reg").attr('action', initval.paypal_site);
					$(".offline_message").hide();
					$(".save-registrant").val(initval.paypal_proceed);
					$(".save-registrant").attr("data-payment", "1");
					$('form.ticket-reg').find(".message").empty();
				}
    });
	
	
$(document).delegate('.eventer-permission-add-registrants', 'change', function(){
	if ($(this).is(':checked')) {
		$(this).closest('.eventer-registrants-row').find('.eventer-removable-field-bypermission').show();
	}
	else
	{
		$(this).closest('.eventer-registrants-row').find('.eventer-removable-field-bypermission').hide();
	}
});
	
$(document).delegate('.remove_from_cart_button', 'click', function(){
	var product = $(this).attr('data-product_id');
	$("input:checkbox[name='"+product+"']:checked").each(function(){
    $(this).trigger('change');
	});
	$("input:radio[name='"+product+"']:checked").each(function(){
    $(this).prop('checked',false);
	 $(this).trigger('change');
	});
});

	
	$(".num-tickets, .eventer-qtyminus, .eventer-qtyplus").bind('keyup mouseup', function () {
		var $crow = $(this).closest(".eventer-ticket-type-row");
		
		//$crow.append(registrant_fields);
		var remaining_tickets = $crow.find('.remaining-ticket').text();
		var set_remaining = (remaining_tickets>=10)?10:remaining_tickets;
		var price = $crow.find(".price-ticket").attr('data-tprice');
		var number = parseInt($crow.find(".num-tickets").val());
		var calculation;
		var have_ticket;
		if($(this).val()==='-' || $(this).val()==='+')
		{
			if (!isNaN(number) ) 
			{
				if($(this).val()==='-' && number > 0)
				{
					calculation = $crow.find('.num-tickets').val(number - 1);
				}
				else if($(this).val()==='+')
				{
					calculation = $crow.find('.num-tickets').val(number + 1);
					if($crow.find('.num-tickets').val()>set_remaining)
					{
						$crow.find('.num-tickets').val(set_remaining);
						//calculation = 10;
					}
				}
			} 
			else 
			{
				calculation = $crow.find('.num-tickets').val(0);
			}
		}
		var total_tickets = $crow.find(".num-tickets").val();
		if(total_tickets>set_remaining)
		{
			$crow.find(".num-tickets").val(set_remaining);
		}
		var new_total_tickets = $crow.find(".num-tickets").val();
		var registrants_fields_set = '';
		var registrants_boxes = $crow.find('.eventer-registrants-row').length;
		var registrants_boxes_ind = $crow.find('.eventer-registrants-row').find('.eventer-registrants-list').length;
		var registrant1_name = $('#reg_name').val();
		var registrant1_email = $('#reg_email').val();
		var checked_row_permission_field = 1;
		var eventer_allowed_registrants_details = 1;
		for (var i = registrants_boxes_ind; i < new_total_tickets; i++)
		{
			var registrant_fields = '';
			
			if($crow.find('.default-registrant').length<=0 && $('.default-registrant').length>0)
			{
				checked_row_permission_field = 0;
			}
			var permission_switch_added = $crow.find('.eventer-registrants-field-permission').length;
			var first_switch = 0;
			
			if(i===checked_row_permission_field)
			{
				first_switch = 1;
				registrant_fields += '<div class="eventer-col10 eventer-registrants-field-permission"><label class="eventer-checkbox"><input class="eventer-permission-add-registrants" checked type="checkbox"> '+initval.individual_label+'</label></div>';
			}
			var name_Series = (i+1);
			var registrants_field_class = (permission_switch_added>0 || first_switch!==0)?'eventer-removable-field-bypermission':'';
			registrant_fields += '<div class="eventer-registrants-list '+registrants_field_class+'"><div class="eventer-col5 eventer-col10-xs"><label>'+initval.registrant_label+' '+name_Series+'</label><input data-required="1" class="registrant-fields eventer_registrant_name" placeholder="'+initval.registrant_name+'" name="'+initval.registrant_name_label+i+'" type="text"></div><div class="eventer-col5 eventer-col10-xs"><label>&nbsp;</label><input data-required="1" class="registrant-fields eventer_registrant_email" placeholder="'+initval.registrant_email+'" name="'+initval.registrant_email_label+i+'" type="email"></div></div>';
			
			registrants_fields_set += registrant_fields;
		} 
		var has_checkbox = $crow.find('.eventer-permission-add-registrants').length;
      eventer_allowed_registrants_details = (has_checkbox>0)?$crow.find('.eventer-permission-add-registrants:checked').length:eventer_allowed_registrants_details;
      if(initval.individual_reg==='1')
      {
         if(registrants_boxes>0 && new_total_tickets>=registrants_boxes_ind)
         {
            $crow.find('.eventer-registrants-row').append(registrants_fields_set);
         }
         else if(registrants_boxes>0 && new_total_tickets<=registrants_boxes_ind && new_total_tickets!=='0')
         {
            var less_fields = (registrants_boxes_ind-new_total_tickets);
            $crow.find('.eventer-registrants-row > .eventer-registrants-list').slice(-less_fields).remove();
         }
         else
         {
            $crow.find('.eventer-registrants-row').remove();
            $crow.append('<div class="eventer-row eventer-registrants-row" data-ticket="'+$crow.find('.name-ticket').text()+'">'+registrants_fields_set+'</div>');
         }
         /*Starting Code to show hide registrant name & email field*/
         if(eventer_allowed_registrants_details!==1)
         {
            $crow.find('.eventer-registrants-row').find('.eventer-removable-field-bypermission').hide();
         }
         else
         {
            $crow.find('.eventer-registrants-row').find('.eventer-removable-field-bypermission').show();
         }
         /*Ending Code to show hide registrant name & email field*/
         var removable_rows = $crow.find('.eventer-removable-field-bypermission').length; 
			if(removable_rows<=0)
			{
				$crow.find('.eventer-registrants-field-permission').remove();
			}
			if($('.default-registrant').length===0)
			{
				$(".eventer-registrants-list:first").find('.eventer_registrant_name').addClass('default-registrant');
				$(".eventer-registrants-list:first").find('.eventer_registrant_name').val(registrant1_name);
				$(".eventer-registrants-list:first").find('.eventer_registrant_email').val(registrant1_email);
			}
			
		}
		
		
		
		number = parseInt($crow.find(".num-tickets").val());
		if(($.isNumeric(number)&&$.isNumeric(price))||number==='')
		{
			if(number==='')
			{
				number = 0;
			}
			var $ticket_counted_price = price*number;
			var set_price_individual = (initval.curr_position==="postfix")?$ticket_counted_price+initval.curr:initval.curr+$ticket_counted_price;
			$crow.find(".total-price").text(set_price_individual);
			$crow.find(".total-price").attr('data-mprice', $ticket_counted_price);
		}
		var total_price_ticket = 0;
		$(".total-price").each(function(){
			var $one_price = ($(this).attr("data-mprice")!=='')?$(this).attr("data-mprice"):0;
			total_price_ticket = total_price_ticket+parseInt($one_price);
		});
		var set_price = (initval.curr_position==="postfix")?total_price_ticket+initval.curr:initval.curr+total_price_ticket;
		$(".eventer-ticket-price-total").text(set_price);
		$(".eventer-ticket-price-total").attr('data-fprice', total_price_ticket);
		$(".num-tickets").each(function(){
			if($(this).val()!=='0')
			{
				have_ticket = 1;
			}
		});
		if(total_price_ticket>0)
		{
			$('.save-registrant').prop('disabled', false); 
			$('.add_services_btn').removeClass('disableClick'); 
			$("form#ticket-reg").attr('action', initval.paypal_site);
			$(".payment-options-area").show();
			$(".offline_message").hide();
			$(".save-registrant").val(initval.paypal_proceed);
			$(".save-registrant").attr("data-payment", "1");
			$('form.ticket-reg').find(".message").empty();
			if(initval.offline_switch!=="1" && initval.woo_payment_switch!=='on')
			{
				$(".chosen-payment-option").prop("checked", true);
			}
			else
			{
				$("input[name=chosen-payment-option][value='0']").prop("checked",true);
				$(".offline_message").show();
				$(".save-registrant").val(initval.proceed_register);
				$(".save-registrant").attr("data-payment", "");
				$('form.ticket-reg').find(".message").empty();
				$("form#ticket-reg").attr('action', $("#paypal_return").text());
			}
		}
		else if(have_ticket===1)
		{ 
			$('.save-registrant').prop('disabled', false);
			$('.add_services_btn').removeClass('disableClick'); 
			$("form#ticket-reg").attr('action', $("#paypal_return").text());
			$(".payment-options-area").hide();
			$(".offline_message").hide();
			$(".save-registrant").val(initval.proceed_register);
			$(".save-registrant").attr("data-payment", "");
			$('form.ticket-reg').find(".message").empty();
		}
		else
		{ 
			$('.save-registrant').prop('disabled', true); 
			$('.add_services_btn').addClass('disableClick'); 
			$("form#ticket-reg").attr('action', $("#paypal_return").text());
			$(".payment-options-area").hide();
			$(".offline_message").show();
			$(".save-registrant").val(initval.proceed_register);
			$(".save-registrant").attr("data-payment", "");
			$('form.ticket-reg').find(".message").empty();
		}
	});
	
	$('.add_services_btn').click(function(){
		if ($(".restrict-service").length && !$('.restrict-service-field').is(':checked'))
		{
			$('.save-registrant').prop('disabled', true); 
		}
	});
	//Code for additional services select field
	//Start
	$(".add_services").on('change', function () {
		var have_ticket;
		$(".num-tickets").each(function(){
			if($(this).val()!=='0')
			{
				have_ticket = 1;
			}
		});
		var $crow = $(this).closest(".eventer-ticket-type-row");
		var clist = $(this).closest("li");
		var price = clist.attr('data-tprice');
		var total_price_services = 0;
		var check_status;
		var total_price_ticket = 0;
		if ($(this).is(':radio')) {
    	$crow.find(".price-ticket").attr('data-mprice', 0);
    }
		if($(this).is(':checked'))
		{
			clist.attr('data-mprice', price);
			check_status = "1";
		}
		else
		{
			clist.attr('data-mprice', 0);
			check_status = "0";
		}
		if ($(".restrict-service").length && !$('.restrict-service-field').is(':checked'))
		{
			check_status = "2";
		}
		else
		{
			check_status = "1";
		}
		$crow.find(".price-ticket").each(function(){
			var service_price = ($(this).attr("data-mprice")!=='')?$(this).attr("data-mprice"):0;
			total_price_services = total_price_services+parseInt(service_price);
		});
		var set_price_individual_service = (initval.curr_position==="postfix")?total_price_services+initval.curr:initval.curr+total_price_services;
		$crow.find(".total-price").text(set_price_individual_service);
		$crow.find(".total-price").attr('data-mprice', total_price_services);
		$(".total-price").each(function(){
			var $one_price = ($(this).attr("data-mprice")!=='')?$(this).attr("data-mprice"):0;
			total_price_ticket = total_price_ticket+parseInt($one_price);
		}); 
		var set_price = (initval.curr_position==="postfix")?total_price_ticket+initval.curr:initval.curr+total_price_ticket;
		$(".eventer-ticket-price-total").text(set_price);
		$(".eventer-ticket-price-total").attr('data-fprice', total_price_ticket);
		$(".payment-options-area").hide();
		if(total_price_ticket>0)
		{
			$('.save-registrant').prop('disabled', false); 
			$('.add_services_btn').removeClass('disableClick');
			if(check_status==="2")
			{
				$('.save-registrant').prop('disabled', true); 
				$('.add_services_btn').removeClass('disableClick'); 
			}
			$("form#ticket-reg").attr('action', initval.paypal_site);
				$(".payment-options-area").show();
				$(".offline_message").hide();
				$(".save-registrant").val(initval.paypal_proceed);
				$(".save-registrant").attr("data-payment", "1");
				$('form.ticket-reg').find(".message").empty();
				if(initval.offline_switch!=="1" && initval.woo_payment_switch!=='on')
				{
					$(".chosen-payment-option").prop("checked", true);
				}
				else
				{
					$("input[name=chosen-payment-option][value='0']").prop("checked",true);
					$(".offline_message").show();
					$(".save-registrant").val(initval.proceed_register);
					$(".save-registrant").attr("data-payment", "");
					$('form.ticket-reg').find(".message").empty();
					$("form#ticket-reg").attr('action', $("#paypal_return").text());
				}
		}
		else if(have_ticket===1 && check_status!=="2")
		{
			$('.save-registrant').prop('disabled', false);
			$('.add_services_btn').removeClass('disableClick'); 
		}
		else
		{
			$('.save-registrant').prop('disabled', true); 
			$('.add_services_btn').removeClass('disableClick'); 
		}
	});
	//End
	
	$('.eventer-woo-checkout-process-form').on('submit', function(e){
		var woo_validation = '';
		var validated = "1";
		$(this).find('.eventer-woo-checkout-form, .woocommerce-form__input').each(function(){
			$(this).attr('data-required', "1");
			woo_validation = EVENTER.VALIDATEFORMFIELDS($(this));
			if(woo_validation!=="1")
			{
				validated = "0";
			}
			else
			{
				validated = "1";
			}
		});
		if(validated!=='1')
		{
			e.preventDefault();
			return false;
		}
	});
	
	$('form.ticket-reg').on('submit', function (e) {
		var booking_type = $(this).attr('data-booking');
		var booking_nonce = $(this).attr('data-nonce');
		$('.eventer-removable-field-bypermission').each(function(){
			if($(this).css('visibility') == 'hidden' || $(this).css('display') == 'none'){
				$(this).remove();
			}
		});
		if($(this).hasClass("eventer-direct-register"))
		{
			var validated = "1";
		$('form.ticket-reg *').filter(':input').each(function(){
			var passing = EVENTER.VALIDATEFORMFIELDS($(this));
			if(passing!=="1")
			{
				validated = "0";
			}
		});
		if(validated!=="1")
		{
			return false;
		}
		}
		var form_element = $(this);
		var total_price_ticket = $(".eventer-ticket-price-total").attr('data-fprice');
		var $all_fields = $(this).find(':input').not('.registrant-fields').serializeArray();
		var all_registrants_list = {};
		$('.eventer-registrants-row').each(function(){
			var ticket_name_reg = $(this).attr('data-ticket');
			var registrants_list = [];
			$(this).find('.eventer-registrants-list').each(function(){
				var registrants_field_list = {};
				var registrant_name = $(this).find('.eventer_registrant_name').val();
				var registrant_email = $(this).find('.eventer_registrant_email').val();
				if(registrant_name==='') return true;
				registrants_field_list.name = registrant_name;
				registrants_field_list.email = registrant_email;
				registrants_list.push(registrants_field_list);
			});
			all_registrants_list[ticket_name_reg] = registrants_list;
		});
		
		var registration;
		var Tickets = [];
		var Ticket_Validation = [];
		var service = [];
		$('.services-section').each(function(){
			var pid = $(this).closest('.eventer-ticket-type-row').attr('data-pid');
			var cost = $(this).closest('.eventer-ticket-type-row').find('.total-price').attr('data-mprice');
			var services = {};
			var service_vals = '';
			services.name = $(this).closest('.eventer-ticket-type-row').find('.name-ticket').text();
			$(this).find('.add_services').each(function(){
				if($(this).is(':checked'))
				{
					service_vals += $(this).val()+', ';
				}
			});
			services.value = service_vals;
			services.pid = pid;
			services.cost = cost;
			service.push(services);
		});
		$(".num-tickets").each(function(){
			
				var $crow = $(this).closest(".eventer-ticket-type-row");
				var data = {};
				var ticket_price = '0';
				var ticket_name_new = $crow.find(".name-ticket").text();
				if($(this).val()!=='')
				{
					ticket_price = $crow.find(".price-ticket").attr('data-tprice');
					Ticket_Validation.push(data);
				}
				if(ticket_name_new!=='')
				{
					data.name = $crow.find(".name-ticket").text();
					data.number = $crow.find(".num-tickets").val();
					data.pid = $crow.find('.eventer-row').attr('data-pid');
					data.price = ticket_price;
					Tickets.push(data);
				}
				
		});
		if(Ticket_Validation.length === 0) 
		{
			$('form.ticket-reg').find(".message").empty();
			$('form.ticket-reg').find(".message").html(initval.blank_tickets);
			e.preventDefault();
			return false;
		}
		else if($('input:radio:checked').length <= 0 && total_price_ticket>0 && booking_type!='woo')
		{
			$('form.ticket-reg').find(".message").empty();
			$('form.ticket-reg').find(".message").html(initval.blank_payment);
			e.preventDefault();
			return false;
		}
		else
		{
			$('form.ticket-reg').find(".message").empty();
			if(initval.offline_switch!=="1")
			{
				$(".chosen-payment-option").prop("checked", true);
			}
		}
		var paypal_arguments = '';
		if($("form#ticket-reg").attr("action").indexOf("paypal") > -1)
		{
			paypal_arguments = '<input type="hidden" name="business" value="'+initval.paypal_email+'">';
			paypal_arguments +=	'<input type="hidden" name="cmd" value="_xclick">';
			paypal_arguments +=	'<input type="hidden" name="on0" value="">';
			paypal_arguments +=	'<input type="hidden" name="on1" value="'+$("#reg_email").val()+'">';
			paypal_arguments +=	'<input type="hidden" name="item_name" value="'+$("#paypal_itemname").text()+'">';
			paypal_arguments +=	'<input type="hidden" name="item_number" value="'+$("#eventer_id").text()+'">';
			paypal_arguments +=	'<input type="hidden" name="amount" value="'+$(".eventer-ticket-price-total").attr('data-fprice')+'">';
			paypal_arguments +=	'<input type="hidden" name="currency_code" value="'+initval.paypal_curr+'">';
			paypal_arguments +=	'<input type="hidden" name="cancel_return" value="'+$("#paypal_return").text()+'">';
			paypal_arguments +=	'<input type="hidden" name="return" value="'+$("#paypal_return").text()+'">';
			$(".save-registrant").before(paypal_arguments);
		}
		else
		{
			//$(this).find("input:hidden").remove();
		}
		if ($('#register-reg').is(":checked"))
		{
			registration = 1;
		}
		var amount = parseInt($(".eventer-ticket-price-total").attr('data-fprice'));
		var request = $.ajax({
        url: initval.ajax_url,
        type: "post",
		//dataType:'json',
			async: false,
        data : {
				action : 'eventer_registrant_tickets',
				reg_data: $all_fields,
				eventer_id: $("#eventer_id").text(),
				amount: amount,
				reg_mail: $("#reg_email").val(),
				reg_name: $("#reg_name").val(),
				reg_event_date: $("#reg_event_date").text(),
				tickets: Tickets,
				registration: registration,
				services: service,
				registrants: all_registrants_list,
				book_type: booking_type,
				//nonce: booking_nonce,
				},
				beforeSend: function( jqXhr ) {
					jqXhr.setRequestHeader('X-WP-Nonce', booking_nonce);
					form_element.find("input[type=submit]").prop('disabled', true); 
					form_element.find('.eventer-loader-wrap').show();
  			},
    });
		request.done(function (response){
			if(response)
			{
				var form_action = $("form.ticket-reg").attr("action");
				if(form_action.indexOf("paypal") <= -1) 
				{
					var newformaction = EVENTER.APPENDQUERYURL('reg', response, form_action);
					form_action = newformaction;
					$("form.ticket-reg").attr("action", form_action);
					
				}
				var paypal_return = $("#paypal_return").text();
				var new_paypal_return = EVENTER.APPENDQUERYURL('reg', response, paypal_return);
				$("input[name=return]").val(new_paypal_return);
				$("input[name=on0]").val(response);
			}
			form_element.find("input[type=submit]").prop('disabled', false); 
			form_element.find('.eventer-loader-wrap').hide();
			if(booking_type==='woo')
			{
				$('.eventer_dynamic_checkout_payment').remove();
				//$( document.body ).trigger( 'wc_fragment_refresh' );
				form_element.closest('#eventer-ticket-form').find('.eventer-order-summary-added').remove();
				$('<div class="eventer-order-summary-added widget woocommerce widget_shopping_cart">'+response+'</div>').insertBefore(form_element.closest('#eventer-ticket-form').find('.eventer-woo-checkout-section'));
				$('form.ticket-reg').find(".message").empty();
				$('form.ticket-reg').find(".message").html(initval.tickets_added);
				$(".eventer-show-order-summary").trigger("click");
				$('form.ticket-reg').find(".message").empty();
				
				var payment_options = form_element.closest('#eventer-ticket-form').find('.eventer_dynamic_checkout_payment');
				form_element.closest('#eventer-ticket-form').find('.eventer_checkout_payment_options').empty();
				form_element.closest('#eventer-ticket-form').find('.eventer_checkout_payment_options').html(payment_options);
				//form_element.find('.eventer-show-order-summary').show();
				form_element.find('.eventer_dynamic_checkout_payment').show();
				e.preventDefault();
				return false;
			}
		});
		request.fail(function (jqXHR, textStatus, errorThrown){ 
			alert(errorThrown);
    });
	});
	$(".validate-registrant").click(function(e){
		e.preventDefault();
		var validated = "1";
		$('form.ticket-reg *').filter(':input').each(function(){
			var passing = EVENTER.VALIDATEFORMFIELDS($(this));
			if(passing!=="1")
			{
				validated = "0";
			}
		});
		if(validated!=="1")
		{
			return false;
		}
		$('.restricted-row').each(function(){
			var ticket_cookie = $(this).attr('data-booked');
			if(ticket_cookie!=="")
			{
				$(this).find('.num-tickets').prop('disabled', true);
				$(this).find('.eventer-qtyplus').prop('disabled', true);
				$(this).find('.eventer-qtyminus').prop('disabled', true);
				$(this).find('.eventer-restricted-msg').show();
			}
			else
			{
				$(this).find('.num-tickets').prop('disabled', false);
				$(this).find('.eventer-qtyplus').prop('disabled', false);
				$(this).find('.eventer-qtyminus').prop('disabled', false);
				$(this).find('.eventer-restricted-msg').hide();
			}
		});
		$("#fname").removeClass("eventer-input-error");
		$("#reg_email").removeClass("eventer-input-error");
		$('form.ticket-reg').find(".message").empty();
		var targetIn = $(this).attr('data-eventer-toggle-in');
		var targetOut = $(this).attr('data-eventer-toggle-out');
		$(this).parents('.eventer-toggle-area').find(targetOut).slideUp('fast');
		$(this).parents('.eventer-toggle-area').find(targetIn).slideDown('slow');
	});
	
	$("form.organizer-contact").on("submit", function(e){
		var form_element = $(this);
		var validated = "1";
		$(this).closest("form").find(".message").empty();
		var all_fields = $(this).serializeArray();
		var eventer_id = $(".organizer-details").text();
		var eventer_date = $(".eventer-date").text();
		$('form.organizer-contact *').filter(':input').each(function(){
			var passing = EVENTER.VALIDATEFORMFIELDS($(this));
			if(passing!=="1")
			{
				validated = "0";
			}
		});
		if(validated!=="1")
		{
			return false;
		}
			
		var request = $.ajax({
        url: initval.ajax_url,
        type: "post",
				//dataType:'json',
				async: false,
        data : {
				action : 'eventer_contact_organizer',
				org_data: all_fields,
				eventer_id: eventer_id,
				eventer_date: eventer_date,
				nonce: initval.organizer_contact,
				},
				beforeSend: function( xhr ) {
    			form_element.find("input[type=submit]").prop('disabled', true); 
  			},
    });
		request.done(function (response){
			form_element.find("input[type=submit]").prop('disabled', false); 
			form_element.find(".message").html(initval.contact_manager_text);
			$('#eventer-contact-form').slideUp(1500);
		});
		request.fail(function (jqXHR, textStatus, errorThrown){ 
			alert(errorThrown);
    });
		e.preventDefault();
	});
	
});