<?php
/**
 * Custom Walker
 * Copyright imithemes 2018-19 - www.imithemes.com
 * @access      public
 * @since       1.0 
 * @return      void
 */
class imi_mega_menu_walker extends Walker_Nav_Menu {
    function start_el(&$output, $item, $depth = 0, $args = array(), $current_object_id = 0) {
        $indent = ( $depth ) ? str_repeat("\t", $depth) : '';
        $class_names = $value = '';
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item));
        $menu_is_mega = get_post_meta($item->ID, '_menu_is_mega', true);
        if ($menu_is_mega == 1) {
            $mega_class = 'megamenu menu-item-has-children';
        } else {
            $mega_class = '';
        }
        $class_names = ' class="menu-item-' . $item->ID . ' ' . esc_attr($class_names) . ' ' . $mega_class . '"';
        $prepend = '';
        $append = '<span class="nav-line"></span>';
        $description = !empty($item->description) ? '<span>' . esc_attr($item->description) . '</span>' : '';
        if ($depth != 0) {
            $description = $append = $prepend = "";
        }
        $output .= $indent . '<li ' . $value . $class_names . '>';
        $item_output = '';
		$attributes = !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
		$attributes .=!empty($item->target) ? ' target="' . esc_attr($item->target) . '"' : '';
		$attributes .=!empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) . '"' : '';
		$attributes .=!empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
        $attributes .= ' data-id="'. esc_attr( $item->object_id        ) .'"';
        $attributes .= ' data-slug="'. esc_attr(  basename(get_permalink($item->object_id )) ) .'"';
        $attributes .= ' data-home-url=""';
		$item_output .= $args->before;
		$item_output .= '<a' . $attributes . '>';
		$item_output .= $args->link_before . $prepend . apply_filters('the_title', $item->title, $item->ID) . $append;
		$item_output .= $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;
        //Menu Is Mega
        if ($menu_is_mega == 1) {
			$menu_vcsections = get_post_meta($item->ID, '_menu_vcsections', true);
            if($menu_vcsections!='')
			{
				$data_vc_section = get_post( $menu_vcsections );
				$item_output .= '<style type="text/css" scoped>';
				$item_output .= get_post_meta( $menu_vcsections, '_wpb_shortcodes_custom_css', true );
				$item_output .= '</style>';
				$item_output .= '<div class="imi-mm-vc">'.apply_filters( 'the_content', $data_vc_section->post_content ).'</div>';
			}
        }
        
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
function end_el(&$output, $item, $depth = 0, $args = array()){ if($item->object=='question' ) : $output .= "</li>\n"; endif; }
}
?>