<?php
//Register scripts and styles for admin pages
function imi_startup_styles() {
	wp_enqueue_style( 'imi-startup_css', get_template_directory_uri() . '/admin/assets/css/style.css', null, BLOKCO_THEME_VERSION, 'all' );
}
add_action( 'admin_enqueue_scripts', 'imi_startup_styles' );

//Register Startup page in admin menu
function imi_register_startup_screen() {
	$theme = imi_get_theme_info();
	$theme_name = $theme['name'];
	$theme_name_sanitized = 'imi-admin';

	// Work around for theme check.
	$imi_admin_menu_page_creation_method    = 'add_menu_page';
	$imi_admin_submenu_page_creation_method = 'add_submenu_page';


	if ( !defined('ENVATO_HOSTED_SITE') ) {
		/*Item Registration*/
		$imi_admin_menu_page_creation_method(
			$theme_name,
			$theme_name,
			'manage_options',
			$theme_name_sanitized,
			'imi_theme_admin_page_functions',
			get_template_directory_uri() . '/admin/assets/images/icon.png',
			'2.1111111111'
		);

		/*Support page*/
		$imi_admin_submenu_page_creation_method(
			$theme_name_sanitized,
			esc_html__('Support', 'blokco'),
			esc_html__('Support', 'blokco'),
			'manage_options',
			$theme_name_sanitized . '-support',
			'imi_theme_admin_support_page'
		);

		/*System status*/
		$imi_admin_submenu_page_creation_method(
			$theme_name_sanitized,
			esc_html__('System status', 'blokco'),
			esc_html__('System status', 'blokco'),
			'manage_options',
			$theme_name_sanitized . '-system-status',
			'imi_theme_admin_system_status_page'
		);
	}

	/*Plugins*/
	$imi_admin_submenu_page_creation_method(
		$theme_name_sanitized,
		esc_html__('Plugins', 'blokco'),
		esc_html__('Plugins', 'blokco'),
		'manage_options',
		$theme_name_sanitized . '-plugins',
		'imi_theme_admin_plugins_page'
	);

}
add_action( 'admin_menu', 'imi_register_startup_screen' );

function imi_startup_templates($path) {
	$path = 'admin/screens/' . $path . '.php';

	$located = locate_template($path);

	if($located) {
		load_template($located);
	}
}

//Startup screen menu page welcome
function imi_theme_admin_page_functions() {
	imi_startup_templates('startup');
}

/*Support Screen*/
function imi_theme_admin_support_page() {
	imi_startup_templates('support');
}

/*Install Plugins*/
function imi_theme_admin_plugins_page() {
	imi_startup_templates('plugins');
}

/*System status*/
function imi_theme_admin_system_status_page() {
	imi_startup_templates('system_status');
}

//Admin tabs
function imi_get_admin_tabs($screen='welcome') {
	$theme = imi_get_theme_info();
	$theme_name = $theme['name'];
	$theme_name_sanitized = 'imi-admin';
	$creds = imi_get_creds();
	if(empty($screen)) {
		$screen = $theme_name_sanitized;
	}
	?>
	<div class="clearfix">
        <div class="imi-about-text-wrap">
            <h1><?php printf(esc_html__('Welcome to %s', 'blokco'), $theme_name); ?><span class="imi_theme_version"><?php echo substr($theme['v'], 0, 3); ?></span></h1>
        </div>
	</div>
	<?php $notice = get_site_transient('imi_auth_notice');
	if( !empty($creds['t']) && !empty($notice) ): ?>
		<div class="imi-admin-message"><strong>Theme Registration Error:</strong> <?php echo $notice; ?></div><br>
	<?php endif; ?>
	<div class="nav-tab-wrapper">
	    <?php if ( !defined('ENVATO_HOSTED_SITE') ): ?>
            <a href="<?php echo ( 'welcome' === $screen ) ? '#' : esc_url_raw( admin_url( 'admin.php?page=' . $theme_name_sanitized ) ); ?>" class="<?php echo ( 'welcome' === $screen ) ? 'nav-tab-active' : ''; ?> nav-tab"><?php esc_attr_e( 'Registration', 'blokco' ); ?></a>
            <a href="<?php echo ( 'support' === $screen ) ? '#' : esc_url_raw( admin_url( 'admin.php?page=' . $theme_name_sanitized . '-support' ) ); ?>" class="<?php echo ( 'support' === $screen ) ? 'nav-tab-active' : ''; ?> nav-tab"><?php esc_attr_e( 'Support', 'blokco' ); ?></a>
            <a href="<?php echo ( 'plugins' === $screen ) ? '#' : esc_url_raw( admin_url( 'admin.php?page=' . $theme_name_sanitized . '-plugins' ) ); ?>" class="<?php echo ( 'plugins' === $screen ) ? 'nav-tab-active' : ''; ?> nav-tab"><?php esc_attr_e( 'Plugins', 'blokco' ); ?></a>
			<?php if(is_plugin_active('redux-framework/redux-framework.php')){ ?>
            	<a href="<?php echo esc_url_raw(admin_url('admin.php')); ?>?page=_options&tab=29" class="nav-tab"><?php esc_attr_e('Import Demo', 'blokco'); ?></a>
            	<a href="<?php echo esc_url_raw(admin_url('admin.php')); ?>?page=_options" class="nav-tab"><?php esc_attr_e('Theme Options', 'blokco'); ?></a>
			<?php } ?>
            <a href="<?php echo ( 'system-status' === $screen ) ? '#' : esc_url_raw( admin_url( 'admin.php?page=' . $theme_name_sanitized . '-system-status' ) ); ?>" class="<?php echo ( 'system-status' === $screen ) ? 'nav-tab-active' : ''; ?> nav-tab"><?php esc_attr_e( 'System Status', 'blokco' ); ?></a>
        <?php else: ?>
            <a href="<?php echo ( 'plugins' === $screen ) ? '#' : esc_url_raw( admin_url( 'admin.php?page=' . $theme_name_sanitized . '-plugins' ) ); ?>" class="<?php echo ( 'plugins' === $screen ) ? 'nav-tab-active' : ''; ?> nav-tab"><?php esc_attr_e( 'Plugins', 'blokco' ); ?></a>
			<?php if(is_plugin_active('redux-framework/redux-framework.php')){ ?>
            	<a href="<?php echo esc_url_raw(admin_url('admin.php')); ?>?page=_options&tab=29" class="nav-tab"><?php esc_attr_e('Import Demo', 'blokco'); ?></a>
            	<a href="<?php echo esc_url_raw(admin_url('admin.php')); ?>?page=_options" class="nav-tab"><?php esc_attr_e('Theme Options', 'blokco'); ?></a>
			<?php } ?>
        <?php endif; ?>
    </div>
<div class="clearfix"></div>
	<?php
}