<?php
/*Redirect to theme Welcome screen*/
global $pagenow;

if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) && !defined('ENVATO_HOSTED_SITE') ) {
	wp_redirect(admin_url("admin.php?page=imi-admin"));
}

/*Theme info*/
function imi_get_theme_info() {
	$theme = wp_get_theme();
	$theme_name = $theme->get('Name');
	$theme_v = $theme->get('Version');

	$theme_info = array(
		'name' => $theme_name,
		'slug' => sanitize_file_name(strtolower($theme_name)),
		'v'    => $theme_v,
	);

	return $theme_info;
}

function imi_get_creds() {

	/*If envato hosted*/
	if ( !defined('ENVATO_HOSTED_SITE') && !defined('SUBSCRIPTION_CODE') ){
		$t = get_option('envato_market', array());
		if( !empty($t['token']) ) {
			$creds['t'] = $t['token'];
		}else{
			$creds['t'] = '';
		}
		$creds['host'] = false;
	}else{
		$creds['t'] = SUBSCRIPTION_CODE;
		$creds['host'] = true;
	}

	return $creds;
}


function imi_set_creds() {
	if(isset($_POST['imi_registration'])) {
		if(isset($_POST['imi_registration']['token'])) {
			delete_site_transient('imi_theme_auth');

			$token = array();
			$token['token'] = sanitize_text_field($_POST['imi_registration']['token']);

			update_option('envato_market', $token);

				$envato_market = Envato_Market::instance();
				$envato_market->items()->set_themes(true);
		}
	}
}

add_action('init', 'imi_set_creds');

function imi_convert_memory($size) {
	$l   = substr( $size, -1 );
	$ret = substr( $size, 0, -1 );
	switch ( strtoupper( $l ) ) {
		case 'P':
			$ret *= 1024;
		case 'T':
			$ret *= 1024;
		case 'G':
			$ret *= 1024;
		case 'M':
			$ret *= 1024;
		case 'K':
			$ret *= 1024;
	}
	return $ret;
}

function imi_theme_support_url() {
	return 'https://support.imithemes.com/';
}
function imi_theme_doc_url() {
	return 'https://docs.imithemes.com/doc/';
}

function imi_get_admin_images_url($image) {
	return esc_url(get_template_directory_uri() . '/admin/assets/images/' . $image);
}