<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

$theme = imi_get_theme_info();
$theme_name = $theme['name'];
?>
<div class="wrap about-wrap imi-admin-wrap  imi-admin-support-screen">
	<?php imi_get_admin_tabs('support'); ?>
	<div class="imi-admin-important-notice">

		<p class="about-description"><?php printf(__( '%s comes with 6 months of free support for every license you purchase. Support can be extended through subscriptions via ThemeForest.', 'cryptorian' ), $theme_name); ?></p>
		<p>
			<?php _e( 'Please have your purchase code handy when you register at our support forum.' ); ?> <a href="https://d.pr/i/ELQ7Zj" target="_blank"><?php _e('Here\'s how to find your Item Purchase Code.', 'cryptorian' ); ?></a>
		</p>
		<p><a href="<?php echo imi_theme_support_url() . 'wp-login.php?action=register'; ?>" class="button button-large button-primary imi-admin-button imi-admin-button-large" target="_blank" rel="noopener noreferrer"><?php esc_attr_e( 'Create A Support Account', 'cryptorian' ); ?></a></p>
	</div>

	<div class="imi-admin-row">
		<div class="imi-admin-one-third">
			<h3>
				<span class="dashicons dashicons-tickets-alt"></span>
				<?php _e( 'Ticket System', 'cryptorian' ); ?>
			</h3>
			<p>
				<?php _e( 'We offer support through our dedicated support forum where you can get help from the theme developers directly along with other users of the same theme.', 'cryptorian' ); ?>
			</p>
			<a href="<?php echo imi_theme_support_url() . 'forums/forum/wordpress-themes/blokco-wp/#add-new-post'; ?>" target="_blank">
				<?php esc_html_e( 'Create a ticket', 'cryptorian' ); ?>
			</a>
		</div>
		<!--<div class="imi-admin-one-third">
			<h3>
				<span class="dashicons dashicons-book-alt"></span>
				<?php _e( 'Documentation', 'cryptorian' ); ?>
			</h3>
			<p>
				<?php printf(__( 'Our online documentaiton is a useful resource for learning the every aspect and features of %s.', 'cryptorian' ), $theme_name); ?>
			</p>
			<a href="<?php echo imi_theme_doc_url() . 'cryptorian/'; ?>" target="_blank">
				<?php esc_html_e( 'Learn more', 'cryptorian' ); ?>
			</a>
		</div>
		<div class="imi-admin-one-third">
			<h3>
				<span class="dashicons dashicons-video-alt2"></span>
				<?php _e( 'Video Tutorials', 'cryptorian' ); ?>
			</h3>
			<p>
				<?php printf(__( 'Learn the basics through online video tutorials including "Installing a theme", "Updating theme" and many more..', 'cryptorian' ), $theme_name); ?>
			</p>
			<a href="https://www.youtube.com/" target="_blank">
				<?php esc_html_e( 'See videos', 'cryptorian' ); ?>
			</a>
		</div>-->
	</div>

</div>