<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
	load_theme_textdomain('blokco', BLOKCO_FILEPATH . '/language');
    // This is your option name where all the Redux data is stored.
    $opt_name = "blokco_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'blokco' ),
        'page_title'           => esc_html__( 'Theme Options', 'blokco' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 57,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/imithemes',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/imithemes',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
    } else {
    }

    Redux::setArgs( $opt_name, $args );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'blokco' );
    Redux::setHelpSidebar( $opt_name, $content );

	load_theme_textdomain('blokco', BLOKCO_FILEPATH . '/language');
	$defaultAdminLogo = get_template_directory_uri().'/assets/images/logo-admin.png';
	$default_logo = get_template_directory_uri() . '/assets/images/logo-white.png';
	$default_retina_logo = get_template_directory_uri() . '/assets/images/logo-white@2x.png';
	
    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-cogs',
    'icon_class' => 'icon-large',
    'title' => esc_html__('General', 'blokco'),
    'fields' => array(
        array(
            'id' => 'enable_maintenance',
            'type' => 'switch',
            'title' => esc_html__('Enable Maintenance', 'blokco'),
            'subtitle' => esc_html__('Enable the themes in maintenance mode.', 'blokco'),
            "default" => false,
            'on' => esc_html__('Enabled', 'blokco'),
            'off' => esc_html__('Disabled', 'blokco'),
        ),
        array(
            'id' => 'enable_backtotop',
            'type' => 'switch',
            'title' => esc_html__('Enable Back To Top', 'blokco'),
            'subtitle' => esc_html__('Enable the back to top button that appears in the bottom right corner of the screen.', 'blokco'),
            "default" => 1,
        ),
        array(
            'id' => 'enable_preloader',
            'type' => 'switch',
            'title' => esc_html__('Enable website preloader', 'blokco'),
            'subtitle' => esc_html__('Enable pre loader screen for the website. Show an animation before the page loads completely.', 'blokco'),
            "default" => 1,
        ),
		array(
			'id'=>'preloader_style',
			'type' => 'select',
			'compiler'=>true,
			'title' => esc_html__('Preloader style', 'blokco'), 
			'options' => array(
					'barber-shop' => esc_html__('Animated full screen','blokco'),
					'big-counter' => esc_html__('Big counter','blokco'),
					'center-circle' => esc_html__('Center circle','blokco'),
					'corner-indicator' => esc_html__('Corner indicator','blokco'),
					'fill-left' => esc_html__('Fill left','blokco'),
					'flash' => esc_html__('Flash','blokco'),
					'flat-top' => esc_html__('Flat top','blokco'),
					'loading-bar' => esc_html__('Loading bar','blokco'),
					'mac-osx' => esc_html__('Mac OSx','blokco'),
					'minimal' => esc_html__('Minimal','blokco'),
				),
			'default' => 'center-circle',
		),
        array(
            'id' => 'custom_admin_login_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Custom admin login logo', 'blokco'),
            'compiler' => 'true',
            'desc' => esc_html__('Upload a 254 x 95px image here to replace the default wordpress login logo.', 'blokco'),
            'default' => array('url' => $defaultAdminLogo),
        ),
       array(
            'id' => 'space_before_head',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing head tag', 'blokco'),
            'subtitle' => esc_html__('Add your code before closing head tag', 'blokco'),
			'default' => '',
        ),
       array(
            'id' => 'space_before_body',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing body tag', 'blokco'),
            'subtitle' => esc_html__('Add your code before closing body tag', 'blokco'),
			'default' => '',
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-website',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Responsive', 'blokco'),
    'fields' => array(
        array(
            'id' => 'switch-responsive',
            'type' => 'switch',
            'title' => esc_html__('Enable Responsive', 'blokco'),
            'subtitle' => esc_html__('Enable/Disable the responsive behaviour of the theme', 'blokco'),
            "default" => 1,
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-screen',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Layout', 'blokco'),
    'fields' => array(
        array(
			'id'=>'site_width',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Site Width', 'blokco'), 
			'subtitle' => esc_html__('Controls the overall site width. Without px, ex: 1170(Default). Recommended maximum width is 1170 to maintain the theme structure.', 'blokco'),
			'default' => '1170',
		),
        array(
			'id'=>'site_layout',
			'type' => 'image_select',
			'compiler'=>true,
			'title' => esc_html__('Page Layout', 'blokco'), 
			'subtitle' => esc_html__('Select the page layout type', 'blokco'),
			'options' => array(
					'wide' => array('alt' => 'Wide', 'img' => get_template_directory_uri().'/assets/images/wide.png'),
					'boxed' => array('alt' => 'Boxed', 'img' => get_template_directory_uri().'/assets/images/boxed.png')
				),
			'default' => 'wide',
			),
		array(
			'id'=>'repeatable-bg-image',
			'type' => 'image_select',
			'required' => array('site_layout','equals','boxed'),
			'title' => esc_html__('Repeatable Background Images', 'blokco'), 
			'subtitle' => esc_html__('Select image to set in background.', 'blokco'),
			'options' => array(
				'pt1.png' => array('alt' => 'pt1', 'img' => get_template_directory_uri().'/assets/images/patterns/pt1.png'),
				'pt2.png' => array('alt' => 'pt2', 'img' => get_template_directory_uri().'/assets/images/patterns/pt2.png'),
				'pt3.png' => array('alt' => 'pt3', 'img' => get_template_directory_uri().'/assets/images/patterns/pt3.png'),
				'pt4.png' => array('alt' => 'pt4', 'img' => get_template_directory_uri().'/assets/images/patterns/pt4.png'),
				'pt5.png' => array('alt' => 'pt5', 'img' => get_template_directory_uri().'/assets/images/patterns/pt5.png'),
				'pt6.png' => array('alt' => 'pt6', 'img' => get_template_directory_uri().'/assets/images/patterns/pt6.png'),
				'pt7.png' => array('alt' => 'pt7', 'img' => get_template_directory_uri().'/assets/images/patterns/pt7.png'),
				'pt8.png' => array('alt' => 'pt8', 'img' => get_template_directory_uri().'/assets/images/patterns/pt8.png'),
				'pt9.png' => array('alt' => 'pt9', 'img' => get_template_directory_uri().'/assets/images/patterns/pt9.png'),
				'pt10.png' => array('alt' => 'pt10', 'img' => get_template_directory_uri().'/assets/images/patterns/pt10.png'),
				'pt11.jpg' => array('alt' => 'pt11', 'img' => get_template_directory_uri().'/assets/images/patterns/pt11.png'),
				'pt12.jpg' => array('alt' => 'pt12', 'img' => get_template_directory_uri().'/assets/images/patterns/pt12.png'),
				'pt13.jpg' => array('alt' => 'pt13', 'img' => get_template_directory_uri().'/assets/images/patterns/pt13.png'),
				'pt14.jpg' => array('alt' => 'pt14', 'img' => get_template_directory_uri().'/assets/images/patterns/pt14.png'),
				'pt15.jpg' => array('alt' => 'pt15', 'img' => get_template_directory_uri().'/assets/images/patterns/pt15.png'),
				'pt16.png' => array('alt' => 'pt16', 'img' => get_template_directory_uri().'/assets/images/patterns/pt16.png'),
				'pt17.png' => array('alt' => 'pt17', 'img' => get_template_directory_uri().'/assets/images/patterns/pt17.png'),
				'pt18.png' => array('alt' => 'pt18', 'img' => get_template_directory_uri().'/assets/images/patterns/pt18.png'),
				'pt19.png' => array('alt' => 'pt19', 'img' => get_template_directory_uri().'/assets/images/patterns/pt19.png'),
				'pt20.png' => array('alt' => 'pt20', 'img' => get_template_directory_uri().'/assets/images/patterns/pt20.png'),
				'pt21.png' => array('alt' => 'pt21', 'img' => get_template_directory_uri().'/assets/images/patterns/pt21.png'),
				'pt22.png' => array('alt' => 'pt22', 'img' => get_template_directory_uri().'/assets/images/patterns/pt22.png'),
				'pt23.png' => array('alt' => 'pt23', 'img' => get_template_directory_uri().'/assets/images/patterns/pt23.png'),
				'pt24.png' => array('alt' => 'pt24', 'img' => get_template_directory_uri().'/assets/images/patterns/pt24.png'),
				'pt25.png' => array('alt' => 'pt25', 'img' => get_template_directory_uri().'/assets/images/patterns/pt25.png'),
				'pt26.png' => array('alt' => 'pt26', 'img' => get_template_directory_uri().'/assets/images/patterns/pt26.png'),
				'pt27.png' => array('alt' => 'pt27', 'img' => get_template_directory_uri().'/assets/images/patterns/pt27.png'),
				'pt28.png' => array('alt' => 'pt28', 'img' => get_template_directory_uri().'/assets/images/patterns/pt28.png'),
				'pt29.png' => array('alt' => 'pt29', 'img' => get_template_directory_uri().'/assets/images/patterns/pt29.png'),
				'pt30.png' => array('alt' => 'pt30', 'img' => get_template_directory_uri().'/assets/images/patterns/pt30.png')
				)
			),	
		array(
			'id'=>'upload-repeatable-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Repeatable Background Image', 'blokco')
			),
		array(
			'id'=>'full-screen-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Full Screen Background Image', 'blokco')
		),	
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Content', 'blokco'),
	'subsection' => true,
    'fields' => array(
		array(  'id' => 'content_background',
				'type' => 'background',
				'background-color'=> true,
				'compiler' => array('.content'),
				//'output' => array('.content'), Use this field to add inline css on page, above compiler argument should removed
				'title' => esc_html__('Content area Background', 'blokco'),
    			'subtitle' => esc_html__('Background color or image for the content area. This works for both boxed or wide layouts.', 'blokco'),
		),
		array(
			'id'       => 'content_padding',
			'type'     => 'spacing',
			'units'    => array('px'),
			'mode'	   => 'padding',
			'left'	   => false,
			'right'	   => false,
			'compiler'   => array('.content'),
			'title'    => esc_html__('Top and Bottom padding for content area', 'blokco'),
			'subtitle' => esc_html__('Enter top and bottom padding for content area. Default is 50px/50px', 'blokco'),
			'default'            => array(
			'padding-top'     => '60px',
			'padding-bottom'  => '60px',
			'units'          => 'px',
			),
		),
		array(
			'id'       => 'content_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Minimum Height for Content area', 'blokco'),
			'subtitle' => esc_html__('Enter minimum height for the page content area. DO NOT PUT px HERE. Default is 400', 'blokco'),
			'default'  => '400'
		),
        array(
			'id'=>'content_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Content Width', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the content area to 100% of the browser width. Uncheck to follow site width.', 'blokco'),
			'default' => '0',
		),

	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-up',
    'title' => esc_html__('Header', 'blokco'),
    'desc' => esc_html__('These are the options for the header.', 'blokco'),
    'fields' => array(
		array(
    		'id' => 'header_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Header Style','blokco'),
			'width' => '150px',
			'height' => '100px',
			'subtitle' => esc_html__('Select header style for your website', 'blokco'),
    			'options' => array(
					'1' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/1.png'),
    				'2' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/2.png'),
    				'3' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/3.png'),
    				'4' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/4.png'),
    				'5' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/5.png'),
    				'6' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/6.png'),
    				'7' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/7.png'),
    				'8' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/8.png'),
    				'9' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/9.png'),
    				'10' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/10.png'),
    				'11' => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/headerlayouts/11.png')
    				),
    		'default' => '1'
    	),
		array(
			'id'      => 'header_left_blocks',
			'type'    => 'sorter',
			'title'   => 'Header left content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site header. Selected blocks here will appear at the left side of header, for right side see below. -- For header style 3, logo position is fixed at left and this section is for header right top. -- For header style 4, menu position is fixed at the bottom. -- For header style 5 and 6 menu is fixed at bottom along with optional search, cart. -- For header style 10 logo is fixed in the header center and menu at bottom.','blokco'),
			'options' => array(
				'enabled'  => array(
					'logo' => esc_html__('Logo','blokco'),
					'menu'     => esc_html__('Menu','blokco'),
				),
				'disabled' => array(
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'cart'     			=> esc_html__('Cart','blokco'),
					'header-info1'     => esc_html__('Header Info 1','blokco'),
					'header-info2'     => esc_html__('Header Info 2','blokco'),
					'header-info3'     => esc_html__('Header Info 3','blokco'),
					'social-icons'     => esc_html__('Social Icons','blokco'),
					'widgets-opener'     => esc_html__('Widgets opener','blokco'),
					'search'     => esc_html__('Search','blokco'),
				)
			),
		),
		array(
			'id'      => 'header_right_blocks',
			'type'    => 'sorter',
			'title'   => 'Header right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site header. Selected blocks here will appear at the right side of header, for left side see above. -- For header style 3, logo position is fixed at left and this section is for header right bottom. -- For header style 4, menu position is fixed at the bottom. -- For header style 5 and 6 menu is fixed at bottom along with optional search, cart. -- For header style 10 logo is fixed in the header center and menu at bottom.','blokco'),
			'options' => array(
				'enabled'  => array(
					'search'     => esc_html__('Search','blokco'),
					'cart'     => esc_html__('Cart','blokco'),
				),
				'disabled' => array(
					'logo' => esc_html__('Logo','blokco'),
					'menu'     => esc_html__('Menu','blokco'),
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'header-info1'     => esc_html__('Header Info 1','blokco'),
					'header-info2'     => esc_html__('Header Info 2','blokco'),
					'header-info3'     => esc_html__('Header Info 3','blokco'),
					'social-icons'     => esc_html__('Social Icons','blokco'),
					'widgets-opener'     => esc_html__('Widgets opener','blokco'),
				)
			),
		),
		array(
			'id'   => 'obuttons_h56',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Option buttons for Header style 5 and 6','blokco')
		),
        array(
			'id'=>'header45_cart',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show cart option', 'blokco'), 
			'subtitle' => esc_html__('Check this to show cart option at the right of menu in header style 5 and 6.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'=>'header45_search',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show search option', 'blokco'), 
			'subtitle' => esc_html__('Check this to show search option at the right of menu in header style 5 and 6.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'        => 'sheader_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Site header style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the site header.','blokco'),
			'position'  => 'start',
		),
        array(
			'id'=>'header_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_layout','!=','11'),
			'title' => esc_html__('100% header width', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width. Uncheck to follow site width.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'=>'header_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width with no space on the sides.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'=>'header_position_float',
			'type' => 'button_set',
			'required' => array('header_layout','!=','11'),
			'title' => esc_html__('Header position', 'blokco'), 
			'subtitle' => esc_html__('Use floated if you want the content below header to go underneath the header. Use normal for header to stay above the content part.', 'blokco'),
			'default' => 0,
			'options' => array(
				0  => esc_html__('Normal','blokco'),
				1  => esc_html__('Floated','blokco'),
			)
		),
        array(
			'id'=>'header_no_bg_strict',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_layout','!=','11'),
			'required' => array('header_position_float','=',1),
			'title' => esc_html__('No background color/image', 'blokco'), 
			'subtitle' => esc_html__('Check this box if you want to have your header transparent with no background. This will work only with floated header position.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'=>'header_no_box_shadow',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('No shadow', 'blokco'), 
			'subtitle' => esc_html__('Check this box if you want to remove the shadow from the site header.', 'blokco'),
			'default' => 1,
		),
		array(  'id' => 'header_background_alpha',
			'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'transparent' => true,
			'compiler' => array('background-color'=>'.site-header,.header-style2 .site-header, .header-style7 .site-header, .header-style9 .site-header'),
			'title' => esc_html__('Header background color', 'blokco'),
			'default'   => array(
				'color'     => '#313131',
				'alpha'     => 1
			),
		),
		array(  'id' => 'header_background',
			'type' => 'background',
			'transparent' => false,
			'background-color' => false,
			'compiler' => array('.site-header,.header-style2 .site-header, .header-style7 .site-header, .header-style9 .site-header'),
			'title' => esc_html__('Header background image', 'blokco')
		),
		array(
			'id'=>'sheader11_side',
			'type' => 'button_set',
			'compiler'=>true,
			'required' => array('header_layout','=','11'),
			'title' => esc_html__('Site header position', 'blokco'), 
			'subtitle' => esc_html__('Choose to which side you would like to show header for Header style 11.', 'blokco'),
			'options' => array(
					1 => esc_html__('Left','blokco'),
					2 => esc_html__('Right','blokco')
				),
			'default' => 1,
		),
		array(
			'id'=>'sheader11_width',
			'type' => 'dimensions',
			'compiler'=>true,
			'height' => false,
			'required' => array('header_layout','=','11'),
			'compiler' => array('.header-style11 .site-header'),
			'title' => esc_html__('Site header width', 'blokco'), 
			'subtitle' => esc_html__('Enter value in pixels for the header (Header style 11).', 'blokco'),
		),
		array(
			'id'=>'sheader11_padding',
			'type' => 'spacing',
			'compiler'=>true,
			'units' => array('px'),
			'mode' => 'padding',
			'required' => array('header_layout','=','11'),
			'compiler' => array('.header-style11 .site-header'),
			'title' => esc_html__('Site header spacing', 'blokco'), 
			'subtitle' => esc_html__('Enter value in pixels for the header round side spacing (Header style 11).', 'blokco'),
		),
		array(
			'id'        => 'sheader_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shmenu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Main menu style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the maine menu for the site header.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'=>'dd_menu_style',
			'type' => 'select',
			'compiler'=>true,
			'title' => esc_html__('Menu style', 'blokco'), 
			'options' => array(
					'dd-style1' => esc_html__('Style 1','blokco'),
					'dd-style2' => esc_html__('Style 2','blokco'),
					'dd-style3' => esc_html__('Style 3','blokco'),
				),
			'default' => 'dd-style1',
		),
		array(
			'id'   => 'shhmenu_opener_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco'),
			'required'  => array('header_layout','=','9'),
		),
		array(
			'id'   => 'shhmenu_opener_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'shhmenu_opener_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.header-style9 .site-header .hidden-menu-opener:hover'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'shhmenu_opener_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'shhmenu_opener_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener:hover'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'shhmenu_opener_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shhmenu_opener_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
			'required'  => array('header_layout','=','9'),
		),
		array(
			'id'   => 'hs9_menu_bg_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('background-color'=>'.overlay-wrapper.main-menu:before'),
			'title' => esc_html__('Overlay menu background color','blokco'),
		),
		array(
			'id'   => 'hs9_menu_bg',
    		'type' => 'background',
			'background-color' => false,
			'transparent' => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('background-color'=>'.overlay-wrapper.main-menu:before'),
			'title' => esc_html__('Overlay menu background image','blokco'),
		),
		array(
			'id'   => 'hs9_menu_close_dimensions',
    		'type' => 'dimensions',
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Close button dimensions','blokco'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'desc' => esc_html__('Keep width and height equal for a square button','blokco')
		),
		array(
			'id'   => 'hs9_menu_close_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'title' => esc_html__('Close button background','blokco'),
		),
		array(
			'id'   => 'hs9_menu_close_hover_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close:hover'),
			'title' => esc_html__('Close button hover background','blokco'),
		),
		array(
			'id'       => 'hs9_menu_close_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'title'    => esc_html__('Close button color', 'blokco'),
		),
        array(
            'id' 		=> 'hs9_menu_close_link_typography',
            'type'      => 'typography',
			'title'     => esc_html__('Close button font size', 'blokco'),
			'required'  => array('header_layout','=','9'),
			'subsets' 	=> false,
			'color' 	=> false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'units'       =>'px',
        ),
		array(
            'id' => 'hs4_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','4'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style4 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'blokco'),
            'desc' => esc_html__('Set color for the full width menu in Header style 4.', 'blokco'),
        ),
		array(
            'id' => 'hs5_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','5'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style5 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'blokco'),
            'desc' => esc_html__('Set color for the full width menu in Header style 5.', 'blokco'),
        ),
		array(
            'id' => 'hs6_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','6'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style6 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'blokco'),
            'desc' => esc_html__('Set color for the full width menu in Header style 6.', 'blokco'),
        ),
		array(
            'id' => 'hs10_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','10'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style10 .fw-menu'),
            'title' => esc_html__('Main nav background', 'blokco'),
            'desc' => esc_html__('Set color for the full width menu in Header style 10.', 'blokco'),
        ),
		array(
			'id'       => 'main_nav_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Main navigation links typography', 'blokco'),
			'compiler'   => array('.dd-menu > li > a, .header-style9 .overlay-wrapper .dd-menu > li > a')
		),
		array(
            'id' => 'dd_style1_animated_border',
            'type' => 'color_rgba',
			'required' => array('dd_menu_style','=','dd-style1'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.dd-menu > li > a:before'),
            'title' => esc_html__('Main nav links border bottom color', 'blokco'),
            'desc' => esc_html__('Set color for the animated border which shows for the main links in the navigation.', 'blokco'),
        ),
		array(
            'id' => 'dd_style3_main_hover_bg',
            'type' => 'color_rgba',
			'required' => array('dd_menu_style','=','dd-style3'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.dd-style3.dd-menu > li:hover > a, .dd-style3.dd-menu > li.current-menu-item > a'),
            'title' => esc_html__('Main nav links hover bg color', 'blokco'),
            'desc' => esc_html__('Set main navigation links hover background color.(For menu style 3)', 'blokco'),
        ),
		array(
			'id'       => 'main_nav_link',
			'type'     => 'link_color',
			'title'    => esc_html__('Main navigation link color', 'blokco'),
			'desc'     => esc_html__('Set the Main Navigation links color, hover, active.', 'blokco'),
		),
		array(
			'id'       => 'main_nav_link_active',
			'type'     => 'link_color',
			'title'    => esc_html__('Main Navigation current menu link color', 'blokco'),
			'desc'     => esc_html__('Set the Main Navigation links color for active page.', 'blokco'),
		),
        array(
            'id' => 'nav_directions_arrows',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
            'title' => esc_html__('Direction arrows with menu label', 'blokco'),
            'subtitle' => esc_html__('Uncheck to disable arrows that appear with menu text which is having dropdown. Check to enable.', 'blokco'),
            "default" => 1,
        ),
        array(
            'id' => 'dd_dropshadow',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
            'title' => esc_html__('Drop shadow for dropdown menus', 'blokco'),
            'subtitle' => esc_html__('Uncheck to disable drop shadow for the dropdown menu blocks. Check to enable.', 'blokco'),
            "default" => 1,
        ),
        array(
            'id' => 'dd_border_radius',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
			'required' => array('dd_menu_style','=','dd-style2'),
            'title' => esc_html__('Rounded border', 'blokco'),
            'subtitle' => esc_html__('Uncheck to disable rounded border style for the dropdown menu blocks. Check to enable.(Only for Dropdown menu style 2)', 'blokco'),
            "default" => 1,
        ),
		array(
            'id' => 'dd_background',
            'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),
			'compiler' => array('background-color' => '.dd-menu li ul,.dd-style2.dd-menu li ul,.dd-style3.dd-menu li ul','border-bottom-color' => '.dd-style2.dd-menu li ul:before'),
            'title' => esc_html__('Background color for dropdown menus', 'blokco'),
            'desc' => esc_html__('Background color set for the dropdowns blocks of main navigation.', 'blokco'),
			'default'   => array(
				'color'     => '#ffffff',
				'alpha'     => 1
			),
        ),
		array(
			'id'       => 'dd_item_border',
			'type'     => 'border',
			'title'    => esc_html__('Dropdown links border bottom', 'blokco'),
			'compiler'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
			'bottom' 	=> true
		),
		array(
			'id'       => 'dd_item_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Dropdown links spacing', 'blokco'),
			'compiler'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'mode' 	   => 'padding',
			'units'    => array('px'),
		),
		array(
            'id' => 'dd_item_background',
            'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),
			'compiler' => array('background' =>'.dd-style1.dd-menu > li > ul > li > a:hover, .dd-style1.dd-menu > li > ul > li > ul > li > a:hover, .dd-style1.dd-menu > li > ul > li > ul > li > ul > li > a:hover,.dd-style2.dd-menu > li > ul > li > a:hover, .dd-style2.dd-menu > li > ul > li > ul > li > a:hover, .dd-style2.dd-menu > li > ul > li > ul > li > ul > li > a:hover,.dd-style3.dd-menu > li > ul > li > a:hover, .dd-style3.dd-menu > li > ul > li > ul > li > a:hover, .dd-style3.dd-menu > li > ul > li > ul > li > ul > li > a:hover'),
            'title' => esc_html__('Background color for dropdown menus links hover', 'blokco'),
        ),
		array(
			'id'       => 'dd_item_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Dropdown Menu Links Typography', 'blokco'),
			'compiler'   => array('.dd-style1.dd-menu > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > ul > li > a,.dd-style2.dd-menu > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > ul > li > a')
		),
		array(
			'id'       => 'dd_item_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Dropdown links color', 'blokco'),
		),
		array(
			'id'        => 'shmenu_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shhinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the header info for the site header.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'       => 'header_info_typo_header',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'line-height' => true,
			'text-align' => true,
			'title'    => esc_html__('Typography', 'blokco'),
			'desc'    => esc_html__('These options will affect the header info shown in the main header only.', 'blokco'),
			'compiler'   => array('.site-header .header_info_text')
		),
		array(
			'id'       => 'header_info_header_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .header_info_text a'),
			'title'    => esc_html__('Links color', 'blokco'),
			'desc'    => __('These options will affect the links in header info shown in the site header only.', 'blokco'),
		),
		array(
			'id'       => 'header_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 1 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.site-header .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'header_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.site-header .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'header_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.site-header .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'shhinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shsocial_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the social icons for the site header.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'=>'header_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'blokco'),
		),
		array(
			'id'=>'header_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'blokco'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'blokco'),
		),
		array(
			'id'=>'header_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'blokco'),
		),
		array(
			'id'       => 'header_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.body .site-header .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'blokco'),
		),
		array(
			'id'        => 'shsocial_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shsearch_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'shddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'shddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.site-header .search-module-trigger:hover, .header-style2 .site-header .search-module-trigger:hover, .header-style9 .site-header .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'shddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'shddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-trigger:hover, .header-style2 .site-header .search-module-trigger:hover, .header-style9 .site-header .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'shddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'shddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.site-header .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','blokco'),
		),
		array(
			'id'   => 'shddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','blokco'),
		),
		array(
			'id'   => 'shddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.site-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','blokco'),
		),
		array(
			'id'   => 'shopensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.site-header .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','blokco'),
		),
		array(
			'id'   => 'shopensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','blokco'),
		),
		array(
			'id'=>'shopensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.site-header .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width for the search form.', 'blokco')
		),
		array(
			'id'=>'shopensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.site-header .open-search-form .imi-searchform input[type="text"],.site-header .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'blokco')
		),
        array(
            'id' => 'shopensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'shopensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shopensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.site-header .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'blokco'),
		),
		array(
			'id'        => 'shsearch_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'shcart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the site header','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shcart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'shcart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'shcart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-trigger:hover, .header-style2 .site-header .cart-module-trigger:hover, .header-style9 .site-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'shcart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'shcart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-trigger:hover, .header-style2 .site-header .cart-module-trigger:hover, .header-style9 .site-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'shcart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shcart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'shcart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-opened'),
			'title' => esc_html__('Open cart background','blokco'),
		),
		array(
			'id'   => 'shcart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-items'),
			'title' => esc_html__('Open cart border','blokco'),
		),
		array(
			'id'   => 'shcart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.site-header .cart-module-opened'),
			'title' => esc_html__('Open cart border top','blokco'),
		),
		array(
			'id'       => 'shcart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'blokco'),
		),
        array(
            'id' => 'shcart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'shcart_opened_footer_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','blokco'),
		),
		array(
			'id'   => 'shcart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','blokco'),
		),
		array(
			'id'       => 'shcart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'blokco'),
		),
        array(
            'id' => 'shcart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'shcart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'shwopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the topbar','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shwopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.site-header .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','blokco')
		),
		array(
			'id'   => 'shwopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .topper-opener'),
			'title' => esc_html__('Trigger button background','blokco'),
		),
		array(
			'id'   => 'shwopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','blokco'),
		),
		array(
			'id'   => 'shwopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .topper-opener'),
			'title' => esc_html__('Trigger button border','blokco'),
		),
		array(
			'id'   => 'shwopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','blokco'),
		),
        array(
            'id' => 'shwopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shwopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'blokco'),
		),
		array(
			'id'        => 'shwopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Featured Buttons', 'blokco'),
	'desc'     => esc_html__('These are options to add highlighted buttons in to your site main header.', 'blokco'),
	'subsection' => true,
    'fields' => array(
		array(
    		'id'   =>'divider_1',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 1','blokco')
		),
		array(
            'id' => 'feat_button_title1',
            'type' => 'text',
            'title' => esc_html__('Label', 'blokco'),
            'subtitle' => esc_html__('Insert featured button 1 label', 'blokco'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'blokco'),
            'default' => esc_html__('Button','blokco')
        ),
		array(
            'id' => 'feat_button_url1',
            'type' => 'text',
            'title' => esc_html__('URL', 'blokco'),
            'subtitle' => esc_html__('Enter featured button 1 URL', 'blokco'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'blokco'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape1',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'blokco'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','blokco'),
					'fbtn-square' => esc_html__('Square','blokco'),
					'fbtn-round' => esc_html__('Round','blokco')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size1',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'blokco'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','blokco'),
					'fbtn-sm' => esc_html__('Small','blokco'),
					'fbtn-md' => esc_html__('Medium','blokco'),
					'fbtn-lg' => esc_html__('Large','blokco'),
					'fbtn-custom' => esc_html__('Custom','blokco')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size1_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn1'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'blokco'),
			'required' => array('feat_button_size1','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg1_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn1'),
			'title'   => esc_html__('Background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg1',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg1_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn1:hover'),
			'title'   => esc_html__('Hover background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg1_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn1:hover'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(
			'id'=>'feat_button_border1',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title' => esc_html__('Border', 'blokco'), 
		),
		array(
			'id'=>'feat_button_border1_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn1:hover'),
			'title' => esc_html__('Hover Border', 'blokco'), 
		),
		array(         
			'id'   	=> 'feat_button_color1',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title'   => esc_html__('Link color', 'blokco'),
		),
		array(
			'id'=>'feat_button_typo1',
			'type' => 'typography',
			'line-height' => true,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'text-align' => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn1'),
			'title' => esc_html__('Typography', 'blokco'),
		),
		array(
    		'id'   =>'divider_2',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 2','blokco')
		),
		array(
            'id' => 'feat_button_title2',
            'type' => 'text',
            'title' => esc_html__('Label', 'blokco'),
            'subtitle' => esc_html__('Insert featured button 2 label', 'blokco'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'blokco'),
            'default' =>  esc_html__('Button','blokco')
        ),
		array(
            'id' => 'feat_button_url2',
            'type' => 'text',
            'title' => esc_html__('URL', 'blokco'),
            'subtitle' => esc_html__('Enter featured button 2 URL', 'blokco'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'blokco'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape2',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'blokco'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','blokco'),
					'fbtn-square' => esc_html__('Square','blokco'),
					'fbtn-round' => esc_html__('Round','blokco')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size2',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'blokco'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','blokco'),
					'fbtn-sm' => esc_html__('Small','blokco'),
					'fbtn-md' => esc_html__('Medium','blokco'),
					'fbtn-lg' => esc_html__('Large','blokco'),
					'fbtn-custom' => esc_html__('Custom','blokco')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size2_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn2'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'blokco'),
			'required' => array('feat_button_size2','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg2_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn2'),
			'title'   => esc_html__('Background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg2',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg2_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn2:hover'),
			'title'   => esc_html__('Hover background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg2_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn2:hover'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(
			'id'=>'feat_button_border2',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title' => esc_html__('Border', 'blokco'), 
		),
		array(
			'id'=>'feat_button_border2_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn2:hover'),
			'title' => esc_html__('Hover Border', 'blokco'), 
		),
		array(         
			'id'   	=> 'feat_button_color2',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title'   => esc_html__('Link color', 'blokco'),
		),
		array(
			'id'=>'feat_button_typo2',
			'type' => 'typography',
			'line-height' => true,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'text-align' => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn2'),
			'title' => esc_html__('Typography', 'blokco'),
		),
		array(
    		'id'   =>'divider_3',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 3','blokco')
		),
		array(
            'id' => 'feat_button_title3',
            'type' => 'text',
            'title' => esc_html__('Label', 'blokco'),
            'subtitle' => esc_html__('Insert featured button 3 label', 'blokco'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'blokco'),
            'default' => esc_html__('Button','blokco')
        ),
		array(
            'id' => 'feat_button_url3',
            'type' => 'text',
            'title' => esc_html__('URL', 'blokco'),
            'subtitle' => esc_html__('Enter featured button 3 URL', 'blokco'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'blokco'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape3',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'blokco'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','blokco'),
					'fbtn-square' => esc_html__('Square','blokco'),
					'fbtn-round' => esc_html__('Round','blokco')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size3',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'blokco'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','blokco'),
					'fbtn-sm' => esc_html__('Small','blokco'),
					'fbtn-md' => esc_html__('Medium','blokco'),
					'fbtn-lg' => esc_html__('Large','blokco'),
					'fbtn-custom' => esc_html__('Custom','blokco')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size3_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn3'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'blokco'),
			'required' => array('feat_button_size3','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg3_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn3'),
			'title'   => esc_html__('Background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg3',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg3_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn3:hover'),
			'title'   => esc_html__('Hover background color translucent', 'blokco'),
		),
		array(         
			'id'   	=> 'feat_button_bg3_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn3:hover'),
			'title'   => esc_html__('Background color/image', 'blokco'),
		),
		array(
			'id'=>'feat_button_border3',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title' => esc_html__('Border', 'blokco'), 
		),
		array(
			'id'=>'feat_button_border3_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn3:hover'),
			'title' => esc_html__('Hover Border', 'blokco'), 
		),
		array(         
			'id'   	=> 'feat_button_color3',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title'   => esc_html__('Link color', 'blokco'),
		),
		array(
			'id'=>'feat_button_typo3',
			'type' => 'typography',
			'line-height' => true,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'text-align' => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn3'),
			'title' => esc_html__('Typography', 'blokco'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Header Info', 'blokco'),
	'subsection' => true,
    'fields' => array(
		array(
    		'id'   =>'info_divider_1',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 1','blokco')
		),
		array(
            'id' => 'header_info_text1',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 1', 'blokco'),
            'subtitle' => esc_html__('HTML tags are allowed', 'blokco'),
            'default' => ''
        ),
		array(
    		'id'   =>'info_divider_2',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 2','blokco')
		),
		array(
            'id' => 'header_info_text2',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 2', 'blokco'),
            'subtitle' => esc_html__('HTML tags are allowed', 'blokco'),
            'default' => ''
        ),
		array(
    		'id'   =>'info_divider_3',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 3','blokco')
		),
		array(
            'id' => 'header_info_text3',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 3', 'blokco'),
            'subtitle' => esc_html__('HTML tags are allowed', 'blokco'),
            'default' => ''
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Social Links', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
			'id' => 'header_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'title' => esc_html__('Social Links', 'blokco'),
			'desc' => esc_html__('Enter the social links and sort to activate and display according to sequence.', 'blokco'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube-play' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-tripadvisor' => 'tripadvisor',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Email Address'
			),
		),
		array(
			'id'=>'main_social_shape',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'blokco'), 
			'options' => array(
					'imi-social-icons-round' => esc_html__('Round','blokco'),
					'imi-social-icons-rounded' => esc_html__('Rounded','blokco'),
					'imi-social-icons-square' => esc_html__('Square','blokco'),
					'imi-social-icons-plain' => esc_html__('Plain','blokco')
				),
			'default' => 'imi-social-icons-round',
		),
		array(
			'id'=>'main_social_size',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'blokco'), 
			'options' => array(
					'imi-social-icons-small' => esc_html__('Small','blokco'),
					'imi-social-icons-medium' => esc_html__('Medium','blokco'),
					'imi-social-icons-large' => esc_html__('Large','blokco'),
					'imi-social-icons-xlarge' => esc_html__('Extra Large','blokco'),
					'imi-social-icons-custom' => esc_html__('Custom','blokco')
				),
			'default' => 'imi-social-icons-medium',
		),
		array(
			'id'=>'main_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.header-left-blocks .header-social-container .imi-social-icons li a,.header-right-blocks .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'blokco'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.header-left-blocks .header-social-container .imi-social-icons li,.header-right-blocks .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'blokco'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'blokco'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'blokco'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Style', 'blokco'), 
			'options' => array(
					'imi-social-icons-bc' => esc_html__('Brand colors','blokco'),
					'imi-social-icons-tc' => esc_html__('Theme primary color','blokco'),
					'imi-social-icons-sc' => esc_html__('Theme secondary color','blokco'),
					'imi-social-icons-gc' => esc_html__('Grayscale','blokco')
				),
			'default' => 'imi-social-icons-bc',
		),
		array(
			'id'=>'main_social_hover_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Hover style', 'blokco'), 
			'options' => array(
					'imi-social-icons-hover-bc' => esc_html__('Brand colors','blokco'),
					'imi-social-icons-hover-tc' => esc_html__('Theme primary color','blokco'),
					'imi-social-icons-hover-sc' => esc_html__('Theme secondary color','blokco'),
					'imi-social-icons-hover-gc' => esc_html__('Grayscale','blokco')
				),
			'default' => 'imi-social-icons-hover-sc',
		),
		array(
			'id'       => 'main_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.body .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'blokco'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Overlay Content', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_topbar_opener',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Overlay Content', 'blokco'),
            'subtitle' => esc_html__('Enable/Disable overlay content area that opens up on click of a special button in the topbar/header.', 'blokco'	
			),
            "default" => 1,
       	),
		array(
			'id'       => 'topbar_opener_link_text',
			'type'     => 'text',
			'required' => array('enable_topbar_opener','=',1),
			'title'    => esc_html__('Overlay content opener button text', 'blokco'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'blokco'),
			'subtitle'     => esc_html__('Enter text to show for button opener for the overlay content area.', 'blokco'),
			'default'  => esc_html__('<i class="fa fa-th"></i>','blokco')
		),
		array(
			'id'=>'topbar_opener_position',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Overlay content block position', 'blokco'), 
			'subtitle' => esc_html__('Choose where you would like to show the overlay content area', 'blokco'),
			'options' => array(
					'widgets-at-left' => esc_html__('Left','blokco'),
					'widgets-at-top' => esc_html__('Top','blokco'),
					'widgets-at-right' => esc_html__('Right','blokco')
				),
			'default' => 'widgets-at-right',
		),
        array(
            'id' => 'enable_topbar_opener_always',
            'type' => 'checkbox',
            'title' => esc_html__('Keep opened by default', 'blokco'),
            'subtitle' => esc_html__('Check this to keep the overlay content open by default without the trigger button action.', 'blokco'	
			),
            "default" => 0,
			'required' 		 => array('topbar_opener_position','=','widgets-at-top'),
       	),
		array(
			'id'       => 'topbar_opener_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__('Width of the overlay content block', 'blokco'),
			'compiler'   => array('.topper-container.widgets-at-right, .topper-container.widgets-at-left'),
			'height'    => false,
			'default' => array(
				'width' => '350px'
			),
			'required' 		 => array('topbar_opener_position','!=','widgets-at-top'),
		),
		array(
			'id'=>'topbar_opener_spacing',
			'type' => 'spacing',
			'mode' => 'padding',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.topper-container.widgets-at-right, .topper-container.widgets-at-left'),
			'title' => esc_html__('Side padding', 'blokco'),
			'desc' => esc_html__('Enter the padding from all sides for overlay content block.', 'blokco'),
			'required' 		 => array('topbar_opener_position','!=','widgets-at-top'),
			'default' => array(
				'padding-top' => '80px',
				'padding-left' => '20px',
				'padding-right' => '20px'
			)
		),
		array(  'id' => 'topbar_widgets_background',
			'type' => 'background',
			'background-color'=> true,
			'background-image'=> false,
			'background-repeat'=> false,
			'background-attachment'=> false,
			'background-size'=> false,
			'background-position'=> false,
			'preview'=> false,
			'compiler' => array('.topper-container'),
			'title' => esc_html__('Overlay content area background color', 'blokco'),
			'subtitle' => esc_html__('Background color for the overlay content area', 'blokco'),
			  'default' => array(
			  	'background-color' => '#303030'
			  )
		),
		array(
			'id'       	=> 'topbar_widgets_content',
			'type'     	=> 'select',
			'title'    	=> esc_html__('Overlay Content VC Section', 'blokco'), 
			'desc'    	=> esc_html__('Select VC Section for overlay content area.', 'blokco'),
			'data'  	=> 'posts',
			'args'  => array(
				'post_type'      => 'imi_vc_section',
				'posts_per_page' => -1,
				'orderby'        => 'title',
				'order'          => 'ASC',
			),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Search Form Style', 'blokco'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'=>'search_form_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Search form style for site header and topbar', 'blokco'), 
			'options' => array(
					'0' => esc_html__('Dropdown form','blokco'),
					'1' => esc_html__('Open form','blokco'),
					'2' => esc_html__('Overlay form','blokco')
				),
			'default' => '0',
		),
		array(
			'id'   => 'overlay_search_bg_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('background-color'=>'.overlay-search-form-wrapper:before'),
			'title' => esc_html__('Search form background color','blokco'),
		),
		array(
			'id'   => 'overlay_search_bg',
    		'type' => 'background',
			'background-color' => false,
			'transparent' => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('background-color'=>'.overlay-search-form-wrapper:before'),
			'title' => esc_html__('Search form background image','blokco'),
		),
		array(
			'id'   => 'overlay_search_border',
    		'type' => 'border',
			'top'  => false,
			'left'  => false,
			'right'  => false,
			'bottom'  => true,
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform'),
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Search form border bottom','blokco'),
		),
		array(
			'id'   => 'overlay_search_field_border',
    		'type' => 'color',
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform input[type="text"]'),
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Search form text color','blokco'),
		),
		array(
			'id'       => 'overlay_search_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'blokco'),
		),
		array(
			'id'   => 'overlay_search_close_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Close button dimensions','blokco'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'desc' => esc_html__('Keep width and height equal for a square button','blokco')
		),
		array(
			'id'   => 'overlay_search_close_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'title' => esc_html__('Close button background','blokco'),
		),
		array(
			'id'   => 'overlay_search_close_hover_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close:hover'),
			'title' => esc_html__('Close button hover background','blokco'),
		),
		array(
			'id'       => 'overlay_search_close_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'title'    => esc_html__('Close button color', 'blokco'),
		),
        array(
            'id' => 'overlay_search_close_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Close button font size', 'blokco'),
			'required' => array('search_form_style','=','2'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'units'       =>'px',
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Logo', 'blokco'),
    'desc' => esc_html__('These are the options for the header.', 'blokco'),
    'fields' => array(
        array(
            'id' => 'logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'blokco'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'blokco'),
            'default' => array('url' => $default_logo,'height' => '57','width' => '169'),
        ),
        array(
            'id' => 'retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'blokco'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'blokco'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'blokco'),
            'default' => array('url' => $default_retina_logo),
        ),
		array(
			'id'             => 'logo_spacing',
			'type'           => 'spacing',
			'compiler'         => array('.site-logo'),
			'mode'           => 'padding',
			'units'          => array('px'),
			'units_extended' => 'false',
			'title'          => esc_html__('Logo Spacing', 'blokco'),
			'subtitle'       => esc_html__('Set top, right, bottom, left spacing for the logo', 'blokco'),
			'default' 		 => array(
								'padding-top' => '35px',
								'padding-bottom' => '35px'
							)
		),
		array(
			'id'   => 'logo_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'compiler'   => array('background-color'=>'.site-logo'),
			'title' => esc_html__('Logo background','blokco'),
		),
		array(
			'id'   => 'logo_border',
    		'type' => 'border',
			'all'  => false,
			'compiler'   => array('.site-logo'),
			'title' => esc_html__('Logo border','blokco'),
		),
		array(
			'id'        => 'sticky_logo_section_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header logo','blokco'),
			'subtitle'  => esc_html__('Use this section to upload a unique logo for your website sticky header.','blokco'),
			'position'  => 'start',
		),
        array(
            'id' => 'sticky_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'blokco'),
            'subtitle' => esc_html__('Upload site logo to display in sticky header.', 'blokco'),
            'default' => '',
        ),
        array(
            'id' => 'sticky_retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'blokco'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'blokco'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'blokco'),
            'default' => '',
        ),
		array(
			'id'             => 'sticky_logo_spacing',
			'type'           => 'spacing',
			'compiler'         => array('.sticky-logo'),
			'mode'           => 'padding',
			'units'          => array('px'),
			'units_extended' => 'false',
			'title'          => esc_html__('Logo Spacing', 'blokco'),
			'subtitle'       => esc_html__('Set top, right, bottom, left spacing for the logo', 'blokco'),
		),
		array(
			'id'   => 'sticky_logo_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'compiler'   => array('background-color'=>'.sticky-logo'),
			'title' => esc_html__('Logo background','blokco'),
		),
		array(
			'id'   => 'sticky_logo_border',
    		'type' => 'border',
			'all'  => false,
			'compiler'   => array('.sticky-logo'),
			'title' => esc_html__('Logo border','blokco'),
		),
		array(
			'id'        => 'sticky_logo_section_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'mobile_logo_section_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Mobile header logo','blokco'),
			'subtitle'  => esc_html__('Use this section to upload a unique logo for your website header when viewed on a small screen device like mobile.','blokco'),
			'position'  => 'start',
		),
        array(
            'id' => 'mobile_logo_upload',
            'type' => 'media',
			'required' => array('enable_mobile_header','=',1),
            'url' => true,
            'title' => esc_html__('Upload Logo', 'blokco'),
            'subtitle' => esc_html__('Upload site logo to display in mobile header.', 'blokco'),
            'default' => '',
        ),
        array(
            'id' => 'mobile_retina_logo_upload',
            'type' => 'media',
			'required' => array('enable_mobile_header','=',1),
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'blokco'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'blokco'),
            'subtitle' => esc_html__('Upload site retina logo to display in mobile header.', 'blokco'),
            'default' => '',
        ),
		array(
			'id'        => 'mobile_logo_section_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Topbar', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'show_topbar',
            'type' => 'checkbox',
            'title' => esc_html__('Show Topbar', 'blokco'),
            'subtitle' => esc_html__('Enable/Disable Topbar', 'blokco'	
			),
            "default" => 0,
       	),
		array(
			'id'      => 'topbar_left_blocks',
			'type'    => 'sorter',
			'title'   => 'Topbar left content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site topbar. Selected blocks here will appear at the left side of topbar, for right side see below.','blokco'),
			'options' => array(
				'enabled'  => array(
					'social-icons' => esc_html__('Social Icons','blokco'),
				),
				'disabled' => array(
					'header-info1'   => esc_html__('Header Info 1','blokco'),
					'header-info2'   => esc_html__('Header Info 2','blokco'),
					'header-info3'   => esc_html__('Header Info 3','blokco'),
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'widgets-opener'     => esc_html__('Widgets Opener','blokco'),
					'menu' => esc_html__('Top Menu','blokco'),
					'search' => esc_html__('search','blokco'),
					'cart' => esc_html__('Cart','blokco')
				)
			),
		),
		array(
			'id'      => 'topbar_right_blocks',
			'type'    => 'sorter',
			'title'   => 'Topbar right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site topbar. Selected blocks here will appear at the right side of topbar, for left side see above.','blokco'),
			'options' => array(
				'enabled'  => array(
					'menu' => esc_html__('Top Menu','blokco'),
				),
				'disabled' => array(
					'header-info1'   => esc_html__('Header Info 1','blokco'),
					'header-info2'   => esc_html__('Header Info 2','blokco'),
					'header-info3'   => esc_html__('Header Info 3','blokco'),
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'social-icons' 	 => esc_html__('Social Icons','blokco'),
					'widgets-opener' => esc_html__('Widgets Opener','blokco'),
					'search' 		 => esc_html__('search','blokco'),
					'cart' 			 => esc_html__('Cart','blokco')
				)
			),
		),
		array(
			'id'        => 'topbar_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Topbar style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the topbar of your website.','blokco'),
			'position'  => 'start',
		),
        array(
			'id'=>'topbar_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Width', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the topbar area to 100% of the browser width. Uncheck to follow site width.', 'blokco'),
			'default' => '0',
		),
        array(
			'id'=>'topbar_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('topbar_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the topbar area to 100% of the browser width with no space on the sides.', 'blokco'),
			'default' => '0',
		),
		array(
			'id'       => 'topbar_max_height',
			'type'     => 'dimensions',
			'width' => false,
			'title'    => esc_html__('Topbar height', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum height for the topbar. Default is 48px.', 'blokco'),
			'compiler'   => array('.topbar, .topbar .header-equaler, .topbar .header-equaler > div > div, .topbar .topbar-blocks, .topbar .topbar-blocks > div > div, .topbar-additional-menu > ul > li > a'),
			'default'  => array(
				'height' => ''
			)
		),
		array(  'id' => 'topbar_background',
			'type' => 'background',
			'compiler' => array('.topbar'),
			'title' => esc_html__('Background color/image', 'blokco'),
			'subtitle' => esc_html__('Background color/image for the topbar.', 'blokco'),
		),
		array(
			'id'        => 'topbar_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'thinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the header info used for the topbar.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'       => 'header_info_typo_topbar',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'line-height' => false,
			'text-align' => false,
			'title'    => __('Typography', 'blokco'),
			'desc'    => __('These options will affect the header info shown in the site topbar only.', 'blokco'),
			'compiler'   => array('.topbar .header_info_text')
		),
		array(
			'id'       => 'header_info_topbar_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .header_info_text a'),
			'title'    => esc_html__('Links color', 'blokco'),
			'desc'    => __('These options will affect the links in header info shown in the site topbar only.', 'blokco'),
		),
		array(
			'id'       => 'topbar_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => __('Header info 1 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site topbar. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.topbar .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'topbar_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site topbar. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.topbar .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'topbar_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site topbar. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.topbar .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'thinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tsicons_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the social icons used for the topbar.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'=>'topbar_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'blokco'),
		),
		array(
			'id'=>'topbar_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'blokco'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'blokco'),
		),
		array(
			'id'=>'topbar_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'blokco'),
		),
		array(
			'id'       => 'topbar_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.topbar .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'blokco'),
		),
		array(
			'id'        => 'tsicons_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tmenu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Topbar Menu style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the menu used for the topbar. This is the menu you select for location "Topbar Menu" at Appearance => Menus','blokco'),
			'position'  => 'start',
		),
        array(
            'id' => 'topbar_menu_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'word-spacing' => true,
			'text-transform' => true,
			'line-height' => false,
			'compiler'      => array('.topbar-additional-menu > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topbar_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > a'),
			'title'    => esc_html__('Links Color', 'blokco'),
		),
		array(
			'id'       => 'topbar_menu_links_border',
			'type'     => 'border',
			'right'  => false,
			'left'  => true,
			'top'  => false,
			'bottom'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > a'),
			'title'    => esc_html__('Links sides border', 'blokco'),
		),
		array(
			'id'       => 'topbar_menu_links_padding',
			'type'     => 'spacing',
			'mode'  => 'padding',
			'top'  => false,
			'bottom'  => false,
			'units'  => array('px'),
			'compiler'   => array('.topbar-additional-menu > ul > li a, .topbar-additional-menu > ul > li ul li a'),
			'title'    => esc_html__('Links inside spacing', 'blokco'),
		),
		array(
			'id'       => 'topbar_menu_dd_bg',
			'type'     => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar-additional-menu > ul > li ul'),
			'title'    => esc_html__('Dropdown background', 'blokco'),
		),
        array(
            'id' => 'topbar_menu_dd_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Dropdown links typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'compiler'      => array('.topbar-additional-menu > ul > li > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topbar_menu_dd_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > ul > li a'),
			'title'    => esc_html__('Dropdown links color', 'blokco'),
		),
		array(
			'id'        => 'tmenu_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tsearch_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'tddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.topbar .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'tddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.topbar .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'tddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.topbar .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'tddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'tddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'tddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'tddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .search-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'tddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.topbar .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','blokco'),
		),
		array(
			'id'   => 'tddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','blokco'),
		),
		array(
			'id'   => 'tddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.topbar .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','blokco'),
		),
		array(
			'id'   => 'topensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.topbar .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','blokco'),
		),
		array(
			'id'   => 'topensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','blokco'),
		),
		array(
			'id'=>'topensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.topbar .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width for the search form.', 'blokco')
		),
		array(
			'id'=>'topensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.topbar .open-search-form .imi-searchform input[type="text"],.topbar .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'blokco')
		),
        array(
            'id' => 'topensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'topensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.topbar .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'blokco'),
		),
		array(
			'id'        => 'tsearch_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tcart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the topbar','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'tcart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.topbar .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'tcart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'tcart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'tcart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'tcart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'tcart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'tcart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'tcart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-opened'),
			'title' => esc_html__('Open cart background','blokco'),
		),
		array(
			'id'   => 'tcart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-items'),
			'title' => esc_html__('Open cart border','blokco'),
		),
		array(
			'id'   => 'tcart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.topbar .cart-module-opened'),
			'title' => esc_html__('Open cart border top','blokco'),
		),
		array(
			'id'       => 'tcart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'blokco'),
		),
        array(
            'id' => 'tcart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'tcart_opened_footer_bg',
    		'type' => 'color_rgba',
			'compiler'   => array('background-color'=>'.topbar .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','blokco'),
		),
		array(
			'id'   => 'tcart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','blokco'),
		),
		array(
			'id'       => 'tcart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'blokco'),
		),
        array(
            'id' => 'tcart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'tcart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'twopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the topbar','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'twopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.topbar .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','blokco')
		),
		array(
			'id'   => 'twopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .topper-opener'),
			'title' => esc_html__('Trigger button background','blokco'),
		),
		array(
			'id'   => 'twopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','blokco'),
		),
		array(
			'id'   => 'twopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .topper-opener'),
			'title' => esc_html__('Trigger button border','blokco'),
		),
		array(
			'id'   => 'twopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','blokco'),
		),
        array(
            'id' => 'twopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'twopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'blokco'),
		),
		array(
			'id'        => 'twopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Sticky Header', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_sticky_header',
            'type' => 'switch',
            'title' => esc_html__('Sticky Header', 'blokco'),
            'subtitle' => esc_html__('Enable/Disable', 'blokco'),
            "default" => 1,
        ),
		array(
			'id'      => 'sticky_header_left_blocks',
			'required' => array('enable_sticky_header','=',1),
			'type'    => 'sorter',
			'title'   => esc_html__('Sticky header left content','blokco'),
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site sticky header. Selected blocks here will appear at the left side of sticky header, for right side see below.','blokco'),
			'options' => array(
				'enabled'  => array(
					'logo' => esc_html__('Logo','blokco'),
				),
				'disabled' => array(
					'menu'     => esc_html__('Menu','blokco'),
					'cart'     => esc_html__('Cart','blokco'),
					'search'   => esc_html__('Search','blokco'),
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'header-info1'     => esc_html__('Header Info 1','blokco'),
					'header-info2'     => esc_html__('Header Info 2','blokco'),
					'header-info3'     => esc_html__('Header Info 3','blokco'),
					'social-icons'     => esc_html__('Social Icons','blokco'),
					'widgets-opener'   => esc_html__('Widgets opener','blokco')
				)
			),
		),
		array(
			'id'      => 'sticky_header_right_blocks',
			'required' => array('enable_sticky_header','=',1),
			'type'    => 'sorter',
			'title'   => 'Sticky header right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site sticky header. Selected blocks here will appear at the right side of header, for left side see above.','blokco'),
			'options' => array(
				'enabled'  => array(
					'menu' => esc_html__('Menu','blokco'),
				),
				'disabled' => array(
					'search'     => esc_html__('Search','blokco'),
					'cart'     => esc_html__('Cart','blokco'),
					'logo' => 'Logo',
					'featured-button1' => esc_html__('Featured Btn 1','blokco'),
					'featured-button2' => esc_html__('Featured Btn 2','blokco'),
					'featured-button3' => esc_html__('Featured Btn 3','blokco'),
					'header-info1'     => esc_html__('Header Info 1','blokco'),
					'header-info2'     => esc_html__('Header Info 2','blokco'),
					'header-info3'     => esc_html__('Header Info 3','blokco'),
					'social-icons'     => esc_html__('Social Icons','blokco'),
					'widgets-opener'   => esc_html__('Widgets opener','blokco')
				)
			),
		),
		array(
			'id'        => 'stickyh_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the sticky header of your website.','blokco'),
			'position'  => 'start',
		),
        array(
			'id'=>'stickyh_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Width', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the sticky header area to 100% of the browser width. Uncheck to follow site width.', 'blokco'),
			'default' => '0',
		),
        array(
			'id'=>'stickyh_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('stickyh_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the sticky header area to 100% of the browser width with no space on the sides.', 'blokco'),
			'default' => '0',
		),
		array(
			'id'       => 'sticky_header_height',
			'type'     => 'dimensions',
			'width'	   => false,
			'units' 	=> array('px'),
			'compiler'   => array('.theme-sticky-header,.theme-sticky-header .header-equaler, .theme-sticky-header .header-equaler > div > div'),
			'required' => array('enable_sticky_header','=',1),
			'title'    => esc_html__('Sticky header height', 'blokco'),
			'desc'     => esc_html__('Enter height for the sticky header, this is the maximum height of your site sticky header', 'blokco'),
			'default'  => array(
						'height' => '75px',
						'units' 	=> 'px',
					  )
		),
		array(  'id' => 'sticky_header_background',
			'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('enable_sticky_header','=',1),
			'compiler' => array('background-color' => '.theme-sticky-header'),
			'title' => esc_html__('Background', 'blokco'),
			'subtitle' => esc_html__('Background color', 'blokco'),
		),
		array(
			'id' => 'sticky_header_background_image',
			'type' => 'background',
			'transparent' => false,
			'background-color' => false,
			'compiler' => array('.theme-sticky-header'),
			'title' => esc_html__('Header background image', 'blokco')
		),
		array(
			'id'        => 'stickyh_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'stickyh_hinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the header info used for the sticky header.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'       => 'stickyh_header_info_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'text-align' => false,
			'title'    => esc_html__('Typography', 'blokco'),
			'desc'    => esc_html__('These options will affect the header info shown in the site sticky header only.', 'blokco'),
			'compiler'   => array('.theme-sticky-header .header_info_text')
		),
		array(
			'id'       => 'header_info_stickyh_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .header_info_text a'),
			'title'    => esc_html__('Links color', 'blokco'),
			'desc'    => __('These options will affect the links in header info shown in the site sticky header only.', 'blokco'),
		),
		array(
			'id'       => 'stickyh_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 1 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site sticky header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.theme-sticky-header .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'stickyh_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site sticky header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.theme-sticky-header .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'stickyh_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'blokco'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site sticky header. For auto width leave empty.', 'blokco'),
			'compiler'   => array('.theme-sticky-header .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'stickyh_hinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_sicons_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the social icons used for the sticky header.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'=>'stickyh_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'blokco'),
		),
		array(
			'id'=>'stickyh_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'blokco'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'blokco'),
		),
		array(
			'id'=>'stickyh_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'blokco'),
		),
		array(
			'id'       => 'stickyh_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('html .theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'blokco'),
		),
		array(
			'id'        => 'stickyh_sicons_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_menu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header menu style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the menu used for the sticky header.','blokco'),
			'position'  => 'start',
		),
        array(
            'id' => 'stickyh_menu_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'word-spacing' => true,
			'text-transform' => true,
			'line-height' => false,
			'compiler'      => array('.theme-sticky-header .sticky-menu > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul > li > a'),
			'title'    => esc_html__('Links Color', 'blokco'),
		),
		array(
			'id'       => 'stickyh_menu_link_active',
			'type'     => 'link_color',
			'hover'	   => false,
			'active'	   => false,
			'visited'	   => false,
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul > li.current-menu-item > a'),
			'title'    => esc_html__('Sticky header current menu link color', 'blokco'),
			'desc'     => esc_html__('Set the sticky header menu links color for active page.', 'blokco'),
		),
		array(
			'id'       => 'stickyh_menu_links_padding',
			'type'     => 'spacing',
			'mode'  => 'margin',
			'top'  => false,
			'bottom'  => false,
			'units'  => array('px'),
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul > li'),
			'title'    => esc_html__('Links spacing', 'blokco'),
		),
		array(
			'id'       => 'stickyh_menu_dd_bg',
			'type'     => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .sticky-menu > ul > li ul','border-bottom-color' => '.theme-sticky-header .sticky-menu > ul li ul:before'),
			'title'    => esc_html__('Dropdown background', 'blokco'),
		),
        array(
            'id' => 'stickyh_menu_dd_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Dropdown links typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'compiler'      => array('.theme-sticky-header .sticky-menu > ul li ul li a, .theme-sticky-header .sticky-menu > ul li ul li ul li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_menu_dd_links_padding',
			'type'     => 'spacing',
			'mode'  => 'padding',
			'units'  => array('px'),
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul li ul li a, .theme-sticky-header .sticky-menu > ul li ul li ul li a'),
			'title'    => esc_html__('Dropdown links spacing', 'blokco'),
		),
		array(
			'id'       => 'stickyh_menu_dd_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'title'    => esc_html__('Dropdown links color', 'blokco'),
		),
		array(
			'id'        => 'stickyh_menu_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_search_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'stickyh_ddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_ddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','blokco'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.theme-sticky-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','blokco'),
		),
		array(
			'id'   => 'stickyh_opensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','blokco'),
		),
		array(
			'id'   => 'stickyh_opensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','blokco'),
		),
		array(
			'id'=>'stickyh_opensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width and height for the search form.', 'blokco')
		),
		array(
			'id'=>'stickyh_opensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"],.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'blokco'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'blokco')
		),
        array(
            'id' => 'stickyh_opensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'stickyh_opensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'blokco'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_opensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'blokco'),
		),
		array(
			'id'        => 'stickyh_search_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_cart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the topbar','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_cart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','blokco')
		),
		array(
			'id'   => 'stickyh_cart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','blokco'),
		),
        array(
            'id' => 'stickyh_cart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_cart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'blokco'),
		),
		array(
			'id'   => 'stickyh_cart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-opened'),
			'title' => esc_html__('Open cart background','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-items'),
			'title' => esc_html__('Open cart border','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-opened'),
			'title' => esc_html__('Open cart border top','blokco'),
		),
		array(
			'id'       => 'stickyh_cart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'blokco'),
		),
        array(
            'id' => 'stickyh_cart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'stickyh_cart_opened_footer_bg',
    		'type' => 'color_rgba',
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','blokco'),
		),
		array(
			'id'   => 'stickyh_cart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','blokco'),
		),
		array(
			'id'       => 'stickyh_cart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'blokco'),
		),
        array(
            'id' => 'stickyh_cart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'stickyh_cart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_wopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','blokco'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the sticky header','blokco'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_wopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','blokco'),
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','blokco')
		),
		array(
			'id'   => 'stickyh_wopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .topper-opener'),
			'title' => esc_html__('Trigger button background','blokco'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','blokco'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'title' => esc_html__('Trigger button border','blokco'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','blokco'),
		),
        array(
            'id' => 'stickyh_wopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_wopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'blokco'),
		),
		array(
			'id'        => 'stickyh_wopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Mobile Header', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_mobile_header',
            'type' => 'switch',
            'title' => esc_html__('Mobile Header', 'blokco'),
            'subtitle' => esc_html__('Enable/Disable', 'blokco'),
            "default" => 1,
        ),
		array(
			'id'      => 'mobile_header_blocks',
			'required' => array('enable_mobile_header','=',1),
			'type'    => 'sorter',
			'title'   => 'Mobile header content',
			'class'   => 'custom-field-sorter',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site mobile header.','blokco'),
			'options' => array(
				'enabled'  => array(
					'logo-menu' 		=> esc_html__('Logo + Menu','blokco'),
				),
				'disabled' => array(
					'topmenu'			=> esc_html__('Topbar Menu','blokco'),
					'social-icons'     	=> esc_html__('Social Icons','blokco'),
					'featured-button1' 	=> esc_html__('Featured Btn 1','blokco'),
					'featured-button2' 	=> esc_html__('Featured Btn 2','blokco'),
					'featured-button3' 	=> esc_html__('Featured Btn 3','blokco'),
					'header-info1'     	=> esc_html__('Header Info 1','blokco'),
					'header-info2'     	=> esc_html__('Header Info 2','blokco'),
					'header-info3'     	=> esc_html__('Header Info 3','blokco')
				)
			),
		),
        array(
			'id'=>'mobile_header_cart',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show cart option', 'blokco'), 
			'subtitle' => esc_html__('Check this to show cart option at the right of menu in mobile header.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'=>'mobile_header_search',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show search option', 'blokco'), 
			'subtitle' => esc_html__('Check this to show search option at the right of menu in mobile header.', 'blokco'),
			'default' => 0,
		),
		array(
			'id' => 'mobile_header_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header'),
			'title' => esc_html__('Mobile header background color/image', 'blokco')
		),
		array(
			'id' => 'mobile_header_navbar_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .mobile-navbar'),
			'title' => esc_html__('Mobile header navbar background color/image', 'blokco'),
			'subtitle' => esc_html__('Choose color or image for the navbar in mobile header. This is the space where your mobile logo, menuopener, search and cart icons will appear.', 'blokco')
		),
		array(
			'id' => 'mobile_header_hinfo_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .header_info_text'),
			'title' => esc_html__('Mobile header header info background color/image', 'blokco'),
			'subtitle' => esc_html__('Choose color or image for the header info rows in mobile header.', 'blokco')
		),
		array(
			'id' => 'mobile_header_social_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .header-social-container'),
			'title' => esc_html__('Mobile header social icons row background color/image', 'blokco'),
			'subtitle' => esc_html__('Choose color or image for the social icons row in mobile header.', 'blokco')
		),
		array(
			'id' => 'mobile_header_topmenu_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .topbar-blocks'),
			'title' => esc_html__('Mobile header topbar menu row background color/image', 'blokco'),
			'subtitle' => esc_html__('Choose color or image for the topbar menu row in mobile header.', 'blokco')
		),
		array(
			'id' => 'mobile_header_separator',
			'type' => 'border',
			'compiler' => array('.theme-mobile-header .header-equaler, .theme-mobile-header .mobile-navbar, .theme-mobile-header .topbar-blocks'),
			'all' => false,
			'bottom' => false,
			'left' => false,
			'right' => false,
			'title' => esc_html__('Mobile header rows separator border', 'blokco'),
			'subtitle' => esc_html__('Choose border properties for rows in mobile header.', 'blokco')
		),
		array(
			'id' => 'mobile_header_row_spacing',
			'type' => 'spacing',
			'mode' => 'padding',
			'compiler' => array('.theme-mobile-header .header-equaler, .theme-mobile-header .mobile-navbar, .theme-mobile-header .topbar-blocks'),
			'units' => array('px'),
			'title' => esc_html__('Mobile header rows inside spacing', 'blokco'),
			'subtitle' => esc_html__('Set inside padding for the rows in mobile header.', 'blokco')
		),
        array(
            'id' => 'mobile_header_triggers_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Menu, search, cart icon links font size', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-mobile-header .cart-module-trigger, .theme-mobile-header .search-module-trigger, .theme-mobile-header .mmenu-toggle'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'mobile_header_triggers_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'title'    => esc_html__('Menu, search, cart icon links color', 'blokco'),
		),
		array(
			'id'       => 'mobile_logo_max_height',
			'type'     => 'dimensions',
			'width'  => false,
			'units'  => array('px'),
			'title'    => esc_html__('Mobile header logo maximum height', 'blokco'),
			'subtitle'    => esc_html__('Set a maximum height for the logo image of mobile header.', 'blokco'),
		),
        array(
            'id' => 'mobile_header_hinfo_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Header info typography for mobile header', 'blokco'),
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-mobile-header .header_info_text'),
			'units'       =>'px',
        ),
		array(
			'id'=>'mobile_header_menu_btn_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Menu button', 'blokco'), 
			'subtitle' => esc_html__('Choose how you want to show the menu opener button in mobile header.', 'blokco'),
			'options' => array(
				0 => esc_html__('Icon','blokco'),
				1 => esc_html__('Icon + Text','blokco'),
				2 => esc_html__('Text','blokco'),
			),
			'default' => 0,
		),
		array(
			'id'=>'mobile_header_menu_btn_text',
			'type' => 'text',
			'title' => esc_html__('Menu button text', 'blokco'), 
			'subtitle' => esc_html__('Enter the text you want to show for the menu link in mobile header.', 'blokco'),
			'required' => array('mobile_header_menu_btn_type','!=','0')
		),
		array(
			'id'   => 'mobile_header_menu_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-mobile-header .mobile-menu'),
			'title' => esc_html__('Mobile header menu background color','blokco'),
		),
        array(
            'id' => 'mobile_header_menu_links_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Mobile menu links typography', 'blokco'),
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'color'  => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
			'units'       =>'px',
        ),
        array(
            'id' => 'mobile_header_menu_links_spacing',
            'type'        => 'spacing',
			'title'       => esc_html__('Mobile menu links spacing', 'blokco'),
			'mode'	  => 'padding',
			'units'       =>'px',
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
        ),
		array(
			'id' => 'mobile_header_menu_links_separator',
			'type' => 'border',
			'compiler' => array('.theme-mobile-header .mobile-menu li a'),
			'all' => false,
			'top' => false,
			'left' => false,
			'right' => false,
			'title' => esc_html__('Mobile menu links separator border', 'blokco'),
			'subtitle' => esc_html__('Choose border properties for menu links in mobile header.', 'blokco')
		),
		array(
			'id'       => 'mobile_header_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
			'title'    => esc_html__('Mobile menu links color', 'blokco'),
		),
        array(
            'id' => 'mobile_header_smenu_opener_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Submenu opener icon size and color', 'blokco'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li.menu-item-has-children:after'),
			'units'       =>'px',
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Inner page header', 'blokco'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'       => 'global_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header global options', 'blokco'),
		),
        array(
			'id'=>'inner_page_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header on the inner pages/posts/custom posts. This can be used as default for all inner pages and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
    		'id' => 'inner_header_position',
    		'type' => 'image_select',
    		'compiler'=>true,
			'width' => '150px',
			'height' => '100px',
			'title' => esc_html__('Select position of inner page title', 'blokco'), 
			'subtitle' => esc_html__('Select from the option whether to show page title below the banner image/slider or over the banner image ', 'blokco'),
    			'options' => array(
					1 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/page-header-1.png'),
    				2 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/page-header-2.png')
    							),
    		'default' => 1,
    	),
		array(  
			'id' => 'inner_page_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the inner pages/posts header.', 'blokco'),
		),
		array(
			'id'=>'blokco_default_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the inner pages/posts header.', 'blokco'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'inner_page_header_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner pages header. DO NOT PUT px HERE', 'blokco'),
		),
		array(
			'id'       => 'inner_page_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner pages header.', 'blokco'),
			'default' => array(
				'padding-top' => '150px',
				'padding-bottom' => '150px'
			)
		),
        array(
			'id'=>'inner_page_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page title in the page banner. Uncheck to show. This can be used as default for all inner pages and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.page-banner-title,.floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('.page-banner-title'),
		),
		array(
			'id'       => 'title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_page_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body .page-banner-title h1'),
			'units'       =>'px',
			'default' => array(
				'text-align' => 'left'
			)
        ),
        array(
            'id' => 'inner_page_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body .page-banner-title p'),
			'units'       =>'px',
			'default' => array(
				'text-align' => 'left'
			)
        ),
		array(
			'id'       => 'global_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'posts_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for posts', 'blokco'),
		),
        array(
			'id'=>'inner_posts_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the blog posts. This can be used as default for all blog posts and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_posts_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-post .page-banner'),
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner page header for blog posts.', 'blokco'),
		),
		array(
			'id'       => 'inner_posts_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-post .page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for blog posts.', 'blokco'),
		),
		array(  
			'id' => 'default_post_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-post .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the blog posts header.', 'blokco'),
		),
		array(
			'id'=>'default_post_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default banner image', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the blog posts header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_posts_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide posts title in the page banner. Uncheck to show. This can be used as default for all blog posts and can override the individual page design options.', 'blokco'),
			'default' => 1,
		),
		array(  
			'id' => 'posts_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-post .page-banner-title,.floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'posts_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-post .page-banner-title'),
		),
		array(
			'id'       => 'posts_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-post .page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_posts_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-post .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_posts_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.singe-post .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'posts_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'projects_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for projects', 'blokco'),
		),
        array(
			'id'=>'inner_projects_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the projects. This can be used as default for all projects and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_projects_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_projects .page-banner'),
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner page header for project posts.', 'blokco'),
		),
		array(
			'id'       => 'inner_projects_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_projects .page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for project posts.', 'blokco'),
		),
		array(  
			'id' => 'default_projects_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_projects .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the projects header.', 'blokco'),
		),
		array(
			'id'=>'default_project_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default banner image', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the projects header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_projects_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide projects title in the page banner. Uncheck to show. This can be used as default for all projects and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'projects_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_projects .page-banner-title,body.single-imi_projects .floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'projects_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-imi_projects .page-banner-title'),
		),
		array(
			'id'       => 'projects_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-imi_projects .page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_projects_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_projects .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_projects_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_projects .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'projects_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		
		array(
			'id'       => 'events_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for events', 'blokco'),
		),
        array(
			'id'=>'inner_events_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the events. This can be used as default for all events and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_events_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-eventer .page-banner'),
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner page header for event posts.', 'blokco'),
		),
		array(
			'id'       => 'inner_events_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-eventer .page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for event posts.', 'blokco'),
		),
		array(  
			'id' => 'default_events_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-eventer .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the events header.', 'blokco'),
		),
		array(
			'id'=>'default_events_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default banner image', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the events header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_events_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide events title in the page banner. Uncheck to show. This can be used as default for all events and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'events_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-eventer .page-banner-title,body.single-eventer .floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'events_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-eventer .page-banner-title'),
		),
		array(
			'id'       => 'events_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-eventer .page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_events_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-eventer .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_events_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-eventer .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'events_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'services_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for services', 'blokco'),
		),
        array(
			'id'=>'inner_services_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the services. This can be used as default for all services and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_services_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_services .page-banner'),
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner page header for service posts.', 'blokco'),
		),
		array(
			'id'       => 'inner_services_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_services .page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for service posts.', 'blokco'),
		),
		array(  
			'id' => 'default_services_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_services .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the services header.', 'blokco'),
		),
		array(
			'id'=>'default_service_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Services', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the service posts header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_services_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide services title in the page banner. Uncheck to show. This can be used as default for all services and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'services_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_services .page-banner-title,body.single-imi_services .floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'services_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-imi_services .page-banner-title'),
		),
		array(
			'id'       => 'services_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-imi_services .page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_services_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_services .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_services_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_services .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'services_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'team_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for team posts', 'blokco'),
		),
        array(
			'id'=>'inner_team_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the team posts. This can be used as default for all team posts and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_team_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_team .page-banner'),
			'title'    => esc_html__('Default Height', 'blokco'),
			'subtitle' => esc_html__('Enter default height for the inner page header for team posts.', 'blokco'),
		),
		array(
			'id'       => 'inner_team_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_team .page-banner'),
			'title'    => esc_html__('Default spacing', 'blokco'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for team posts.', 'blokco'),
		),
		array(  
			'id' => 'default_team_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_team .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the team posts header.', 'blokco'),
		),
		array(
			'id'=>'default_team_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Team', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the team posts header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_team_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide team posts title in the page banner. Uncheck to show. This can be used as default for all team posts and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'team_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_team .page-banner-title,body.single-imi_team .floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'team_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-imi_team .page-banner-title'),
		),
		array(
			'id'       => 'team_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-imi_team.page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_team_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_team .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_team_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_team .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'team_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'products_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for products', 'blokco'),
		),
        array(
			'id'=>'inner_products_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide page header for the team posts. This can be used as default for all team posts and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'default_products_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-product .page-banner'),
			'title' => esc_html__('Default Banner Color', 'blokco'),
			'subtitle' => esc_html__('Background color for the products header.', 'blokco'),
		),
		array(
			'id'=>'default_product_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for WooCommerce products', 'blokco'),
			'subtitle' => esc_html__('Upload default banner image for the woocommerce product posts header.', 'blokco'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_products_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide products posts title in the page banner. Uncheck to show. This can be used as default for all products and can override the individual page design options.', 'blokco'),
			'default' => 0,
		),
		array(  
			'id' => 'products_title_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-product .page-banner-title,body.single-product .floated-page-titles .page-banner-title'),
			'title' => esc_html__('Default Background Color for title header', 'blokco'),
		),
        array(
			'id'          => 'products_title_header_border',
			'type'        => 'border',
			'title'       => esc_html__('Default border bottom for title header', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => false,
			'all' => false,
			'compiler'      => array('body.single-product .page-banner-title'),
		),
		array(
			'id'       => 'products_title_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('body.single-product .page-banner-title'),
			'title'    => esc_html__('Default spacing for title header', 'blokco'),
		),
        array(
            'id' => 'inner_products_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-product .page-banner-title h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_products_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-product .page-banner-title p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'products_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'breadcrumb_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Breadcrumbs styling', 'blokco'),
		),
        array(
			'id'=>'breadcrumb_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide breadcrumb', 'blokco'), 
			'subtitle' => esc_html__('Check this box to hide breadcrumbs from all inner pages. This can be used as default for all posts/pages and can override the individual page design options.', 'blokco'),
			'default' => 1,
		),
        array(
            'id' => 'inner_page_header_breadcrumb_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Breadcrumb typography', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('.breadcrumb'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_page_header_breadcrumb_links',
            'type'        => 'link_color',
			'title'       => esc_html__('Breadcrumb links color', 'blokco'),
			'visited' => false,
			'compiler'      => array('.breadcrumb a'),
        ),
		array(
			'id'       => 'breadcrumb_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'archives_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Archive pages title', 'blokco'),
		),
		array(
            'id' => 'project_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for projects archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the projects post type.', 'blokco'),
            'default' => 'Projects'
        ),
		array(
            'id' => 'event_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for events archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the events post type.', 'blokco'),
            'default' => 'Events'
        ),
		array(
            'id' => 'blog_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for blog archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the blog post type.', 'blokco'),
            'default' => 'Blog'
        ),
		array(
            'id' => 'service_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for services archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the services post type.', 'blokco'),
            'default' => 'Services'
        ),
		array(
            'id' => 'team_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for team archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the team post type.', 'blokco'),
            'default' => 'Team'
        ),
		array(
            'id' => 'shop_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for shop archive', 'blokco'),
            'subtitle' => esc_html__('Enter title of the archive page for the products/shop post type.', 'blokco'),
            'default' => 'Shop'
        ),
		array(
			'id'       => 'archives_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-down',
    'title' => esc_html__('Footer', 'blokco'),
    'desc' => esc_html__('These are the options for the footer.', 'blokco'),
    'fields' => array(
		array(
			'id'       => 'footer_vc_section_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('VC Section row', 'blokco'),
		),
        array(
            'id' => 'enable_footer_vc_section',
            'type' => 'checkbox',
            'title' => esc_html__('Enable footer VC Section area', 'blokco'),
            'subtitle' => esc_html__('Check this box to enable footer VC Section area. Create VC Section using visual composer page builder.', 'blokco'),
            "default" => 0,
        ),
		array(
			'id'       	=> 'footer_vc_section',
			'type'     	=> 'select',
			'title'    	=> esc_html__('VC Section', 'blokco'), 
			'desc'    	=> esc_html__('Select VC Section for your website footer.', 'blokco'),
			'data'  	=> 'posts',
			'args'  => array(
				'post_type'      => 'imi_vc_section',
				'posts_per_page' => -1,
				'orderby'        => 'title',
				'order'          => 'ASC',
			),
			'required' => array('enable_footer_vc_section','=','1')
		),
		array(
			'id'       => 'footer_vc_section_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'footer_widgets_area_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Widgets row', 'blokco'),
		),
        array(
            'id' => 'enable_footer_widgets',
            'type' => 'checkbox',
            'title' => esc_html__('Enable footer widgets area', 'blokco'),
            'subtitle' => esc_html__('Check this box to enable footer widgets area. Choose footer layout below.', 'blokco'),
            "default" => 1,
        ),
        array(
            'id' => 'full_width_footer',
            'type' => 'checkbox',
            'title' => esc_html__('100% width', 'blokco'),
            'subtitle' => esc_html__('Check this box to set footer width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'blokco'),
            "default" => 0,
        ),
        array(
			'id'=>'footer_top_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('full_width_footer','=','1'),
			'title' => esc_html__('No space on left/right', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the footer widgets area to 100% of the browser width with no space on the sides.', 'blokco'),
			'default' => 0,
		),
		array(
			'id'=>'footer_top_skin',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Skin', 'blokco'), 
			'options' => array(
					'footer-dark-skin' => esc_html__('Dark','blokco'),
					'footer-light-skin' => esc_html__('Light','blokco')
				),
			'default' => 'footer-dark-skin',
		),
		array(
    		'id' => 'footer_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Footer layout', 'blokco'), 
			'subtitle' => esc_html__('Select the footer widgeted area layout', 'blokco'),
    			'options' => array(
					1 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/footerColumns/footer-1.png'),
    				2 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/footerColumns/footer-2.png'),
    				3 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/footerColumns/footer-3.png'),
    				4 => array('title' => '', 'img' => get_template_directory_uri().'/assets/images/footerColumns/footer-4.png')
    							),
    		'default' => 4,
    	),
		array( 
			'id' => 'footer_background',
			'type' => 'background',
			'background-color'=> true,
			'compiler' => array('.site-footer.site-footer-top'),
			'title' => esc_html__('Background', 'blokco'),
    		'subtitle' => esc_html__('Background color or image for the footer widgets area.', 'blokco'),
		),
		array(
			'id'       => 'footer_top_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Top/Bottom padding', 'blokco'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer widgets area.', 'blokco'),
			'mode' 	   => 'padding',
			'compiler' => array('.site-footer-top'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'tfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Border top/bottom', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => true,
			'all' => false,
			'compiler'      => array('.site-footer-top'),
		),
        array(
			'id'          => 'widgettitle_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets title typography', 'blokco'),
			'compiler'      => array('.footer_widget .footer-widgettitle'),
		),
        array(
			'id'          => 'tfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets area text typography', 'blokco'),
			'compiler'      => array('.site-footer-top .footer_widget'),
		),
        array(
			'id'          => 'tfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer widgets area links color', 'blokco'),
			'compiler'      => array('.body .site-footer-top .footer_widget a'),
		),
		array(
			'id'       => 'footer_widgets_area_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'footer_copyrights_area_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Copyrights row', 'blokco'),
		),
        array(
            'id' => 'footer_bottom_enable',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Footer copyrights area', 'blokco'),
            'desc' => esc_html__('Uncheck to disable footer copyrights area that comes below the footer widgets area.', 'blokco'),
			'default' => 1
        ),
		array(
			'id'=>'footer_bottom_skin',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Skin', 'blokco'), 
			'options' => array(
					'footer-dark-skin' => esc_html__('Dark','blokco'),
					'footer-light-skin' => esc_html__('Light','blokco')
				),
			'default' => 'footer-dark-skin',
		),
        array(
            'id' => 'full_width_footer_bottom',
            'type' => 'checkbox',
            'title' => esc_html__('100% width', 'blokco'),
            'subtitle' => esc_html__('Check this box to set footer copyrights area width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'blokco'),
            'default' => 0,
        ),
        array(
			'id'=>'footer_bottom_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('full_width_footer_bottom','=','1'),
			'title' => esc_html__('No space on left/right', 'blokco'), 
			'subtitle' => esc_html__('Check this box to set the footer copyrights area to 100% of the browser width with no space on the sides.', 'blokco'),
			'default' => 0,
		),
        array(
			'id'          => 'bfooter_bg',
			'type'        => 'background',
			'title'       => esc_html__('Background', 'blokco'),
			'compiler'      => array('.footer-light-skin.site-footer-bottom,.footer-dark-skin.site-footer-bottom'),
		),
		array(
			'id'       => 'footer_bottom_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Top/Bottom padding', 'blokco'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer copyrights area. DO NOT ENTER px HERE.', 'blokco'),
			'mode' 	   => 'padding',
			'compiler' => array('.site-footer-bottom'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'bfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Border top/bottom', 'blokco'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => true,
			'all' => false,
			'compiler'      => array('.site-footer-bottom'),
		),
        array(
            'id' => 'footer_copyright_text',
            'type' => 'text',
            'title' => esc_html__('Footer Copyright Text', 'blokco'),
            'subtitle' => esc_html__(' Enter Copyright Text', 'blokco'),
            'default' => esc_html__('All Rights Reserved', 'blokco')
        ),
        array(
			'id'          => 'bfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'title'       => esc_html__('Footer copyrights area text typography', 'blokco'),
			'compiler'      => array('.site-footer-bottom p, .footer-dark-skin.site-footer-bottom p'),
		),
        array(
			'id'          => 'bfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer copyrights area links color', 'blokco'),
		),
		array(
			'id'=>'footer_bottom_cont_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Copyrights footer right', 'blokco'), 
			'subtitle' => esc_html__('Choose what to display at the right corner of copyrights footer area.', 'blokco'),
			'desc'     => esc_html__('If menu option is chosen then you can set a Menu for location "Footer Menu" at Appearance > Menus','blokco'),
			'options' => array(
				0 => esc_html__('Menu','blokco'),
				1 => esc_html__('Social Icons','blokco'),
				2 => esc_html__('None','blokco'),
			),
			'default' => '0',
		),
		array(
			'id' => 'footer_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'required' => array('footer_bottom_cont_type','=','1'),
			'title' => esc_html__('Social Links', 'blokco'),
			'desc' => esc_html__('Insert Social URL in their respective fields and sort as your desired order.', 'blokco'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-tripadvisor' => 'tripadvisor',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Email Address'
			),
		),
		array(
			'id'=>'footer_social_shape',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'blokco'), 
			'options' => array(
					'imi-social-icons-round' => esc_html__('Round','blokco'),
					'imi-social-icons-rounded' => esc_html__('Rounded','blokco'),
					'imi-social-icons-square' => esc_html__('Square','blokco'),
					'imi-social-icons-plain' => esc_html__('Plain','blokco')
				),
			'default' => 'imi-social-icons-round',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_size',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'blokco'), 
			'options' => array(
					'imi-social-icons-small' => esc_html__('Small','blokco'),
					'imi-social-icons-medium' => esc_html__('Medium','blokco'),
					'imi-social-icons-large' => esc_html__('Large','blokco'),
					'imi-social-icons-xlarge' => esc_html__('Extra Large','blokco'),
					'imi-social-icons-custom' => esc_html__('Custom','blokco')
				),
			'default' => 'imi-social-icons-small',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.site-footer-bottom .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'blokco'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'blokco'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.site-footer-bottom .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'blokco'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'blokco'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.site-footer-bottom .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'blokco'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Footer social icons style', 'blokco'), 
			'options' => array(
					'imi-social-icons-bc' => esc_html__('Brand colors','blokco'),
					'imi-social-icons-tc' => esc_html__('Theme primary color','blokco'),
					'imi-social-icons-sc' => esc_html__('Theme secondary color','blokco'),
					'imi-social-icons-gc' => esc_html__('Grayscale','blokco')
				),
			'default' => 'imi-social-icons-sc',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_hover_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Footer social icons hover style', 'blokco'), 
			'options' => array(
					'imi-social-icons-hover-bc' => esc_html__('Brand colors','blokco'),
					'imi-social-icons-hover-tc' => esc_html__('Theme primary color','blokco'),
					'imi-social-icons-hover-sc' => esc_html__('Theme secondary color','blokco'),
					'imi-social-icons-hover-gc' => esc_html__('Grayscale','blokco')
				),
			'default' => 'imi-social-icons-hover-gc',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'       => 'footer_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.site-footer-bottom .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'blokco'),
		),
		array(
			'id'       => 'footer_copyrights_area_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Sidebars', 'blokco'),
    'fields' => array(
        array(
    		'id' => 'sidebar_position',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Sidebar position','blokco'), 
			'subtitle' => esc_html__('Select the Global Sidebar Position. Can be overridden by page sidebar settings.', 'blokco'),
    			'options' => array(
    				'2' => array('title' => 'Left', 'img' => get_template_directory_uri().'/assets/images/2cl.png'),
					'1' => array('title' => 'Right', 'img' => get_template_directory_uri().'/assets/images/2cr.png')
    				),
    		'default' => '1'
    	),
        array(
			'id'          => 'sidebar_bg',
			'type'        => 'background',
			'title'       => esc_html__('Sidebar Background', 'blokco'),
			'compiler'      => array('.sidebar-col-in'),
			'default' => array(
				'background-color' => ''
			)
		),
		array(
			'id'       => 'sidebar_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Sidebar inside padding', 'blokco'),
            'desc' => esc_html__('Enter padding values for the sidebar inside area. DO NOT ENTER px HERE.', 'blokco'),
			'mode' 	   => 'padding',
			'compiler' => array('.sidebar-col-in'),
			'units'    => array('px'),
			'default' => array(
				'padding-top' => '0',
				'padding-right' => '0',
				'padding-bottom' => '0',
				'padding-left' => '0'
			)
		),
        array(
			'id'          => 'sidebar_widget_bg',
			'type'        => 'background',
			'title'       => esc_html__('Sidebar Widgets Background', 'blokco'),
			'compiler'      => array('#sidebar-col .widget_categories, #sidebar-col .widget_archive, #sidebar-col .widget_recent_entries, #sidebar-col .widget_recent_comments, #sidebar-col .widget_links, #sidebar-col .widget_meta, #sidebar-col .widget_nav_menu, #sidebar-col .PI_SimpleTwitterTweets, #sidebar-col .widget_imi_recent_post, #sidebar-col .widget_product_categories, #sidebar-col .widget_pages , #sidebar-col .widget_rss, #sidebar-col .widget_custom_category, #sidebar-col .imi_flickr_widget, #sidebar-col .widget_search, #sidebar-col .widget_product_search, #sidebar-col .widget_tag_cloud,#sidebar-col .widget_price_filter'),
			'default' => array(
			)
		),
		array(
			'id'       => 'sidebar_widget_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Sidebar widgets inside padding', 'blokco'),
            'desc' => esc_html__('Enter padding values for the sidebar widgets inside area. DO NOT ENTER px HERE.', 'blokco'),
			'mode' 	   => 'padding',
			'compiler' => array('#sidebar-col .widget_categories, #sidebar-col .widget_archive, #sidebar-col .widget_recent_entries, #sidebar-col .widget_recent_comments, #sidebar-col .widget_links, #sidebar-col .widget_meta, #sidebar-col .widget_nav_menu, #sidebar-col .PI_SimpleTwitterTweets, #sidebar-col .widget_imi_recent_post, #sidebar-col .widget_product_categories, #sidebar-col .widget_pages , #sidebar-col .widget_rss, #sidebar-col .widget_custom_category, #sidebar-col .imi_flickr_widget, #sidebar-col .widget_search, #sidebar-col .widget_product_search, #sidebar-col .widget_tag_cloud,#sidebar-col .widget_price_filter'),
			'units'    => array('px'),
			'default' => array(
				'padding-top' => '30px',
				'padding-right' => '30px',
				'padding-bottom' => '30px',
				'padding-left' => '30px'
			)
		),
		array(
			'id'       => 'sidebar_widget_border',
			'type'     => 'border',
			'title'    => esc_html__('Sidebar widgets border', 'blokco'),
            'desc' => esc_html__('Enter border values for the sidebar widgets. DO NOT ENTER px HERE.', 'blokco'),
			'compiler' => array('#sidebar-col .widget_categories, #sidebar-col .widget_archive, #sidebar-col .widget_recent_entries, #sidebar-col .widget_recent_comments, #sidebar-col .widget_links, #sidebar-col .widget_meta, #sidebar-col .widget_nav_menu, #sidebar-col .PI_SimpleTwitterTweets, #sidebar-col .widget_imi_recent_post, #sidebar-col .widget_product_categories, #sidebar-col .widget_pages , #sidebar-col .widget_rss, #sidebar-col .widget_custom_category, #sidebar-col .imi_flickr_widget, #sidebar-col .widget_search, #sidebar-col .widget_product_search, #sidebar-col .widget_tag_cloud,#sidebar-col .widget_price_filter'),
			'units'    => array('px'),
			'default' => array(
				'border-width' => '1px',
				'border-color' => '#eeeeee',
				'border-style' => 'sloid'
			)
		),
		array(
			'id'       => 'page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Pages Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all single posts.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Archive/Category Pages Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all blog posts category/archive pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all single project pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Archive/Category Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all project posts category pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'event_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Event Posts Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all single event pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'event_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Event Posts Archive/Category Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all event posts category pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all single service pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Archive/Category Pages Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all service posts category pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Archive/Category Pages Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts category pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'search_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Search Page Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar for search results page.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'product_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Shop page Sidebar', 'blokco'), 
			'desc'     => esc_html__('Select sidebar for Woocommerce default shop and products archive/category pages.', 'blokco'),
			'data'  => 'sidebars',
			'default'  => '',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-brush',
    'title' => esc_html__('Color Scheme', 'blokco'),
    'fields' => array(
		array(
			'id'=>'theme_color_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Color scheme', 'blokco'), 
			'options' => array(
					'0' => esc_html__('Pre-Defined Color Schemes','blokco'),
					'1' => esc_html__('Custom Color','blokco')
				),
			'default' => '0',
		),
        array(
            'id' => 'theme_color_scheme',
            'type' => 'select',
			'required' => array('theme_color_type','equals','0'),
            'title' => esc_html__('Theme Color Scheme', 'blokco'),
            'subtitle' => esc_html__('Select from pre built color schemes.', 'blokco'),
            'options' => array('color1.css' => 'color1.css', 'color2.css' => 'color2.css', 'color3.css' => 'color3.css', 'color4.css' => 'color4.css', 'color5.css' => 'color5.css', 'color6.css' => 'color6.css', 'color7.css' => 'color7.css', 'color8.css' => 'color8.css', 'color9.css' => 'color9.css', 'color10.css' => 'color10.css'),
            'default' => 'color1.css',
        ),
		array(
			'id'=>'primary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Primary theme color', 'blokco'), 
			'validate' => 'color',
			'transparent' => false,
		),
		array(
			'id'=>'secondary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Secondary theme color', 'blokco'), 
			'validate' => 'color',
			'transparent' => false,
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-font',
    'title' => esc_html__('Typography', 'blokco'),
    'subtitle' => esc_html__('Global Font Family Sets', 'blokco'),
	'desc' => esc_html__('These options are as per the design which consists of 3 fonts. For more advanced typography options see Sub Sections below this in Left Sidebar. Make sure you set these options only if you have knowledge about every property to avoid disturbing the whole layout. If something went wrong just reset this section to reset all fields in Typography Options or click the small cross signs in each select field/delete text from input fields to reset them.', 'blokco'),
    'fields' => array(
        array(
            'id' => 'heading_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Heading font', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => false,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'compiler'      => array('h1,h2,h3,h4,h5,h6,.dd-menu,.eventer .eventer-event-title,.eventer .eventer-btn, .eventer .eventer-btn:disabled, .eventer .eventer-btn:disabled:hover, .eventer label:not(.eventer-checkbox):not(.eventer-radio), .eventer-twelve-months li, .eventer-event-date > span, .eventer-actions li, .eventer-ticket-type-name, .eventer-event-share > li:first-child, .eventer-event-save > span, .eventer-countdown .eventer-countdown-timer > .eventer-timer-col,.eventer-switcher-current-month,.eventer .eventer-switcher-actions-view a'),
			'units'       =>'px',
            'subtitle' => esc_html__('Choose font family for Headings', 'blokco'),
            'default' => array(
            	'font-family' => 'Lato'
            ),
        ),
        array(
            'id' => 'body_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body/Primary font', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => false,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'compiler'      => array('body,.eventer'),
			'units'       =>'px',
	    	'subtitle' => esc_html__('Choose font family for Body.', 'blokco'),
            'default' => array(
             	'font-family' => 'Roboto'
              ),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('More Options', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'body_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('body'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for body text', 'blokco'),
        ),
        array(
            'id' => 'h1_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H1 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h1'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H1 title', 'blokco'),
        ),
        array(
            'id' => 'h2_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H2 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h2'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H2 title', 'blokco'),
        ),
        array(
            'id' => 'h3_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H3 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H3 title', 'blokco'),
        ),
        array(
            'id' => 'h4_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H4 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h4,.services-list li h4,.blog-posts .post h4,.team-item h4,.services-list li h4'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H4 title', 'blokco'),
        ),
        array(
            'id' => 'h5_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H5 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h5'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H5 title', 'blokco'),
        ),
        array(
            'id' => 'h6_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H6 Title', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h6'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H6 title', 'blokco'),
        ),
        array(
            'id' => 'buttons_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Button', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => false,
			'letter-spacing' => true,
			'compiler'      => array('.btn-default, .btn-primary, .btn-success, .btn-info, .btn-warning, .btn-danger, input[type="button"], input[type="submit"], button, .button,.vc_general.vc_btn3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for buttons', 'blokco'),
        ),
        array(
            'id' => 'basic_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Basic Link', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => false,
			'letter-spacing' => true,
			'compiler'      => array('.basic-link'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for links using basic-link class', 'blokco'),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Additional Styles', 'blokco'),
    'desc' => esc_html__('Choose and select font families and styles for Google Fonts that are not loaded with the primary typography options. For example add different weight and style for a same font family you choose for your Typography options above.', 'blokco'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'nowhere_font1',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 1', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'font-weight' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Lato',
				'font-weight' => '400',
               ),
        ),
        array(
            'id' => 'nowhere_font2',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 2', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Lato',
				'font-weight' => '400',
				'font-style' => 'italic',
            ),
        ),
        array(
            'id' => 'nowhere_font3',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 3', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Lato',
				'font-weight' => '700',
               ),
        ),
        array(
            'id' => 'nowhere_font4',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 4', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Lato',
				'font-weight' => '700',
				'font-style' => 'italic',
               ),
        ),
        array(
            'id' => 'nowhere_font5',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 5', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            ),
        ),
        array(
            'id' => 'nowhere_font6',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 6', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            ),
        ),
        array(
            'id' => 'nowhere_font7',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 7', 'blokco'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            ),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-edit',
    'title' => esc_html__('Blog', 'blokco'),
	'desc' => esc_html__('These options are the options for posts page set at Settings > Reading which use index.php template.', 'blokco'),
    'fields' => array(
		array(
            'id' => 'blog_content_type',
            'type' => 'select',
            'title' => esc_html__('Posts content type', 'blokco'),
            'subtitle' => esc_html__('If content is chosen then the full content of posts will be shown until the MORE tag which can be inserted in the post content.', 'blokco'),
            'options' => array(0 => 'Content', 1 => 'Excerpt'),
            'default' => 1,
        ),
		array(
			'id'       => 'blog_excerpt_words',
			'type'     => 'text',
			'required' => array('blog_content_type','equals',1),
			'title'    => esc_html__('Number of words to show as excerpt', 'blokco'),
			'default' => 40
		),
		array(
			'id'       => 'blog_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_read_more_btn',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show read more button?', 'blokco'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Single Post', 'blokco'),
	'desc' => esc_html__('These options are the options for single post page template which use single.php template.', 'blokco'),
    'fields' => array(
		array(
			'id'       => 'blog_post_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_thumbnail',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post media?', 'blokco'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'blokco'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-error',
    'title' => esc_html__('404 Page', 'blokco'),
    'fields' => array(
		array(
			'id'=>'page_404_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Page header image', 'blokco'),
			'subtitle' => esc_html__('Upload image to show on the page header of the 404 error page.', 'blokco'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'page_404_banner_height',
			'type'     => 'dimensions',
			'title'    => esc_html__('Page header height', 'blokco'),
			'compiler'   => array('.error404 .page-banner'),
			'width' => false,
			'default' => array(
				'height' => '200px',
				'unit' => 'px',
			)
		),
		array(
            'id' => 'page_404_title',
            'type' => 'text',
            'title' => esc_html__('Page title', 'blokco'),
            'desc' => esc_html__('Enter title for 404 error page. Default is 404 Error.', 'blokco'),
        ),
		array(
            'id' => 'page_404_title_color',
            'type' => 'color',
			'compiler' => array('.error404 .page-banner-title h1'),
            'title' => esc_html__('Page title color', 'blokco'),
        ),
		array(
            'id' => 'page_404_content',
            'type' => 'editor',
            'title' => esc_html__('Page content', 'blokco'),
            'desc' => esc_html__('Enter text/html content for 404 error page.', 'blokco'),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-css',
    'title' => esc_html__('Custom CSS/JS', 'blokco'),
    'fields' => array(
        array(
            'id' => 'custom_css',
            'type' => 'ace_editor',	
            'title' => esc_html__('CSS Code', 'blokco'),
            'subtitle' => esc_html__('Paste your CSS code here.', 'blokco'),
            'mode' => 'css',
            'theme' => 'monokai',
            'desc' => '',
            'default' => ""
        ),
        array(
            'id' => 'custom_js',
            'type' => 'ace_editor',
            //'required' => array('layout','equals','1'),	
            'title' => esc_html__('JS Code', 'blokco'),
            'subtitle' => esc_html__('Paste your JS code here.', 'blokco'),
            'mode' => 'javascript',
            'theme' => 'chrome',
            'desc' => '',
            'default' => ""
        )
    ),
));
Redux::setSection( $opt_name, array(
	  'title' => esc_html__('Import / Export', 'blokco'),
	  'desc' => esc_html__('Import and Export your Theme Framework settings from file, text or URL.', 'blokco'),
	  'icon' => 'el-icon-download',
	  'fields' => array(
		  array(
			  'id' => 'opt-import-export',
			  'type' => 'import_export',
			 'title' => esc_html__('Import Export','blokco'),
			  'subtitle' => esc_html__('Save and restore your Theme options','blokco'),
			  'full_width' => false,
		  ),
	  ),
));
add_filter('redux/options/' . $opt_name . '/compiler', 'blokco_compiler_action', 10, 3);
if ( ! function_exists( 'blokco_compiler_action' ) ) {
  	function blokco_compiler_action( $options, $css, $changed_values ) {
      	global $wp_filesystem;
		$blog_id = get_current_blog_id();
    	$filename = BLOKCO_FILEPATH . '/assets/css/custom-option_'.$blog_id.'.css';
    	if( empty( $wp_filesystem ) ) {
        	require_once ABSPATH .'/wp-admin/includes/file.php';
        	WP_Filesystem();
    	}

    	if( $wp_filesystem ) {
        	$wp_filesystem->put_contents(
            	$filename,
            	$css,
				FS_CHMOD_FILE // predefined mode settings for WP files
        	);
    	}
    }
}

/*
* <--- END SECTIONS
*/