<?php
/*
 *   IMI MEGA MENU FRAMEWORK
 *   Copyright imithemes 2018-19 - www.imithemes.com
 *   ------------------------------------------------
 */
class imi_mega_menu {
    /* --------------------------------------------*
     * Constructor
     * -------------------------------------------- */
    /**
     * Initializes the menu by setting localization, filters, and administration functions.
     */
    function __construct() {
        // add custom menu fields to menu
        
        add_filter('wp_setup_nav_menu_item', array($this, 'imi_mega_menu_add_custom_nav_fields'));
        // save menu custom fields
        add_action('wp_update_nav_menu_item', array($this, 'imi_mega_menu_update_custom_nav_fields'), 10, 3);
        // edit menu walker
        add_filter('wp_edit_nav_menu_walker', array($this, 'imi_mega_menu_edit_walker'), 10, 2);
    }
    // end constructor
    /**
     * Add custom fields to $item nav object
     * in order to be used in custom Walker
     *
     * @access      public
     * @since       1.3 
     * @return      void
     */
    function imi_mega_menu_add_custom_nav_fields($menu_item) {
        $menu_item->ismega = get_post_meta($menu_item->ID, '_menu_is_mega', true);
		$menu_item->menuvcsections = get_post_meta($menu_item->ID, '_menu_vcsections', true);
        return $menu_item;
    }
    /**
     * Save menu custom fields
     *
     * @access      public
     * @since       1.3 
     * @return      void
     */
    function imi_mega_menu_update_custom_nav_fields($menu_id, $menu_item_db_id, $args) {
        // Check if element is properly sent
        if (isset($_REQUEST['menu-is-mega'][$menu_item_db_id]) && $_REQUEST['menu-is-mega'][$menu_item_db_id] == 1) {
            update_post_meta($menu_item_db_id, '_menu_is_mega', 1);
        } else {
            update_post_meta($menu_item_db_id, '_menu_is_mega', 0);
        }
        if (isset($_REQUEST['menu-vcsections'][$menu_item_db_id]) && !empty($_REQUEST['menu-vcsections'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, '_menu_vcsections', $_REQUEST['menu-vcsections'][$menu_item_db_id]);
        } 
    }
    /**
     * Define new Walker edit
     *
     * @access      public
     * @since       1.3 
     * @return      void
     */
    function imi_mega_menu_edit_walker($walker, $menu_id) {
        return 'Walker_Nav_Menu_Edit_Custom';
    }
}
// instantiate plugin's class
$GLOBALS['imi_mega_menu'] = new imi_mega_menu();
require_once plugin_dir_path( __FILE__ ) . 'edit_custom_walker.php';
require_once plugin_dir_path( __FILE__ ) . 'custom_walker.php';
?>